/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileEntityItemCapacity
extends TileEntity {
    private final int slotsSize;
    protected ItemStackHandler inventory;
    private ItemStackHandler inventoryIO;

    protected TileEntityItemCapacity(int slot) {
        this.slotsSize = slot;
        this.inventory = new ItemStackHandler(this.slotsSize){

            protected void onContentsChanged(int slot) {
                TileEntityItemCapacity.this.func_70296_d();
                TileEntityItemCapacity.this.onSlotChange(slot);
            }
        };
        this.inventoryIO = new ItemStackHandler(this.slotsSize){

            protected void onContentsChanged(int slot) {
                TileEntityItemCapacity.this.func_70296_d();
            }

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                TileEntityItemCapacity.this.inventory.setStackInSlot(slot, stack);
            }

            public int getSlots() {
                return TileEntityItemCapacity.this.inventory.getSlots();
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return TileEntityItemCapacity.this.inventory.getStackInSlot(slot);
            }

            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return TileEntityItemCapacity.this.insertItem(slot, stack, simulate);
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return TileEntityItemCapacity.this.extractItem(slot, amount, simulate);
            }
        };
    }

    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        super.func_145839_a(compound);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)this.inventory;
            }
            return (T)this.inventoryIO;
        }
        return (T)super.getCapability(capability, facing);
    }

    protected void onSlotChange(int slot) {
    }
}

