/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.buffer;

import com.enderio.core.client.gui.widget.TextFieldEnder;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.machine.gui.GuiInventoryMachineBase;
import crazypants.enderio.base.machine.gui.PowerBar;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.machines.EnderIOMachines;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.buffer.ContainerBuffer;
import crazypants.enderio.machines.machine.buffer.PacketBufferIO;
import crazypants.enderio.machines.machine.buffer.TileBuffer;
import crazypants.enderio.machines.network.PacketHandler;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiBuffer
extends GuiInventoryMachineBase<TileBuffer> {
    @Nonnull
    private static final String TEXTURE_FULL = "buffer_full";
    private TextFieldEnder maxInput;
    private TextFieldEnder maxOutput;
    private int lastInput;
    private int lastOutput;
    private int lastInputTe;
    private int lastOutputTe;
    private final boolean hasInventory;
    private final boolean hasPower;

    public GuiBuffer(@Nonnull InventoryPlayer par1InventoryPlayer, @Nonnull TileBuffer te) {
        super(te, (Container)new ContainerBuffer(par1InventoryPlayer, te), TEXTURE_FULL);
        this.hasInventory = te.hasInventory();
        this.hasPower = te.hasPower();
        this.redstoneButton.setPosition(153, 14);
        this.configB.setPosition(153, 32);
        if (this.hasPower) {
            int x = this.isFull() ? 32 : 58;
            int y = this.field_147009_r + 28;
            this.maxInput = new TextFieldEnder(this.getFontRenderer(), x, y, 60, 12);
            this.maxOutput = new TextFieldEnder(this.getFontRenderer(), x, y += 29, 60, 12);
            this.textFields.add((Object)this.maxInput);
            this.textFields.add((Object)this.maxOutput);
            this.addDrawingElement(new PowerBar(te, this, 16, 15, 40){

                @Override
                protected String getPowerOutputLabel(@Nonnull String rft) {
                    return Lang.GUI_BUFFER_MAXIO.get(LangPower.RFt(((TileBuffer)GuiBuffer.this.getTileEntity()).getMaxIO()));
                }
            });
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.hasPower) {
            this.maxInput.func_146203_f(10);
            this.maxInput.func_146180_a(LangPower.format(((TileBuffer)this.getTileEntity()).getMaxInput()));
            this.maxOutput.func_146203_f(10);
            this.maxOutput.func_146180_a(LangPower.format(((TileBuffer)this.getTileEntity()).getMaxOutput()));
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        if (par1 == 'e') {
            super.func_73869_a(par1, 1);
        }
        if (this.hasPower) {
            this.updateInputOutput();
        }
    }

    private void updateInputOutput() {
        int output;
        boolean changed = false;
        int input = LangPower.parsePower((GuiTextField)this.maxInput);
        if (input != this.lastInput) {
            this.lastInput = input;
            changed = true;
        }
        if ((output = LangPower.parsePower((GuiTextField)this.maxOutput)) != this.lastOutput) {
            this.lastOutput = output;
            changed = true;
        }
        if (changed) {
            this.sendUpdateToServer();
            this.maxInput.func_146180_a(LangPower.format(((TileBuffer)this.getTileEntity()).getMaxInput()));
            this.maxOutput.func_146180_a(LangPower.format(((TileBuffer)this.getTileEntity()).getMaxOutput()));
        }
    }

    private void checkForTeChanges() {
        if (this.hasPower) {
            if (((TileBuffer)this.getTileEntity()).getMaxInput() != this.lastInputTe) {
                this.lastInputTe = ((TileBuffer)this.getTileEntity()).getMaxInput();
                this.maxInput.func_146180_a(LangPower.format(this.lastInputTe));
            }
            if (((TileBuffer)this.getTileEntity()).getMaxOutput() != this.lastOutputTe) {
                this.lastOutputTe = ((TileBuffer)this.getTileEntity()).getMaxOutput();
                this.maxOutput.func_146180_a(LangPower.format(this.lastOutputTe));
            }
        }
    }

    protected void sendUpdateToServer() {
        PacketHandler.sendToServer((IMessage)new PacketBufferIO((TileBuffer)this.getTileEntity(), this.lastInput, this.lastOutput));
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        this.checkForTeChanges();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        this.bindGuiTexture();
        if (this.hasPower) {
            this.drawPowerBg(sx, sy + 2);
        }
        if (this.hasInventory) {
            this.drawSlotBg(sx, sy);
        }
        super.func_146976_a(par1, par2, par3);
        String invName = EnderIOMachines.lang.localizeExact(((TileBuffer)this.getTileEntity()).getMachineName() + ".name");
        this.getFontRenderer().func_175063_a(invName, (float)(sx + this.field_146999_f / 2 - this.getFontRenderer().func_78256_a(invName) / 2), (float)(sy + 4), 0xFFFFFF);
        if (this.hasPower) {
            this.getFontRenderer().func_175063_a(Lang.GUI_BUFFER_IN.get(), (float)(sx += this.isFull() ? 32 : 58), (float)(sy += 17), 0xFFFFFF);
            this.getFontRenderer().func_175063_a(Lang.GUI_BUFFER_OUT.get(), (float)sx, (float)(sy + 29), 0xFFFFFF);
        }
    }

    boolean isFull() {
        return this.hasInventory && this.hasPower;
    }

    @Override
    public void renderSlotHighlights(@Nonnull IoMode mode) {
        if (!this.hasInventory) {
            return;
        }
        for (int slot = 0; slot < ((TileBuffer)this.getTileEntity()).getSizeInventory(); ++slot) {
            this.renderSlotHighlight(slot, mode);
        }
    }

    protected void renderSlotHighlight(int slot, IoMode mode) {
        Slot invSlot = (Slot)this.field_147002_h.field_75151_b.get(slot);
        if (mode == IoMode.PULL) {
            this.renderSlotHighlight(slot, PULL_COLOR);
        } else if (mode == IoMode.PUSH) {
            this.renderSlotHighlight(slot, PUSH_COLOR);
        } else if (mode == IoMode.PUSH_PULL) {
            this.renderSplitHighlight(invSlot.field_75223_e, invSlot.field_75221_f, 16, 16);
        }
    }

    protected void renderSplitHighlight(int x, int y, int widthIn, int heightIn) {
        GL11.glEnable((int)3042);
        RenderUtil.renderQuad2D((double)(this.getGuiLeft() + x), (double)(this.getGuiTop() + y), (double)0.0, (double)widthIn, (double)(heightIn / 2), (Vector4f)PULL_COLOR);
        RenderUtil.renderQuad2D((double)(this.getGuiLeft() + x), (double)(this.getGuiTop() + y + heightIn / 2), (double)0.0, (double)widthIn, (double)(heightIn / 2), (Vector4f)PUSH_COLOR);
        GL11.glDisable((int)3042);
    }

    private void drawPowerBg(int sx, int sy) {
        this.func_73729_b(sx + 14, sy + 12, this.field_146999_f + 10, 0, 12, 44);
        if (!((TileBuffer)this.getTileEntity()).isCreative()) {
            this.func_73729_b(sx + 11, sy + 59, this.field_146999_f, 54, 19, 19);
        }
    }

    private void drawSlotBg(int sx, int sy) {
        this.func_73729_b(sx + (this.isFull() ? 95 : 61), sy + 14, this.field_146999_f + 22, 0, 54, 54);
    }
}

