/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.items.ModItems;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.jetbrains.annotations.NotNull;

public class TileEntityBarrel
extends TileEntity
implements ITickable {
    private boolean done = false;
    private int items = 0;
    private int timer = 0;
    public static final int MAX_ITEMS = 64;
    private static final int TIMER_END = 24000;
    private static final int AVERAGE_TICKS = 20;

    public void func_73660_a() {
        World world = this.func_145831_w();
        if (!world.field_72995_K && world.func_72820_D() % (long)(world.field_73012_v.nextInt(40) + 1) == 0L) {
            this.updateTick(world, this.func_174877_v(), world.func_180495_p(this.func_174877_v()), new Random());
        }
    }

    public void updateTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (this.getItems() == 64) {
            this.doBarrelCompostTick(worldIn, pos, state);
        }
        if (this.done) {
            ((WorldServer)worldIn).func_175739_a(EnumParticleTypes.VILLAGER_HAPPY, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.5, (double)this.func_174877_v().func_177952_p() + 0.5, 1, 0.2, 0.0, 0.2, 0.0, new int[0]);
        }
    }

    private void doBarrelCompostTick(World worldIn, BlockPos pos, IBlockState blockState) {
        ++this.timer;
        if (this.timer >= 1200) {
            this.timer = 0;
            this.items = 0;
            this.done = true;
            this.updateBlock(worldIn, blockState);
        }
    }

    public boolean useBarrel(World worldIn, EntityPlayer playerIn, ItemStack itemstack, IBlockState state, BlockPos pos) {
        if (this.done) {
            playerIn.field_71071_by.func_70441_a(new ItemStack(ModItems.compost, 6));
            this.done = false;
            return true;
        }
        if (!TileEntityBarrel.checkCorrectItem(itemstack)) {
            return false;
        }
        if (this.items == 64) {
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("entity.barrel.working", new Object[0]));
            return false;
        }
        this.consumeNeededItems(itemstack);
        return true;
    }

    private void consumeNeededItems(ItemStack itemStack) {
        int factor = itemStack.func_77973_b().getRegistryName().toString().contains("sapling") || itemStack.func_77973_b().getRegistryName().toString().contains("seed") ? 1 : 2;
        int availableItems = itemStack.func_190916_E() * factor;
        int neededItems = 64 - this.items;
        int itemsToRemove = Math.min(neededItems, availableItems);
        this.items += itemsToRemove;
        ItemStackUtils.changeSize(itemStack, -(itemsToRemove /= factor));
    }

    public static boolean checkCorrectItem(ItemStack itemStack) {
        return ColonyManager.getCompatibilityManager().isCompost(itemStack);
    }

    public void updateBlock(World worldIn, IBlockState state) {
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.func_70296_d();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("items", this.items);
        compound.func_74768_a("timer", this.timer);
        compound.func_74757_a("done", this.done);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.items = compound.func_74762_e("items");
        this.timer = compound.func_74762_e("timer");
        this.done = compound.func_74767_n("done");
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    @NotNull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.func_145839_a(compound);
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public final void handleUpdateTag(NBTTagCompound tag) {
        this.items = tag.func_74762_e("items");
        this.timer = tag.func_74762_e("timer");
        this.done = tag.func_74767_n("done");
    }

    public int getItems() {
        return this.items;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean checkIfWorking() {
        return this.items == 64;
    }

    public boolean addItem(ItemStack item) {
        if (TileEntityBarrel.checkCorrectItem(item)) {
            if (this.items < 64) {
                this.consumeNeededItems(item);
                this.updateBlock(this.field_145850_b, this.field_145850_b.func_180495_p(this.field_174879_c));
                return true;
            }
        }
        return false;
    }

    public ItemStack retrieveCompost(double multiplier) {
        if (this.done) {
            this.done = false;
            this.updateBlock(this.field_145850_b, this.field_145850_b.func_180495_p(this.field_174879_c));
            return new ItemStack(ModItems.compost, (int)(6.0 * multiplier));
        }
        return ItemStack.field_190927_a;
    }
}

