/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.proxy;

import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structurize.client.gui.WindowBuildTool;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.client.gui.WindowCitizen;
import com.minecolonies.coremod.client.gui.WindowClipBoard;
import com.minecolonies.coremod.client.gui.WindowMinecoloniesBuildTool;
import com.minecolonies.coremod.client.gui.WindowResourceList;
import com.minecolonies.coremod.client.render.EmptyTileEntitySpecialRenderer;
import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.client.render.RenderFishHook;
import com.minecolonies.coremod.client.render.TileEntityInfoPosterRenderer;
import com.minecolonies.coremod.client.render.TileEntityScarecrowRenderer;
import com.minecolonies.coremod.client.render.mobs.barbarians.RendererBarbarian;
import com.minecolonies.coremod.client.render.mobs.barbarians.RendererChiefBarbarian;
import com.minecolonies.coremod.client.render.mobs.pirates.RendererArcherPirate;
import com.minecolonies.coremod.client.render.mobs.pirates.RendererChiefPirate;
import com.minecolonies.coremod.client.render.mobs.pirates.RendererPirate;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.EntityFishHook;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.EntityArcherBarbarian;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.EntityBarbarian;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.EntityChiefBarbarian;
import com.minecolonies.coremod.entity.ai.mobs.pirates.EntityArcherPirate;
import com.minecolonies.coremod.entity.ai.mobs.pirates.EntityCaptainPirate;
import com.minecolonies.coremod.entity.ai.mobs.pirates.EntityPirate;
import com.minecolonies.coremod.event.ClientEventHandler;
import com.minecolonies.coremod.items.ModItems;
import com.minecolonies.coremod.proxy.CommonProxy;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import com.minecolonies.coremod.tileentities.TileEntityInfoPoster;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.stats.RecipeBook;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    private static final String INVENTORY = "inventory";

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void registerEvents() {
        super.registerEvents();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
    }

    @Override
    public void registerEntityRendering() {
        RenderingRegistry.registerEntityRenderingHandler(EntityCitizen.class, RenderBipedCitizen::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityFishHook.class, RenderFishHook::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBarbarian.class, RendererBarbarian::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityArcherBarbarian.class, RendererBarbarian::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityChiefBarbarian.class, RendererChiefBarbarian::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPirate.class, RendererPirate::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityArcherPirate.class, RendererArcherPirate::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCaptainPirate.class, RendererChiefPirate::new);
    }

    @Override
    public void registerTileEntityRendering() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityColonyBuilding.class, (TileEntitySpecialRenderer)new EmptyTileEntitySpecialRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(ScarecrowTileEntity.class, (TileEntitySpecialRenderer)new TileEntityScarecrowRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityInfoPoster.class, (TileEntitySpecialRenderer)new TileEntityInfoPosterRenderer());
    }

    @Override
    public void showCitizenWindow(CitizenDataView citizen) {
        WindowCitizen window = new WindowCitizen(citizen);
        window.open();
    }

    @Override
    public void openBuildToolWindow(@Nullable BlockPos pos) {
        if (pos == null && Settings.instance.getActiveStructure() == null) {
            return;
        }
        WindowMinecoloniesBuildTool window = new WindowMinecoloniesBuildTool(pos);
        window.open();
    }

    @Override
    public void openBuildToolWindow(BlockPos pos, String structureName, int rotation, WindowBuildTool.FreeMode mode) {
        if (pos == null && Settings.instance.getActiveStructure() == null) {
            return;
        }
        WindowMinecoloniesBuildTool window = new WindowMinecoloniesBuildTool(pos, structureName, rotation, mode);
        window.open();
    }

    private static void createCustomModel(Block block) {
        Item item = Item.func_150898_a((Block)block);
        if (item != null) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), INVENTORY));
        }
    }

    private static void createCustomModel(Item item) {
        if (item != null) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), INVENTORY));
        }
    }

    @SubscribeEvent
    public static void registerModels(@NotNull ModelRegistryEvent event) {
        ClientProxy.createCustomModel(ModBlocks.blockHutBaker);
        ClientProxy.createCustomModel(ModBlocks.blockHutBlacksmith);
        ClientProxy.createCustomModel(ModBlocks.blockHutBuilder);
        ClientProxy.createCustomModel(ModBlocks.blockHutCitizen);
        ClientProxy.createCustomModel(ModBlocks.blockHutFarmer);
        ClientProxy.createCustomModel(ModBlocks.blockHutFisherman);
        ClientProxy.createCustomModel(ModBlocks.blockHutLumberjack);
        ClientProxy.createCustomModel(ModBlocks.blockHutMiner);
        ClientProxy.createCustomModel(ModBlocks.blockHutStonemason);
        ClientProxy.createCustomModel(ModBlocks.blockHutTownHall);
        ClientProxy.createCustomModel(ModBlocks.blockHutWareHouse);
        ClientProxy.createCustomModel(ModBlocks.blockHutDeliveryman);
        ClientProxy.createCustomModel(ModBlocks.blockBarracksTowerSubstitution);
        ClientProxy.createCustomModel((Block)ModBlocks.blockHutField);
        ClientProxy.createCustomModel(ModBlocks.blockHutGuardTower);
        ClientProxy.createCustomModel(ModBlocks.blockHutBarracks);
        ClientProxy.createCustomModel(ModBlocks.blockHutBarracksTower);
        ClientProxy.createCustomModel(ModBlocks.blockHutCook);
        ClientProxy.createCustomModel(ModBlocks.blockHutShepherd);
        ClientProxy.createCustomModel(ModBlocks.blockHutCowboy);
        ClientProxy.createCustomModel(ModBlocks.blockHutSwineHerder);
        ClientProxy.createCustomModel(ModBlocks.blockHutChickenHerder);
        ClientProxy.createCustomModel(ModBlocks.blockHutSmeltery);
        ClientProxy.createCustomModel(ModBlocks.blockHutComposter);
        ClientProxy.createCustomModel(ModBlocks.blockHutLibrary);
        ClientProxy.createCustomModel(ModBlocks.blockHutArchery);
        ClientProxy.createCustomModel(ModBlocks.blockHutCombatAcademy);
        ClientProxy.createCustomModel(ModBlocks.blockHutSawmill);
        ClientProxy.createCustomModel(ModBlocks.blockHutStoneSmeltery);
        ClientProxy.createCustomModel(ModBlocks.blockHutCrusher);
        ClientProxy.createCustomModel((Block)ModBlocks.blockConstructionTape);
        ClientProxy.createCustomModel(ModBlocks.blockRack);
        ClientProxy.createCustomModel(ModBlocks.blockWayPoint);
        ClientProxy.createCustomModel(ModBlocks.blockPostBox);
        ClientProxy.createCustomModel(ModItems.clipboard);
        ClientProxy.createCustomModel(ModItems.caliper);
        ClientProxy.createCustomModel(ModItems.scepterGuard);
        ClientProxy.createCustomModel(ModItems.supplyChest);
        ClientProxy.createCustomModel(ModItems.supplyCamp);
        ClientProxy.createCustomModel(ModItems.permTool);
        ClientProxy.createCustomModel(ModItems.ancientTome);
        ClientProxy.createCustomModel(ModItems.chiefSword);
        ClientProxy.createCustomModel(ModItems.scimitar);
        ClientProxy.createCustomModel(ModItems.pirateBoots_1);
        ClientProxy.createCustomModel(ModItems.pirateChest_1);
        ClientProxy.createCustomModel(ModItems.pirateHelmet_1);
        ClientProxy.createCustomModel(ModItems.pirateLegs_1);
        ClientProxy.createCustomModel(ModItems.pirateBoots_2);
        ClientProxy.createCustomModel(ModItems.pirateChest_2);
        ClientProxy.createCustomModel(ModItems.pirateHelmet_2);
        ClientProxy.createCustomModel(ModItems.pirateLegs_2);
        ClientProxy.createCustomModel(ModItems.santaHat);
        ClientProxy.createCustomModel(ModItems.itemAchievementProxySettlement);
        ClientProxy.createCustomModel(ModItems.itemAchievementProxyTown);
        ClientProxy.createCustomModel(ModItems.itemAchievementProxyCity);
        ClientProxy.createCustomModel(ModItems.itemAchievementProxyMetropolis);
        ClientProxy.createCustomModel((Block)ModBlocks.blockBarrel);
        ClientProxy.createCustomModel(ModItems.compost);
        ClientProxy.createCustomModel(ModItems.resourceScroll);
    }

    @Override
    public void openClipBoardWindow(int colonyId) {
        WindowClipBoard window = new WindowClipBoard(colonyId);
        window.open();
    }

    @Override
    public void openResourceScrollWindow(int colonyId, BlockPos buildingPos) {
        WindowResourceList window = new WindowResourceList(colonyId, buildingPos);
        window.open();
    }

    @Override
    public File getSchematicsFolder() {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            if (ColonyManager.getServerUUID() != null) {
                return new File(Minecraft.func_71410_x().field_71412_D, "minecolonies/" + ColonyManager.getServerUUID());
            }
            Log.getLogger().error("ColonyManager.getServerUUID() => null this should not happen");
            return null;
        }
        File worldSchematicFolder = new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_71238_n() + "/" + "minecolonies" + '/' + "schematics");
        if (!worldSchematicFolder.exists()) {
            return new File(Minecraft.func_71410_x().field_71412_D, "minecolonies");
        }
        return worldSchematicFolder.getParentFile();
    }

    @Override
    @Nullable
    public World getWorldFromMessage(@NotNull MessageContext context) {
        return context.getClientHandler().field_147300_g;
    }

    @Override
    @Nullable
    public World getWorld(int dimension) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return super.getWorld(dimension);
        }
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    @NotNull
    public RecipeBook getRecipeBookFromPlayer(@NotNull EntityPlayer player) {
        if (player instanceof EntityPlayerSP) {
            return ((EntityPlayerSP)player).func_192035_E();
        }
        return super.getRecipeBookFromPlayer(player);
    }
}

