/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.Player;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.network.PacketUtils;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;

public class PermissionsMessage {
    private static final String COLONY_DOES_NOT_EXIST = "Colony #%d does not exist.";

    public static class RemovePlayer
    extends AbstractMessage<RemovePlayer, IMessage> {
        private int colonyID;
        private UUID playerID;
        private int dimension;

        public RemovePlayer() {
        }

        public RemovePlayer(@NotNull ColonyView colony, UUID player) {
            this.colonyID = colony.getID();
            this.playerID = player;
            this.dimension = colony.getDimension();
        }

        public void toBytes(@NotNull ByteBuf buf) {
            buf.writeInt(this.colonyID);
            PacketUtils.writeUUID(buf, this.playerID);
            buf.writeInt(this.dimension);
        }

        public void fromBytes(@NotNull ByteBuf buf) {
            this.colonyID = buf.readInt();
            this.playerID = PacketUtils.readUUID(buf);
            this.dimension = buf.readInt();
        }

        @Override
        public void messageOnServerThread(RemovePlayer message, EntityPlayerMP player) {
            Colony colony = ColonyManager.getColonyByDimension(message.colonyID, message.dimension);
            if (colony == null) {
                Log.getLogger().error(String.format(PermissionsMessage.COLONY_DOES_NOT_EXIST, message.colonyID));
                return;
            }
            Player permissionsPlayer = colony.getPermissions().getPlayers().get(message.playerID);
            if (permissionsPlayer.getRank() == Rank.HOSTILE && colony.getPermissions().hasPermission((EntityPlayer)player, Action.EDIT_PERMISSIONS) || permissionsPlayer.getRank() != Rank.HOSTILE && colony.getPermissions().hasPermission((EntityPlayer)player, Action.EDIT_PERMISSIONS) && colony.getPermissions().getRank((EntityPlayer)player).ordinal() < colony.getPermissions().getRank(message.playerID).ordinal() || player.func_110124_au().equals(message.playerID)) {
                colony.getPermissions().removePlayer(message.playerID);
            }
        }
    }

    public static class ChangePlayerRank
    extends AbstractMessage<ChangePlayerRank, IMessage> {
        private int colonyID;
        private UUID playerID;
        private Type type;
        private int dimension;

        public ChangePlayerRank() {
        }

        public ChangePlayerRank(@NotNull ColonyView colony, UUID player, Type type) {
            this.colonyID = colony.getID();
            this.playerID = player;
            this.type = type;
            this.dimension = colony.getDimension();
        }

        public void toBytes(@NotNull ByteBuf buf) {
            buf.writeInt(this.colonyID);
            PacketUtils.writeUUID(buf, this.playerID);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.type.name());
            buf.writeInt(this.dimension);
        }

        public void fromBytes(@NotNull ByteBuf buf) {
            this.colonyID = buf.readInt();
            this.playerID = PacketUtils.readUUID(buf);
            this.type = Type.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.dimension = buf.readInt();
        }

        @Override
        public void messageOnServerThread(ChangePlayerRank message, EntityPlayerMP player) {
            Colony colony = ColonyManager.getColonyByDimension(message.colonyID, message.dimension);
            if (colony == null || colony.getWorld() == null) {
                Log.getLogger().error(String.format(PermissionsMessage.COLONY_DOES_NOT_EXIST, message.colonyID));
                return;
            }
            if (colony.getPermissions().hasPermission((EntityPlayer)player, Action.EDIT_PERMISSIONS)) {
                if (message.type == Type.PROMOTE && colony.getPermissions().getRank((EntityPlayer)player).ordinal() < colony.getPermissions().getRank(message.playerID).ordinal()) {
                    colony.getPermissions().setPlayerRank(message.playerID, Permissions.getPromotionRank(colony.getPermissions().getRank(message.playerID)), colony.getWorld());
                } else if (message.type == Type.DEMOTE && (colony.getPermissions().getRank((EntityPlayer)player).ordinal() < colony.getPermissions().getRank(message.playerID).ordinal() || player.func_110124_au().equals(message.playerID))) {
                    colony.getPermissions().setPlayerRank(message.playerID, Permissions.getDemotionRank(colony.getPermissions().getRank(message.playerID)), colony.getWorld());
                }
            }
        }

        public static enum Type {
            PROMOTE,
            DEMOTE;

        }
    }

    public static class AddPlayerOrFakePlayer
    extends AbstractMessage<AddPlayerOrFakePlayer, IMessage> {
        private int colonyID;
        private String playerName;
        private UUID id;
        private int dimension;

        public AddPlayerOrFakePlayer() {
        }

        public AddPlayerOrFakePlayer(@NotNull ColonyView colony, String playerName, UUID id) {
            this.colonyID = colony.getID();
            this.playerName = playerName;
            this.id = id;
            this.dimension = colony.getDimension();
        }

        public void toBytes(@NotNull ByteBuf buf) {
            buf.writeInt(this.colonyID);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerName);
            PacketUtils.writeUUID(buf, this.id);
            buf.writeInt(this.dimension);
        }

        public void fromBytes(@NotNull ByteBuf buf) {
            this.colonyID = buf.readInt();
            this.playerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.id = PacketUtils.readUUID(buf);
            this.dimension = buf.readInt();
        }

        @Override
        public void messageOnServerThread(AddPlayerOrFakePlayer message, EntityPlayerMP player) {
            Colony colony = ColonyManager.getColonyByDimension(message.colonyID, message.dimension);
            if (colony != null && colony.getPermissions().hasPermission((EntityPlayer)player, Action.CAN_PROMOTE) && colony.getWorld() != null) {
                colony.getPermissions().addPlayer(message.id, message.playerName, Rank.NEUTRAL);
            } else {
                Log.getLogger().error(String.format(PermissionsMessage.COLONY_DOES_NOT_EXIST, message.colonyID));
            }
        }
    }

    public static class AddPlayer
    extends AbstractMessage<AddPlayer, IMessage> {
        private int colonyID;
        private String playerName;
        private int dimension;

        public AddPlayer() {
        }

        public AddPlayer(@NotNull ColonyView colony, String player) {
            this.colonyID = colony.getID();
            this.playerName = player;
            this.dimension = colony.getDimension();
        }

        public void toBytes(@NotNull ByteBuf buf) {
            buf.writeInt(this.colonyID);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerName);
            buf.writeInt(this.dimension);
        }

        public void fromBytes(@NotNull ByteBuf buf) {
            this.colonyID = buf.readInt();
            this.playerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.dimension = buf.readInt();
        }

        @Override
        public void messageOnServerThread(AddPlayer message, EntityPlayerMP player) {
            Colony colony = ColonyManager.getColonyByDimension(message.colonyID, message.dimension);
            if (colony != null && colony.getPermissions().hasPermission((EntityPlayer)player, Action.CAN_PROMOTE) && colony.getWorld() != null) {
                colony.getPermissions().addPlayer(message.playerName, Rank.NEUTRAL, colony.getWorld());
            } else {
                Log.getLogger().error(String.format(PermissionsMessage.COLONY_DOES_NOT_EXIST, message.colonyID));
            }
        }
    }

    public static class Permission
    extends AbstractMessage<Permission, IMessage> {
        private int colonyID;
        private MessageType type;
        private Rank rank;
        private Action action;
        private int dimension;

        public Permission() {
        }

        public Permission(@NotNull ColonyView colony, MessageType type, Rank rank, Action action) {
            this.colonyID = colony.getID();
            this.type = type;
            this.rank = rank;
            this.action = action;
            this.dimension = colony.getDimension();
        }

        @Override
        public void messageOnServerThread(Permission message, EntityPlayerMP player) {
            Colony colony = ColonyManager.getColonyByDimension(message.colonyID, message.dimension);
            if (colony == null) {
                Log.getLogger().error(String.format(PermissionsMessage.COLONY_DOES_NOT_EXIST, message.colonyID));
                return;
            }
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.EDIT_PERMISSIONS)) {
                return;
            }
            switch (message.type) {
                case SET_PERMISSION: {
                    colony.getPermissions().setPermission(message.rank, message.action);
                    break;
                }
                case REMOVE_PERMISSION: {
                    colony.getPermissions().removePermission(message.rank, message.action);
                    break;
                }
                case TOGGLE_PERMISSION: {
                    colony.getPermissions().togglePermission(message.rank, message.action);
                    break;
                }
                default: {
                    Log.getLogger().error(String.format("Invalid MessageType %s", message.type.toString()));
                }
            }
        }

        public void toBytes(@NotNull ByteBuf buf) {
            buf.writeInt(this.colonyID);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.type.name());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.rank.name());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.action.name());
            buf.writeInt(this.dimension);
        }

        public void fromBytes(@NotNull ByteBuf buf) {
            this.colonyID = buf.readInt();
            this.type = MessageType.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.rank = Rank.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.action = Action.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.dimension = buf.readInt();
        }
    }

    public static class View
    extends AbstractMessage<View, IMessage> {
        private int colonyID;
        private ByteBuf data;
        private int dimension;

        public View() {
        }

        public View(@NotNull Colony colony, @NotNull Rank viewerRank) {
            this.colonyID = colony.getID();
            this.data = Unpooled.buffer();
            colony.getPermissions().serializeViewNetworkData(this.data, viewerRank);
            this.dimension = colony.getDimension();
        }

        public void fromBytes(@NotNull ByteBuf buf) {
            ByteBuf newBuf = buf.retain();
            this.colonyID = newBuf.readInt();
            this.dimension = newBuf.readInt();
            this.data = newBuf;
        }

        @Override
        protected void messageOnClientThread(View message, MessageContext ctx) {
            ColonyManager.handlePermissionsViewMessage(message.colonyID, message.data, Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension());
        }

        public void toBytes(@NotNull ByteBuf buf) {
            buf.writeInt(this.colonyID);
            buf.writeInt(this.dimension);
            buf.writeBytes(this.data);
        }
    }

    public static enum MessageType {
        SET_PERMISSION,
        REMOVE_PERMISSION,
        TOGGLE_PERMISSION;

    }
}

