/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.HappinessData;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;

public class HappinessDataMessage
extends AbstractMessage<HappinessDataMessage, IMessage> {
    private int colonyId;
    private HappinessData happinessData;

    public HappinessDataMessage() {
    }

    public HappinessDataMessage(@NotNull Colony colony, @NotNull HappinessData happinessData) {
        this.colonyId = colony.getID();
        this.happinessData = happinessData;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.colonyId = byteBuf.readInt();
        if (this.happinessData == null) {
            this.happinessData = new HappinessData();
        }
        this.happinessData.fromBytes(byteBuf);
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.colonyId);
        this.happinessData.toBytes(byteBuf);
    }

    @Override
    protected void messageOnClientThread(HappinessDataMessage message, MessageContext ctx) {
        ColonyManager.handleHappinessDataMessage(message.colonyId, message.happinessData, Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension());
    }
}

