/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizenhandlers;

import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.coremod.entity.EntityCitizen;
import java.util.Objects;
import net.minecraft.util.text.ITextComponent;

public class CitizenStatusHandler {
    private final EntityCitizen citizen;
    protected Status status = Status.IDLE;
    private final ITextComponent[] latestStatus = new ITextComponent[4];

    public CitizenStatusHandler(EntityCitizen citizen) {
        this.citizen = citizen;
    }

    public ITextComponent[] getLatestStatus() {
        return (ITextComponent[])this.latestStatus.clone();
    }

    public void setLatestStatus(ITextComponent ... status) {
        boolean hasChanged = false;
        for (int i = 0; i < this.latestStatus.length; ++i) {
            ITextComponent newStatus = i >= status.length ? null : status[i];
            if (Objects.equals(this.latestStatus[i], newStatus)) continue;
            this.latestStatus[i] = newStatus;
            hasChanged = true;
        }
        if (hasChanged) {
            this.citizen.markDirty();
        }
    }

    public void addLatestStatus(ITextComponent status) {
        System.arraycopy(this.latestStatus, 0, this.latestStatus, 1, this.latestStatus.length - 1);
        this.latestStatus[0] = status;
        this.citizen.markDirty();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }
}

