/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.util;

import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.coremod.blocks.BlockMinecoloniesRack;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.colony.ColonyManager;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureIterator {
    @Nullable
    private final Structure theStructure;
    private final World targetWorld;
    private Stage stage;

    public StructureIterator(World targetWorld, BlockPos buildingLocation, String schematicFileName, int rotation, @NotNull Mirror mirror) throws StructureException {
        this(targetWorld, buildingLocation, schematicFileName, rotation, Stage.CLEAR, null, mirror);
    }

    public StructureIterator(World targetWorld, BlockPos buildingLocation, String structureFileName, int rotation, Stage stageProgress, BlockPos blockProgress, Mirror mirror) throws StructureException {
        this.theStructure = StructureIterator.loadStructure(targetWorld, buildingLocation, structureFileName, rotation, stageProgress, blockProgress, mirror);
        this.stage = stageProgress;
        this.targetWorld = targetWorld;
    }

    @Nullable
    private static Structure loadStructure(@Nullable World targetWorld, @Nullable BlockPos buildingLocation, @Nullable String schematicFileName, int rotation, Stage stageProgress, @Nullable BlockPos blockProgress, @NotNull Mirror mirror) throws StructureException {
        Structure tempSchematic;
        if (targetWorld == null || buildingLocation == null || schematicFileName == null) {
            throw new StructureException(String.format("Some parameters were null! (targetWorld: %s), (buildingLocation: %s), (schematicFileName: %s)", targetWorld, buildingLocation, schematicFileName));
        }
        try {
            tempSchematic = new Structure(targetWorld, schematicFileName, new PlacementSettings());
        }
        catch (IllegalStateException e) {
            throw new StructureException("failed to load structure file!", e);
        }
        tempSchematic.rotate(BlockPosUtil.getRotationFromRotations(rotation), targetWorld, buildingLocation, mirror);
        tempSchematic.setPosition(buildingLocation);
        if (blockProgress != null) {
            tempSchematic.setLocalPosition(blockProgress);
        }
        return tempSchematic;
    }

    public StructureIterator(World targetWorld, @Nullable Structure structure, Stage stageProgress) {
        this.theStructure = structure;
        this.stage = stageProgress;
        this.targetWorld = targetWorld;
    }

    public static boolean checkBlocksEqual(@NotNull StructureBlock blocksToTest) {
        return blocksToTest.block == blocksToTest.worldBlock && Objects.equals(blocksToTest.metadata, blocksToTest.worldMetadata);
    }

    public Stage getStage() {
        return this.stage;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public BlockPos getCurrentBlockPosition() {
        return this.theStructure.getBlockPosition();
    }

    public BlockPos getLocalBlockPosition() {
        return this.theStructure.getLocalPosition();
    }

    @NotNull
    public Result advanceBlock() {
        switch (this.stage) {
            case CLEAR: {
                return this.advanceBlocks(() -> ((Structure)this.theStructure).decrementBlock(), structureBlock -> structureBlock.doesStructureBlockEqualWorldBlock() || structureBlock.worldBlock == Blocks.field_150350_a);
            }
            case BUILD: {
                return this.advanceBlocks(() -> ((Structure)this.theStructure).incrementBlock(), structureBlock -> structureBlock.doesStructureBlockEqualWorldBlock() || structureBlock.block == Blocks.field_150350_a || !structureBlock.metadata.func_185904_a().func_76220_a());
            }
            case SPAWN: {
                return this.advanceBlocks(() -> ((Structure)this.theStructure).decrementBlock(), structureBlock -> structureBlock.entity == null);
            }
            case DECORATE: {
                return this.advanceBlocks(() -> ((Structure)this.theStructure).incrementBlock(), structureBlock -> structureBlock.doesStructureBlockEqualWorldBlock() || structureBlock.metadata.func_185904_a().func_76220_a());
            }
            case REMOVE: {
                return this.advanceBlocks(() -> ((Structure)this.theStructure).decrementBlock(), structureBlock -> structureBlock.worldBlock == Blocks.field_150350_a);
            }
        }
        return Result.NEW_BLOCK;
    }

    @NotNull
    private Result advanceBlocks(@NotNull Supplier<Boolean> moveOneBlock, @NotNull Function<StructureBlock, Boolean> checkIfApplies) {
        for (int i = 0; i < Configurations.gameplay.maxBlocksCheckedByBuilder; ++i) {
            if (!moveOneBlock.get().booleanValue()) {
                return Result.AT_END;
            }
            if (checkIfApplies.apply(this.getCurrentBlock()).booleanValue()) continue;
            return Result.NEW_BLOCK;
        }
        return Result.CONFIG_LIMIT;
    }

    @NotNull
    public StructureBlock getCurrentBlock() {
        return new StructureBlock(this.theStructure.getBlock(), this.theStructure.getBlockPosition(), this.theStructure.getBlockstate(), this.theStructure.getEntityData(), this.theStructure.getItem(), BlockPosUtil.getBlock(this.targetWorld, this.theStructure.getBlockPosition()), BlockPosUtil.getBlockState(this.targetWorld, this.theStructure.getBlockPosition()), !this.targetWorld.func_175647_a(Entity.class, new AxisAlignedBB(this.theStructure.getBlockPosition()), entity -> !(entity instanceof EntityLiving) && !(entity instanceof EntityPlayer) && !(entity instanceof EntityItem)).isEmpty());
    }

    public int getWidth() {
        return this.theStructure.getWidth();
    }

    public int getLength() {
        return this.theStructure.getLength();
    }

    public int getHeight() {
        return this.theStructure.getHeight();
    }

    public BlockPos getCenter() {
        return this.theStructure.getPosition();
    }

    public void setCurrentBlock(@Nullable BlockPos progressPos) {
        if (progressPos != null) {
            this.theStructure.setLocalPosition(progressPos);
        }
    }

    public static enum Stage {
        CLEAR,
        BUILD,
        DECORATE,
        SPAWN,
        COMPLETE,
        REMOVE;

    }

    public static enum Result {
        NEW_BLOCK,
        AT_END,
        CONFIG_LIMIT;

    }

    public static final class StructureBlock {
        public final Block block;
        public final BlockPos blockPosition;
        public final IBlockState metadata;
        public final Item item;
        public final Block worldBlock;
        public final IBlockState worldMetadata;
        public final NBTTagCompound entity;
        public final boolean hasWorldEntity;

        public StructureBlock(Block block, BlockPos blockPosition, IBlockState metadata, NBTTagCompound entity, Item item, Block worldBlock, IBlockState worldMetadata, boolean hasWorldEntity) {
            this.block = block;
            this.blockPosition = blockPosition;
            this.metadata = metadata;
            this.entity = entity;
            this.item = item;
            this.worldBlock = worldBlock;
            this.worldMetadata = worldMetadata;
            this.hasWorldEntity = hasWorldEntity;
        }

        public boolean doesStructureBlockEqualWorldBlock() {
            if (this.metadata == null) {
                return true;
            }
            IBlockState structureBlockState = this.metadata;
            Block structureBlock = structureBlockState.func_177230_c();
            if (StructureBlock.structureBlockEqualsWorldBlock(structureBlock, this.worldBlock, this.worldMetadata)) {
                return true;
            }
            if (this.entity == null && this.hasWorldEntity) {
                return false;
            }
            IBlockState worldBlockState = this.worldMetadata;
            if (structureBlock instanceof BlockDoor || structureBlock == Blocks.field_150457_bL) {
                return structureBlock == worldBlockState.func_177230_c();
            }
            if (structureBlock instanceof BlockStairs && structureBlockState.equals(worldBlockState) || BlockUtils.isGrassOrDirt(structureBlock, this.worldBlock, structureBlockState, worldBlockState) || this.worldBlock == ModBlocks.blockRack && BlockMinecoloniesRack.shouldBlockBeReplacedWithRack(structureBlock)) {
                return true;
            }
            return structureBlockState.equals(worldBlockState);
        }

        private static boolean structureBlockEqualsWorldBlock(@NotNull Block structureBlock, @NotNull Block worldBlock, @NotNull IBlockState worldMetadata) {
            return structureBlock == com.ldtteam.structurize.blocks.ModBlocks.blockSubstitution || structureBlock == com.ldtteam.structurize.blocks.ModBlocks.blockSolidSubstitution && worldMetadata.func_185904_a().func_76220_a() && !ColonyManager.getCompatibilityManager().isOre(worldMetadata) && worldBlock != Blocks.field_150350_a;
        }
    }

    public static final class StructureException
    extends Exception {
        public static final long serialVersionUID = 8632728763984762837L;

        public StructureException(String message, Throwable cause) {
            super(message, cause);
        }

        public StructureException(String message) {
            super(message);
        }
    }
}

