/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.student;

import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLibrary;
import com.minecolonies.coremod.colony.jobs.JobStudent;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAISkill;
import com.minecolonies.coremod.entity.ai.statemachine.AITarget;
import com.minecolonies.coremod.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.coremod.entity.ai.statemachine.states.IAIState;
import com.minecolonies.coremod.entity.ai.util.StudyItem;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;

public class EntityAIStudy
extends AbstractEntityAISkill<JobStudent> {
    private static final int STUDY_DELAY = 1200;
    private BlockPos studyPos = null;

    public EntityAIStudy(@NotNull JobStudent job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding), new AITarget((IAIState)AIWorkerState.STUDY, this::study));
        this.worker.func_98053_h(true);
    }

    @Override
    public Class getExpectedBuildingClass() {
        return BuildingLibrary.class;
    }

    private IAIState study() {
        CitizenData data = this.worker.getCitizenData();
        if (data == null) {
            this.setDelay(1200);
            return this.getState();
        }
        if (this.studyPos == null) {
            this.studyPos = this.getOwnBuilding(BuildingLibrary.class).getRandomBookShelf();
        }
        if (this.walkToBlock(this.studyPos)) {
            this.setDelay(20);
            return this.getState();
        }
        ArrayList<StudyItem> currentItems = new ArrayList<StudyItem>();
        this.worker.decreaseSaturationForAction();
        for (StudyItem curItem : this.getOwnBuilding(BuildingLibrary.class).getStudyItems()) {
            int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((ICapabilityProvider)this.worker, itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() == curItem.getItem());
            if (slot == -1) continue;
            curItem.setSlot(slot);
            currentItems.add(curItem);
        }
        if (currentItems.isEmpty()) {
            data.tryRandomLevelUp(this.world.field_73012_v);
            this.worker.func_184611_a(EnumHand.MAIN_HAND, ItemStackUtils.EMPTY);
            for (StudyItem studyItem : this.getOwnBuilding(BuildingLibrary.class).getStudyItems()) {
                int bSlot = InventoryUtils.findFirstSlotInProviderWith(this.getOwnBuilding(), studyItem.getItem(), 0);
                if (bSlot > -1) {
                    if (this.walkToBuilding()) {
                        this.setDelay(20);
                        return this.getState();
                    }
                    this.takeItemStackFromProvider((ICapabilityProvider)this.getOwnBuilding(), bSlot);
                    continue;
                }
                this.checkIfRequestForItemExistOrCreateAsynch(new ItemStack(studyItem.getItem(), studyItem.getBreakPct() / 10 > 0 ? studyItem.getBreakPct() / 10 : 1));
            }
        } else {
            StudyItem chosenItem = (StudyItem)currentItems.get(this.world.field_73012_v.nextInt(currentItems.size()));
            this.worker.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(chosenItem.getItem(), 1));
            data.tryRandomLevelUp(this.world.field_73012_v, data.getChanceToLevel() * 100 / chosenItem.getSkillIncreasePct());
            if (this.world.field_73012_v.nextInt(100) <= chosenItem.getBreakPct()) {
                data.getInventory().func_70298_a(chosenItem.getSlot(), 1);
            }
        }
        this.studyPos = null;
        this.setDelay(1200);
        return this.getState();
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.STUDY;
    }
}

