/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.lumberjack;

import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockStateUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Tree {
    private static final String DYNAMICTREERADIUS = "radius";
    private static final int NUMBER_OF_LEAVES = 3;
    private static final int LEAVES_WIDTH = 4;
    private static final int MAX_TREE_SIZE = 256;
    private static final int A_LOT_OF_LUCK = 10000;
    private BlockPos location;
    private BlockPos topLog;
    private LinkedList<BlockPos> woodBlocks;
    private LinkedList<BlockPos> leaves;
    private boolean isTree;
    private ItemStack saplingToUse;
    private ArrayList<BlockPos> stumpLocations;
    private IProperty variant;
    private boolean slimeTree = false;
    private boolean dynamicTree = false;
    private static final PropertyInteger DYN_PROP_HYDRO = PropertyInteger.func_177719_a((String)"hydro", (int)1, (int)4);
    private static final PropertyInteger DYN_PROP_TREE = PropertyInteger.func_177719_a((String)"tree", (int)0, (int)3);

    private Tree() {
        this.isTree = true;
    }

    public Tree(@NotNull World world, @NotNull BlockPos log) {
        Block block = BlockPosUtil.getBlock(world, log);
        if (block.isWood((IBlockAccess)world, log) || Compatibility.isSlimeBlock(block) || Compatibility.isDynamicBlock(block)) {
            this.isTree = true;
            this.woodBlocks = new LinkedList();
            this.leaves = new LinkedList();
            this.location = log;
            this.topLog = log;
            this.addAndSearch(world, log);
            this.addAndSearch(world);
            this.checkTree(world, this.topLog);
            Block bottomBlock = world.func_180495_p(this.location).func_177230_c();
            this.dynamicTree = Compatibility.isDynamicBlock(bottomBlock);
            this.saplingToUse = this.calcSapling((IBlockAccess)world);
            this.stumpLocations = new ArrayList();
            this.woodBlocks.clear();
            this.slimeTree = Compatibility.isSlimeBlock(bottomBlock);
            this.variant = BlockStateUtils.getPropertyByNameFromState(world.func_180495_p(this.location), "variant");
        } else {
            this.isTree = false;
        }
    }

    private ItemStack calcSapling(IBlockAccess world) {
        BlockPos firstLeaf = this.getFirstLeaf(world);
        ItemStack sapling = this.calcSaplingForPos(world, firstLeaf, true);
        if (sapling != null) {
            return sapling;
        }
        for (BlockPos pos : this.leaves) {
            sapling = this.calcSaplingForPos(world, pos, true);
            if (sapling == null) continue;
            return sapling;
        }
        sapling = this.calcSaplingForPos(world, firstLeaf, false);
        if (sapling != null) {
            return sapling;
        }
        return ItemStackUtils.EMPTY;
    }

    private ItemStack calcSaplingForPos(IBlockAccess world, BlockPos pos, boolean checkFitsBase) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block instanceof BlockLeaves) {
            NonNullList<ItemStack> list = NonNullList.func_191196_a();
            if (checkFitsBase && (Compatibility.isDynamicLeaf(block) ? !this.isDynamicTree() || !Compatibility.isDynamicFamilyFitting(pos, this.location, world) : !BlockStateUtils.stateEqualsStateInPropertyByName(world.func_180495_p(pos), world.func_180495_p(this.location), "variant"))) {
                return null;
            }
            if (Compatibility.isDynamicLeaf(block)) {
                list = Compatibility.getDropsForDynamicLeaf(world, pos, blockState, 10000, block);
                blockState = blockState.func_177226_a((IProperty)DYN_PROP_HYDRO, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)DYN_PROP_TREE, (Comparable)Integer.valueOf(1));
            } else {
                list.add((Object)new ItemStack(block.func_180660_a(blockState, new Random(), 10000), 1, block.func_180651_a(blockState)));
            }
            for (ItemStack stack : list) {
                int[] oreIds;
                if (stack.func_190926_b()) continue;
                for (int oreId : oreIds = OreDictionary.getOreIDs((ItemStack)stack)) {
                    if (!OreDictionary.getOreName((int)oreId).equals("treeSapling")) continue;
                    ColonyManager.getCompatibilityManager().connectLeafToSapling(blockState, stack);
                    return stack;
                }
            }
        }
        return null;
    }

    private BlockPos getFirstLeaf(IBlockAccess world) {
        for (int i = 1; i + this.topLog.func_177956_o() < 255 && i < 10; ++i) {
            IBlockState blockState = world.func_180495_p(this.topLog.func_177982_a(0, i, 0));
            if (!(blockState.func_177230_c() instanceof BlockLeaves)) continue;
            return this.topLog.func_177982_a(0, i, 0);
        }
        return this.topLog.func_177982_a(0, 1, 0);
    }

    public static boolean checkTree(@NotNull IBlockAccess world, BlockPos pos, List<ItemStorage> treesToNotCut) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!(block.isWood(world, pos) || Compatibility.isSlimeBlock(block) || Compatibility.isDynamicBlock(block))) {
            return false;
        }
        if (Compatibility.isDynamicBlock(block) && (Integer)state.func_177229_b(BlockStateUtils.getPropertyByNameFromState(state, DYNAMICTREERADIUS)) < Configurations.compatibility.dynamicTreeHarvestSize) {
            return false;
        }
        Tuple<BlockPos, BlockPos> baseAndTOp = Tree.getBottomAndTopLog(world, pos, new LinkedList<BlockPos>(), null, null);
        BlockPos basePos = (BlockPos)baseAndTOp.func_76341_a();
        return world.func_180495_p(basePos.func_177977_b()).func_185904_a().func_76220_a() && world.func_180495_p(basePos.func_177977_b()).func_177230_c() != Blocks.field_150347_e && Tree.hasEnoughLeavesAndIsSupposedToCut(world, (BlockPos)baseAndTOp.func_76340_b(), treesToNotCut);
    }

    @NotNull
    private static Tuple<BlockPos, BlockPos> getBottomAndTopLog(@NotNull IBlockAccess world, @NotNull BlockPos log, @NotNull LinkedList<BlockPos> woodenBlocks, BlockPos bottomLog, BlockPos topLog) {
        BlockPos top;
        BlockPos bottom = bottomLog == null ? log : bottomLog;
        BlockPos blockPos = top = topLog == null ? log : topLog;
        if (woodenBlocks.size() >= 256) {
            return new Tuple((Object)bottom, (Object)top);
        }
        if (log.func_177956_o() < bottom.func_177956_o()) {
            bottom = log;
        }
        if (log.func_177956_o() > top.func_177956_o()) {
            top = log;
        }
        woodenBlocks.add(log);
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos temp = log.func_177982_a(x, y, z);
                    Block block = world.func_180495_p(temp).func_177230_c();
                    if (!block.isWood(world, temp) && !Compatibility.isSlimeBlock(block) && !Compatibility.isDynamicBlock(block) || woodenBlocks.contains(temp)) continue;
                    return Tree.getBottomAndTopLog(world, temp, woodenBlocks, bottom, top);
                }
            }
        }
        return new Tuple((Object)bottom, (Object)top);
    }

    private static boolean hasEnoughLeavesAndIsSupposedToCut(@NotNull IBlockAccess world, BlockPos pos, List<ItemStorage> treesToNotCut) {
        boolean checkedLeaves = false;
        int leafCount = 0;
        int dynamicBonusY = 0;
        if (Compatibility.isDynamicBlock(world.func_180495_p(pos).func_177230_c())) {
            dynamicBonusY = 10;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dy = -1; dy <= 1 + dynamicBonusY; ++dy) {
                    BlockPos leafPos = pos.func_177982_a(dx, dy, dz);
                    if (!world.func_180495_p(leafPos).func_185904_a().equals(Material.field_151584_j)) continue;
                    if (!checkedLeaves && !Tree.supposedToCut(world, treesToNotCut, leafPos)) {
                        return false;
                    }
                    checkedLeaves = true;
                    if (++leafCount < 3 && !Compatibility.isDynamicLeaf(world.func_180495_p(leafPos).func_177230_c())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean supposedToCut(IBlockAccess world, List<ItemStorage> treesToNotCut, BlockPos leafPos) {
        for (ItemStorage stack : treesToNotCut) {
            ItemStack sap;
            IBlockState bState = world.func_180495_p(leafPos);
            if (Compatibility.isDynamicLeaf(bState.func_177230_c())) {
                bState = bState.func_177226_a((IProperty)DYN_PROP_HYDRO, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)DYN_PROP_TREE, (Comparable)Integer.valueOf(1));
            }
            if ((sap = ColonyManager.getCompatibilityManager().getSaplingForLeaf(bState)) == null || !sap.func_77969_a(stack.getItemStack())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static Tree readFromNBT(@NotNull NBTTagCompound compound) {
        Tree tree = new Tree();
        tree.location = BlockPosUtil.readFromNBT(compound, "location");
        tree.woodBlocks = new LinkedList();
        NBTTagList logs = compound.func_150295_c("Logs", 10);
        for (int i = 0; i < logs.func_74745_c(); ++i) {
            tree.woodBlocks.add(BlockPosUtil.readFromNBTTagList(logs, i));
        }
        tree.stumpLocations = new ArrayList();
        NBTTagList stumps = compound.func_150295_c("Stumps", 10);
        for (int i = 0; i < stumps.func_74745_c(); ++i) {
            tree.stumpLocations.add(BlockPosUtil.readFromNBTTagList(stumps, i));
        }
        tree.topLog = BlockPosUtil.readFromNBT(compound, "topLog");
        tree.slimeTree = compound.func_74767_n("slimeTree");
        tree.dynamicTree = compound.func_74767_n("dynamicTree");
        return tree;
    }

    private void checkTree(@NotNull World world, @NotNull BlockPos topLog) {
        if (!world.func_180495_p(new BlockPos(this.location.func_177958_n(), this.location.func_177956_o() - 1, this.location.func_177952_p())).func_185904_a().func_76220_a()) {
            return;
        }
        int leafCount = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    if (!world.func_180495_p(new BlockPos(topLog.func_177958_n() + x, topLog.func_177956_o() + y, topLog.func_177952_p() + z)).func_185904_a().equals(Material.field_151584_j) || ++leafCount < 3) continue;
                    this.isTree = true;
                    return;
                }
            }
        }
    }

    public void findLogs(@NotNull World world) {
        this.addAndSearch(world, this.location);
        this.woodBlocks.sort((c1, c2) -> (int)(c1.func_177951_i((Vec3i)this.location) - c2.func_177951_i((Vec3i)this.location)));
        if (this.getStumpLocations().isEmpty()) {
            this.fillTreeStumps(this.location.func_177956_o());
        }
    }

    public void fillTreeStumps(int yLevel) {
        for (BlockPos pos : this.woodBlocks) {
            if (pos.func_177956_o() != yLevel) continue;
            this.stumpLocations.add(pos);
        }
    }

    private void addAndSearch(@NotNull World world, @NotNull BlockPos log) {
        if (this.woodBlocks.size() >= 256) {
            return;
        }
        if (!BlockStateUtils.stateEqualsStateByBlockAndProp(world.func_180495_p(log), world.func_180495_p(this.location), "variant")) {
            return;
        }
        if (log.func_177956_o() < this.location.func_177956_o()) {
            this.location = log;
        }
        if (log.func_177956_o() > this.topLog.func_177956_o()) {
            this.topLog = log;
        }
        this.woodBlocks.add(log);
        if (Compatibility.isDynamicBlock(BlockPosUtil.getBlock(world, log))) {
            return;
        }
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos temp = log.func_177982_a(x, y, z);
                    Block block = BlockPosUtil.getBlock(world, temp);
                    if (!block.isWood((IBlockAccess)world, temp) && !Compatibility.isSlimeBlock(block) || this.woodBlocks.contains(temp)) continue;
                    this.addAndSearch(world, temp);
                }
            }
        }
    }

    private void addAndSearch(@NotNull World world) {
        int temp;
        int locXMin = this.location.func_177958_n() - 4;
        int locXMax = this.location.func_177958_n() + 4;
        int locYMin = this.location.func_177956_o() + 2;
        int locZMin = this.location.func_177952_p() - 4;
        int locZMax = this.location.func_177952_p() + 4;
        if (locXMin > locXMax) {
            temp = locXMax;
            locXMax = locXMin;
            locXMin = temp;
        }
        if (locZMin > locZMax) {
            temp = locZMax;
            locZMax = locZMin;
            locZMin = temp;
        }
        for (int locX = locXMin; locX <= locXMax; ++locX) {
            for (int locY = locYMin; locY <= 256; ++locY) {
                for (int locZ = locZMin; locZ <= locZMax; ++locZ) {
                    BlockPos leaf = new BlockPos(locX, locY, locZ);
                    if (world.func_180495_p(leaf).func_185904_a() != Material.field_151584_j) continue;
                    this.leaves.add(leaf);
                }
            }
        }
    }

    public BlockPos pollNextLog() {
        return this.woodBlocks.pollLast();
    }

    public BlockPos pollNextLeaf() {
        return this.leaves.pollLast();
    }

    public BlockPos peekNextLog() {
        return this.woodBlocks.peekLast();
    }

    public BlockPos peekNextLeaf() {
        return this.leaves.peekLast();
    }

    public boolean hasLeaves() {
        return !this.leaves.isEmpty();
    }

    public boolean hasLogs() {
        return !this.woodBlocks.isEmpty();
    }

    public boolean isSlimeTree() {
        return this.slimeTree;
    }

    public boolean isDynamicTree() {
        return this.dynamicTree;
    }

    @NotNull
    public List<BlockPos> getStumpLocations() {
        return new ArrayList<BlockPos>(this.stumpLocations);
    }

    public void removeStump(BlockPos pos) {
        this.stumpLocations.remove(pos);
    }

    public IProperty getVariant() {
        return this.variant;
    }

    public BlockPos getLocation() {
        return this.location;
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public boolean equals(@Nullable Object tree) {
        return tree != null && tree.getClass() == this.getClass() && ((Tree)tree).getLocation().equals((Object)this.location);
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        if (!this.isTree) {
            return;
        }
        BlockPosUtil.writeToNBT(compound, "location", this.location);
        NBTTagList logs = new NBTTagList();
        for (BlockPos log : this.woodBlocks) {
            BlockPosUtil.writeToNBTTagList(logs, log);
        }
        compound.func_74782_a("Logs", (NBTBase)logs);
        NBTTagList stumps = new NBTTagList();
        for (BlockPos stump : this.stumpLocations) {
            BlockPosUtil.writeToNBTTagList(stumps, stump);
        }
        compound.func_74782_a("Stumps", (NBTBase)stumps);
        BlockPosUtil.writeToNBT(compound, "topLog", this.topLog);
        compound.func_74757_a("slimeTree", this.slimeTree);
        compound.func_74757_a("dynamicTree", this.dynamicTree);
    }

    public ItemStack getSapling() {
        return this.saplingToUse;
    }

    public boolean isTree() {
        return this.isTree;
    }

    public static boolean checkIfInColonyAndNotInBuilding(BlockPos pos, Colony colony) {
        if (!colony.isCoordInColony(colony.getWorld(), pos)) {
            return false;
        }
        if (colony.getWorld() != null && Compatibility.isDynamicBlock(colony.getWorld().func_180495_p(pos).func_177230_c())) {
            return true;
        }
        for (AbstractBuilding building : colony.getBuildingManager().getBuildings().values()) {
            Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = building.getCorners();
            int x1 = (Integer)((Tuple)corners.func_76341_a()).func_76341_a();
            int x2 = (Integer)((Tuple)corners.func_76341_a()).func_76340_b();
            int z1 = (Integer)((Tuple)corners.func_76340_b()).func_76341_a();
            int z2 = (Integer)((Tuple)corners.func_76340_b()).func_76340_b();
            int x = pos.func_177958_n();
            int z = pos.func_177952_p();
            if (x <= x1 || x >= x2 || z <= z1 || z >= z2) continue;
            return false;
        }
        return true;
    }
}

