/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.statemachine.AIOneTimeEventTarget;
import com.minecolonies.coremod.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.coremod.entity.ai.statemachine.states.IAIState;
import com.minecolonies.coremod.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.coremod.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.coremod.entity.ai.util.ChatSpamFilter;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAISkeleton<J extends AbstractJob>
extends EntityAIBase {
    private static final int MUTEX_MASK = 3;
    @NotNull
    protected final J job;
    @NotNull
    protected final EntityCitizen worker;
    protected final World world;
    @NotNull
    protected final ChatSpamFilter chatSpamFilter;
    @NotNull
    private final TickRateStateMachine stateMachine;
    private int tickCounter = 0;

    protected AbstractAISkeleton(@NotNull J job) {
        if (!((AbstractJob)job).getCitizen().getCitizenEntity().isPresent()) {
            throw new IllegalArgumentException("Cannot instantiate a AI from a Job that is attached to a Citizen without entity.");
        }
        this.func_75248_a(3);
        this.job = job;
        this.worker = ((AbstractJob)this.job).getCitizen().getCitizenEntity().get();
        this.world = CompatibilityUtils.getWorld((Entity)this.worker);
        this.chatSpamFilter = new ChatSpamFilter(((AbstractJob)job).getCitizen());
        this.stateMachine = new TickRateStateMachine(AIWorkerState.INIT, this::onException);
        this.tickCounter = new Random().nextInt(Configurations.gameplay.updateRate) + 1;
    }

    protected void registerTarget(TickingTransition target) {
        this.stateMachine.addTransition(target);
    }

    protected final void registerTargets(TickingTransition ... targets) {
        Arrays.asList(targets).forEach(this::registerTarget);
    }

    public final boolean func_75250_a() {
        return this.worker.getDesiredActivity() == DesiredActivity.WORK;
    }

    public final boolean func_75253_b() {
        return super.func_75253_b();
    }

    public final void func_75249_e() {
        this.worker.getCitizenStatusHandler().setStatus(Status.WORKING);
    }

    public final void func_75251_c() {
        this.worker.getCitizenStatusHandler().setStatus(Status.IDLE);
    }

    public final void func_75246_d() {
        if (this.tickCounter < Configurations.gameplay.updateRate) {
            ++this.tickCounter;
        } else {
            this.stateMachine.tick();
            this.tickCounter = 1;
        }
    }

    protected void onException(RuntimeException e) {
    }

    public final void func_75248_a(int mutexBits) {
        super.func_75248_a(mutexBits);
    }

    public final IAIState getState() {
        return this.stateMachine.getState();
    }

    public void resetAI() {
        this.stateMachine.addTransition(new AIOneTimeEventTarget(AIWorkerState.IDLE));
    }
}

