/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class RefreshColonyCommand
extends AbstractSingleCommand
implements IActionCommand {
    public static final String DESC = "refresh";
    private static final String NO_COLONY_WITH_ID_FOUND_MESSAGE = "Colony with ID %d not found.";
    private static final String NO_COLONY_FOUND_MESSAGE = "Colony not found.";
    private static final String NO_COLONY_WITH_PLAYER_FOUND_MESSAGE = "Colony with mayor %s not found.";
    private static final String REFRESH = "Refresh successful!";

    public RefreshColonyCommand() {
        super(new String[0]);
    }

    public RefreshColonyCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId|OwnerName>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        EntityPlayerMP player;
        Colony colony = actionMenuState.getColonyForArgument("colony");
        if (null == colony && null != (player = actionMenuState.getPlayerForArgument("player"))) {
            Entity senderEntity;
            IColony iColony = ColonyManager.getIColonyByOwner(server.func_130014_f_(), (EntityPlayer)player);
            if (null == iColony && sender instanceof EntityPlayer && (senderEntity = sender.func_174793_f()) != null) {
                UUID mayorID = senderEntity.func_110124_au();
                iColony = ColonyManager.getIColonyByOwner(sender.func_130014_f_(), mayorID);
            }
            if (null != iColony) {
                colony = ColonyManager.getColonyByWorld(iColony.getID(), (World)server.func_71218_a(0));
            }
        }
        if (colony == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(NO_COLONY_FOUND_MESSAGE));
            return;
        }
        this.executeShared(server, sender, colony);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        EntityPlayer player;
        int colonyId = RefreshColonyCommand.getIthArgument(args, 0, -1);
        IColony tempColony = ColonyManager.getColonyByWorld(colonyId, (World)server.func_71218_a(0));
        if (colonyId == -1 && args.length >= 1 && (player = server.func_130014_f_().func_72924_a(args[0])) != null) {
            tempColony = ColonyManager.getIColonyByOwner(server.func_130014_f_(), player);
        }
        if (sender instanceof EntityPlayer) {
            Entity senderEntity = sender.func_174793_f();
            if (senderEntity == null) {
                return;
            }
            UUID mayorID = senderEntity.func_110124_au();
            if (tempColony == null) {
                tempColony = ColonyManager.getIColonyByOwner(sender.func_130014_f_(), mayorID);
            }
        }
        if (tempColony == null) {
            if (colonyId == -1 && args.length != 0) {
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format(NO_COLONY_WITH_PLAYER_FOUND_MESSAGE, args[0])));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format(NO_COLONY_WITH_ID_FOUND_MESSAGE, colonyId)));
            }
            return;
        }
        Colony colony = ColonyManager.getColonyByWorld(tempColony.getID(), (World)server.func_71218_a(0));
        if (colony == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(NO_COLONY_FOUND_MESSAGE));
            return;
        }
        this.executeShared(server, sender, colony);
    }

    private void executeShared(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull Colony colony) {
        EntityPlayer senderPlayer;
        if (sender instanceof EntityPlayer && !this.canPlayerUseCommand(senderPlayer = (EntityPlayer)sender.func_174793_f(), AbstractSingleCommand.Commands.REFRESH_COLONY, colony.getID())) {
            sender.func_145747_a((ITextComponent)new TextComponentString("You are not allowed to do that!"));
            return;
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(REFRESH));
        colony.getPermissions().restoreOwnerIfNull();
        colony.markDirty();
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return index == 0 && args.length > 0 && !args[0].isEmpty() && RefreshColonyCommand.getIthArgument(args, 0, Integer.MAX_VALUE) == Integer.MAX_VALUE;
    }
}

