/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestResolverIdentitiesDataStore;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class StandardRequestResolversIdentitiesDataStore
implements IRequestResolverIdentitiesDataStore {
    private IToken<?> id;
    private final BiMap<IToken<?>, IRequestResolver<?>> map;

    public StandardRequestResolversIdentitiesDataStore(IToken<?> id, BiMap<IToken<?>, IRequestResolver<?>> map) {
        this.id = id;
        this.map = map;
    }

    public StandardRequestResolversIdentitiesDataStore() {
        this.id = StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN);
        this.map = HashBiMap.create();
    }

    @Override
    public BiMap<IToken<?>, IRequestResolver<?>> getIdentities() {
        return this.map;
    }

    @Override
    public IToken<?> getId() {
        return this.id;
    }

    @Override
    public void setId(IToken<?> id) {
        this.id = id;
    }

    public static class Factory
    implements IFactory<FactoryVoidInput, StandardRequestResolversIdentitiesDataStore> {
        @Override
        @NotNull
        public TypeToken<? extends StandardRequestResolversIdentitiesDataStore> getFactoryOutputType() {
            return TypeToken.of(StandardRequestResolversIdentitiesDataStore.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public StandardRequestResolversIdentitiesDataStore getNewInstance(@NotNull IFactoryController factoryController, @NotNull FactoryVoidInput factoryVoidInput, Object ... context) throws IllegalArgumentException {
            return new StandardRequestResolversIdentitiesDataStore();
        }

        @Override
        @NotNull
        public NBTTagCompound serialize(@NotNull IFactoryController controller, @NotNull StandardRequestResolversIdentitiesDataStore standardRequestIdentitiesDataStore) {
            NBTTagCompound systemCompound = new NBTTagCompound();
            systemCompound.func_74782_a("Token", (NBTBase)controller.serialize(standardRequestIdentitiesDataStore.getId()));
            systemCompound.func_74782_a("List", (NBTBase)standardRequestIdentitiesDataStore.getIdentities().keySet().stream().map(token -> {
                NBTTagCompound mapCompound = new NBTTagCompound();
                mapCompound.func_74782_a("Token", (NBTBase)controller.serialize(token));
                mapCompound.func_74782_a("Resolver", (NBTBase)controller.serialize(standardRequestIdentitiesDataStore.getIdentities().get(token)));
                return mapCompound;
            }).collect(NBTUtils.toNBTTagList()));
            return systemCompound;
        }

        @Override
        @NotNull
        public StandardRequestResolversIdentitiesDataStore deserialize(@NotNull IFactoryController controller, @NotNull NBTTagCompound nbt) {
            IToken token = (IToken)controller.deserialize(nbt.func_74775_l("Token"));
            NBTTagList list = nbt.func_150295_c("List", 10);
            Map<IToken, IRequestResolver> map = NBTUtils.streamCompound(list).map(nbtTagCompound -> {
                IToken id = (IToken)controller.deserialize(nbtTagCompound.func_74775_l("Token"));
                IRequestResolver resolver = (IRequestResolver)controller.deserialize(nbtTagCompound.func_74775_l("Resolver"));
                return new Tuple((Object)id, (Object)resolver);
            }).collect(Collectors.toMap(t -> (IToken)t.func_76341_a(), t -> (IRequestResolver)t.func_76340_b()));
            HashBiMap biMap = HashBiMap.create(map);
            return new StandardRequestResolversIdentitiesDataStore(token, (BiMap<IToken<?>, IRequestResolver<?>>)biMap);
        }
    }
}

