/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.ldtteam.structurize.management.StructureName;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.blockout.Log;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.managers.interfaces.IRaiderManager;
import com.minecolonies.coremod.entity.ai.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.coremod.util.InstantStructurePlacer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.jetbrains.annotations.NotNull;

public class RaidManager
implements IRaiderManager {
    private boolean raidTonight = false;
    private boolean raidBeenCalculated = false;
    private boolean haveBarbEvents = true;
    private final List<BlockPos> lastSpawnPoints = new ArrayList<BlockPos>();
    private final Map<BlockPos, Tuple<String, Long>> schematicMap = new HashMap<BlockPos, Tuple<String, Long>>();
    private final Colony colony;
    private final List<UUID> horde = new ArrayList<UUID>();

    public RaidManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public boolean canHaveRaiderEvents() {
        return this.haveBarbEvents;
    }

    @Override
    public boolean hasRaidBeenCalculated() {
        return this.raidBeenCalculated;
    }

    @Override
    public boolean willRaidTonight() {
        return this.raidTonight;
    }

    @Override
    public void setCanHaveRaiderEvents(boolean canHave) {
        this.haveBarbEvents = canHave;
    }

    @Override
    public void addRaiderSpawnPoint(BlockPos pos) {
        this.lastSpawnPoints.add(pos);
    }

    @Override
    public void setHasRaidBeenCalculated(boolean hasSet) {
        this.raidBeenCalculated = hasSet;
    }

    @Override
    public void setWillRaidTonight(boolean willRaid) {
        this.raidTonight = willRaid;
    }

    @Override
    public BlockPos getRandomOutsiderInDirection(EnumFacing directionX, EnumFacing directionZ) {
        BlockPos center = this.colony.getCenter();
        World world = this.colony.getWorld();
        if (world == null) {
            return center;
        }
        List positions = this.colony.getWayPoints().keySet().stream().filter(pos -> RaidManager.isInDirection(directionX, directionZ, pos.func_177973_b((Vec3i)center))).collect(Collectors.toList());
        positions.addAll(this.colony.getBuildingManager().getBuildings().keySet().stream().filter(pos -> RaidManager.isInDirection(directionX, directionZ, pos.func_177973_b((Vec3i)center))).collect(Collectors.toList()));
        BlockPos thePos = center;
        double distance = 0.0;
        AbstractSchematicProvider theBuilding = null;
        for (BlockPos pos2 : positions) {
            double currentDistance = center.func_177951_i((Vec3i)pos2);
            if (!(currentDistance > distance) || !world.func_175697_a(pos2, 10)) continue;
            distance = currentDistance;
            thePos = pos2;
            theBuilding = this.colony.getBuildingManager().getBuilding(thePos);
        }
        int minDistance = 0;
        if (theBuilding != null) {
            Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = theBuilding.getCorners();
            minDistance = Math.max((Integer)((Tuple)corners.func_76341_a()).func_76341_a() - (Integer)((Tuple)corners.func_76341_a()).func_76340_b(), (Integer)((Tuple)corners.func_76340_b()).func_76341_a() - (Integer)((Tuple)corners.func_76340_b()).func_76340_b());
        }
        if (thePos.equals((Object)center)) {
            return center;
        }
        int radius = 10;
        while (world.func_175697_a(thePos, radius)) {
            radius += 10;
        }
        int dist = Math.max(minDistance, Math.min(radius, 75));
        thePos = thePos.func_177967_a(directionX, dist);
        thePos = thePos.func_177967_a(directionZ, dist);
        int randomDegree = world.field_73012_v.nextInt(360);
        double rads = (double)randomDegree / 180.0 * Math.PI;
        double x = Math.round((double)thePos.func_177958_n() + 3.0 * Math.sin(rads));
        double z = Math.round((double)thePos.func_177952_p() + 3.0 * Math.cos(rads));
        return new BlockPos(x, (double)thePos.func_177956_o(), z);
    }

    @Override
    public List<BlockPos> getLastSpawnPoints() {
        return new ArrayList<BlockPos>(this.lastSpawnPoints);
    }

    @Override
    public void registerRaider(@NotNull AbstractEntityMinecoloniesMob raider) {
        this.horde.add(raider.func_110124_au());
    }

    @Override
    public void unregisterRaider(@NotNull AbstractEntityMinecoloniesMob raider, WorldServer world) {
        for (UUID uuid : new ArrayList<UUID>(this.horde)) {
            Entity raiderEntity = world.func_175733_a(uuid);
            if (raiderEntity != null && raiderEntity.func_70089_S() && !uuid.equals(raider.func_110124_au())) continue;
            this.horde.remove(uuid);
        }
        this.sendHordeMessage();
    }

    private void sendHordeMessage() {
        if (this.horde.isEmpty()) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "com.minecolonies.coremod.barbarians.killed", new Object[0]);
        } else if (this.horde.size() <= 5) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "com.minecolonies.coremod.barbarians.left", this.horde.size());
        }
    }

    @Override
    public void onWorldTick(@NotNull World world) {
        if (Colony.shallUpdate(world, 1200)) {
            for (Map.Entry<BlockPos, Tuple<String, Long>> entry : new HashMap<BlockPos, Tuple<String, Long>>(this.schematicMap).entrySet()) {
                if (entry.getKey().equals((Object)BlockPos.field_177992_a)) {
                    this.schematicMap.remove(entry.getKey());
                    continue;
                }
                if ((Long)entry.getValue().func_76340_b() + (long)(24000 * Configurations.gameplay.daysUntilPirateshipsDespawn) >= world.func_72820_D()) continue;
                try {
                    InstantStructurePlacer.loadAndPlaceStructureWithRotation(world, new StructureName("cache", "backup", (String)entry.getValue().func_76341_a()).toString() + this.colony.getID() + this.colony.getDimension() + entry.getKey(), entry.getKey(), 0, Mirror.NONE, true);
                }
                catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
                    Log.getLogger().warn("Unable to retrieve backed up structure. This can happen when updating to a newer version!");
                }
                this.schematicMap.remove(entry.getKey());
                LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "com.minecolonies.coremod.pirates.sailing.away", this.colony.getName());
                return;
            }
        }
    }

    private static boolean isInDirection(EnumFacing directionX, EnumFacing directionZ, BlockPos vector) {
        return EnumFacing.func_176737_a((float)vector.func_177958_n(), (float)0.0f, (float)0.0f) == directionX && EnumFacing.func_176737_a((float)0.0f, (float)0.0f, (float)vector.func_177952_p()) == directionZ;
    }

    @Override
    public List<AbstractEntityMinecoloniesMob> getHorde(WorldServer world) {
        ArrayList<AbstractEntityMinecoloniesMob> raiders = new ArrayList<AbstractEntityMinecoloniesMob>();
        for (UUID uuid : new ArrayList<UUID>(this.horde)) {
            Entity raider = world.func_175733_a(uuid);
            if (!(raider instanceof AbstractEntityMinecoloniesMob) || !raider.func_70089_S()) {
                this.horde.remove(uuid);
                this.sendHordeMessage();
                continue;
            }
            raiders.add((AbstractEntityMinecoloniesMob)raider);
        }
        return raiders;
    }

    @Override
    public void registerRaiderOriginSchematic(String schematicName, BlockPos position, long worldTime) {
        this.schematicMap.put(position, (Tuple<String, Long>)new Tuple((Object)schematicName, (Object)worldTime));
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        if (compound.func_74764_b("raidManager")) {
            NBTTagCompound raiderCompound = compound.func_74775_l("raidManager");
            NBTTagList raiderTags = raiderCompound.func_150295_c("ships", 10);
            this.schematicMap.putAll(NBTUtils.streamCompound(raiderTags).collect(Collectors.toMap(raiderTagCompound -> BlockPosUtil.readFromNBT(raiderTagCompound, "pos"), raiderTagCompound -> new Tuple((Object)raiderTagCompound.func_74779_i("name"), (Object)raiderTagCompound.func_74763_f("time")))));
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        NBTTagCompound raiderCompound = new NBTTagCompound();
        NBTTagList raiderTagList = this.schematicMap.entrySet().stream().map(this::writeMapEntryToNBT).collect(NBTUtils.toNBTTagList());
        raiderCompound.func_74782_a("ships", (NBTBase)raiderTagList);
        compound.func_74782_a("raidManager", (NBTBase)raiderCompound);
    }

    private NBTTagCompound writeMapEntryToNBT(Map.Entry<BlockPos, Tuple<String, Long>> entry) {
        NBTTagCompound compound = new NBTTagCompound();
        BlockPosUtil.writeToNBT(compound, "pos", entry.getKey());
        compound.func_74778_a("name", (String)entry.getValue().func_76341_a());
        compound.func_74772_a("time", ((Long)entry.getValue().func_76340_b()).longValue());
        return compound;
    }
}

