/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.WindowHutShepherd;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobShepherd;
import com.minecolonies.coremod.network.messages.ShepherdSetDyeSheepsMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class BuildingShepherd
extends AbstractBuildingWorker {
    private static final String SHEPHERD = "Shepherd";
    private static final String NBT_DYE_SHEEPS = "autoDye";
    private static final int MAX_BUILDING_LEVEL = 5;
    private boolean dyeSheeps = false;

    public BuildingShepherd(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SHEPHERD;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public String getJobName() {
        return SHEPHERD;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobShepherd(citizen);
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.dyeSheeps);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74757_a(NBT_DYE_SHEEPS, this.dyeSheeps);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.dyeSheeps = compound.func_74767_n(NBT_DYE_SHEEPS);
        if (!compound.func_74764_b(NBT_DYE_SHEEPS)) {
            this.dyeSheeps = true;
        }
    }

    public boolean isDyeSheeps() {
        return this.dyeSheeps;
    }

    public void setDyeSheeps(boolean dyeSheeps) {
        this.dyeSheeps = dyeSheeps;
        this.markDirty();
    }

    public static class View
    extends AbstractBuildingWorker.View {
        private boolean dyeSheeps = false;

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutShepherd(this);
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.DEXTERITY;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.STRENGTH;
        }

        public void setDyeSheeps(boolean dyeSheeps) {
            this.dyeSheeps = dyeSheeps;
            MineColonies.getNetwork().sendToServer((IMessage)new ShepherdSetDyeSheepsMessage(this));
        }

        public boolean isDyeSheeps() {
            return this.dyeSheeps;
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            this.dyeSheeps = buf.readBoolean();
        }
    }
}

