/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.client.gui.WindowHutFarmer;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobFarmer;
import com.minecolonies.coremod.network.messages.AssignFieldMessage;
import com.minecolonies.coremod.network.messages.AssignmentModeMessage;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingFarmer
extends AbstractBuildingWorker {
    private static final String FARMER = "Farmer";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String TAG_FIELDS = "fields";
    private static final String TAG_FIELDS_BLOCKPOS = "fieldsPos";
    private static final String TAG_ASSIGN_MANUALLY = "assign";
    private static final int BLOCK_UPDATE_FLAG = 3;
    private static final String LAST_FIELD_TAG = "lastField";
    private static final int SEEDS_TO_KEEP = 64;
    private final List<BlockPos> farmerFields = new ArrayList<BlockPos>();
    @Nullable
    private BlockPos currentField;
    @Nullable
    private BlockPos lastField;
    private boolean shouldAssignManually = false;

    public BuildingFarmer(Colony c, BlockPos l) {
        super(c, l);
        ItemStack stackSeed = new ItemStack(Items.field_151014_N);
        ItemStack stackCarrot = new ItemStack(Items.field_151172_bF);
        ItemStack stackPotatoe = new ItemStack(Items.field_151174_bG);
        ItemStack stackReed = new ItemStack(Items.field_185163_cU);
        this.keepX.put(arg_0 -> ((ItemStack)stackSeed).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackCarrot).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackPotatoe).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackReed).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.HOE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @NotNull
    public List<BlockPos> getFarmerFields() {
        return Collections.unmodifiableList(this.farmerFields);
    }

    public boolean hasNoFields() {
        return this.farmerFields.isEmpty();
    }

    public void addFarmerFields(BlockPos field) {
        TileEntity scareCrow = this.getColony().getWorld().func_175625_s(field);
        if (scareCrow instanceof ScarecrowTileEntity) {
            ((ScarecrowTileEntity)scareCrow).calculateSize(this.getColony().getWorld(), field.func_177977_b());
            this.farmerFields.add(field);
            this.markDirty();
        }
    }

    @Nullable
    public BlockPos getCurrentField() {
        return this.currentField;
    }

    public void setCurrentField(@Nullable BlockPos currentField) {
        this.currentField = currentField;
    }

    @Nullable
    public BlockPos getFieldToWorkOn(World world) {
        Collections.shuffle(this.farmerFields);
        if (!this.farmerFields.isEmpty()) {
            if (this.farmerFields.get(0).equals((Object)this.lastField)) {
                Collections.shuffle(this.farmerFields);
            }
            this.lastField = this.farmerFields.get(0);
        }
        for (BlockPos field : this.farmerFields) {
            TileEntity scareCrow = this.getColony().getWorld().func_175625_s(field);
            if (!(scareCrow instanceof ScarecrowTileEntity) || !((ScarecrowTileEntity)scareCrow).needsWork()) continue;
            this.currentField = field;
            return field;
        }
        return null;
    }

    @Override
    @NotNull
    public AbstractJob createJob(@NotNull CitizenData citizen) {
        if (!this.farmerFields.isEmpty()) {
            for (BlockPos field : this.farmerFields) {
                TileEntity scareCrow = this.getColony().getWorld().func_175625_s(field);
                if (!(scareCrow instanceof ScarecrowTileEntity)) continue;
                ((ScarecrowTileEntity)scareCrow).setOwner(citizen.getId());
            }
        }
        return new JobFarmer(citizen);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagList fieldTagList = compound.func_150295_c(TAG_FIELDS, 10);
        for (int i = 0; i < fieldTagList.func_74745_c(); ++i) {
            NBTTagCompound fieldCompound = fieldTagList.func_150305_b(i);
            BlockPos fieldLocation = BlockPosUtil.readFromNBT(fieldCompound, TAG_FIELDS_BLOCKPOS);
            this.farmerFields.add(fieldLocation);
        }
        this.shouldAssignManually = compound.func_74767_n(TAG_ASSIGN_MANUALLY);
        if (compound.func_74764_b(LAST_FIELD_TAG)) {
            BlockPos pos;
            this.lastField = pos = BlockPosUtil.readFromNBT(compound, LAST_FIELD_TAG);
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList fieldTagList = new NBTTagList();
        for (BlockPos f : this.farmerFields) {
            NBTTagCompound fieldCompound = new NBTTagCompound();
            BlockPosUtil.writeToNBT(fieldCompound, TAG_FIELDS_BLOCKPOS, f);
            fieldTagList.func_74742_a((NBTBase)fieldCompound);
        }
        compound.func_74782_a(TAG_FIELDS, (NBTBase)fieldTagList);
        compound.func_74757_a(TAG_ASSIGN_MANUALLY, this.shouldAssignManually);
        if (this.lastField != null) {
            BlockPosUtil.writeToNBT(compound, LAST_FIELD_TAG, this.lastField);
        }
    }

    @Override
    public void onDestroyed() {
        super.onDestroyed();
        for (BlockPos field : this.farmerFields) {
            TileEntity scareCrow = this.getColony().getWorld().func_175625_s(field);
            if (!(scareCrow instanceof ScarecrowTileEntity)) continue;
            ((ScarecrowTileEntity)scareCrow).setTaken(false);
            ((ScarecrowTileEntity)scareCrow).setOwner(0);
            this.getColony().getWorld().func_184138_a(scareCrow.func_174877_v(), this.getColony().getWorld().func_180495_p(scareCrow.func_174877_v()), this.getColony().getWorld().func_180495_p(scareCrow.func_174877_v()), 3);
            ((ScarecrowTileEntity)scareCrow).setName(LanguageHandler.format("com.minecolonies.coremod.gui.scarecrow.user", LanguageHandler.format("com.minecolonies.coremod.gui.scarecrow.user.noone", new Object[0])));
        }
    }

    @Override
    @NotNull
    public String getJobName() {
        return FARMER;
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        TileEntity scareCrow;
        super.serializeToView(buf);
        buf.writeBoolean(this.shouldAssignManually);
        int size = 0;
        ArrayList<BlockPos> fields = new ArrayList<BlockPos>(this.getColony().getBuildingManager().getFields());
        for (BlockPos field : fields) {
            scareCrow = this.getColony().getWorld().func_175625_s(field);
            if (!(scareCrow instanceof ScarecrowTileEntity)) continue;
            if (((ScarecrowTileEntity)scareCrow).isTaken()) {
                if (!this.getAssignedCitizen().isEmpty() && ((ScarecrowTileEntity)scareCrow).getOwnerId() != this.getMainCitizen().getId()) continue;
                ++size;
                continue;
            }
            ++size;
        }
        buf.writeInt(size);
        for (BlockPos field : this.getColony().getBuildingManager().getFields()) {
            scareCrow = this.getColony().getWorld().func_175625_s(field);
            if (!(scareCrow instanceof ScarecrowTileEntity)) continue;
            if (((ScarecrowTileEntity)scareCrow).isTaken()) {
                if (!this.getAssignedCitizen().isEmpty() && ((ScarecrowTileEntity)scareCrow).getOwnerId() != this.getMainCitizen().getId()) continue;
                BlockPosUtil.writeToByteBuf(buf, field);
                continue;
            }
            BlockPosUtil.writeToByteBuf(buf, field);
        }
        buf.writeInt(this.farmerFields.size());
    }

    @Override
    public void onWakeUp() {
        this.resetFields();
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return FARMER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementBuildingFarmer);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementUpgradeFarmerMax);
        }
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(super.getRequiredItemsAndAmount());
        for (BlockPos field : this.farmerFields) {
            TileEntity scareCrow = this.getColony().getWorld().func_175625_s(field);
            if (!(scareCrow instanceof ScarecrowTileEntity) || ItemStackUtils.isEmpty(((ScarecrowTileEntity)scareCrow).getSeed()).booleanValue()) continue;
            ItemStack seedStack = ((ScarecrowTileEntity)scareCrow).getSeed();
            toKeep.put(arg_0 -> ((ItemStack)seedStack).func_77969_a(arg_0), (Tuple<Integer, Boolean>)new Tuple((Object)64, (Object)true));
        }
        return toKeep;
    }

    public void resetFields() {
        for (BlockPos field : this.farmerFields) {
            TileEntity scareCrow = this.getColony().getWorld().func_175625_s(field);
            if (!(scareCrow instanceof ScarecrowTileEntity)) continue;
            ((ScarecrowTileEntity)scareCrow).setNeedsWork(true);
            ((ScarecrowTileEntity)scareCrow).calculateSize(this.getColony().getWorld(), field.func_177977_b());
        }
    }

    public void syncWithColony(@NotNull World world) {
        if (!this.farmerFields.isEmpty()) {
            ArrayList<BlockPos> tempFields = new ArrayList<BlockPos>(this.farmerFields);
            for (BlockPos field : tempFields) {
                TileEntity scarecrow = world.func_175625_s(field);
                if (scarecrow instanceof ScarecrowTileEntity) {
                    ((ScarecrowTileEntity)scarecrow).setName(LanguageHandler.format("com.minecolonies.coremod.gui.scarecrow.user", this.getMainCitizen().getName()));
                    this.getColony().getWorld().func_184138_a(scarecrow.func_174877_v(), this.getColony().getWorld().func_180495_p(scarecrow.func_174877_v()), this.getColony().getWorld().func_180495_p(scarecrow.func_174877_v()), 3);
                    continue;
                }
                this.farmerFields.remove(field);
                if (this.currentField == null || !this.currentField.equals((Object)field)) continue;
                this.currentField = null;
            }
        }
    }

    public boolean assignManually() {
        return this.shouldAssignManually;
    }

    public void freeField(BlockPos position) {
        TileEntity scarecrow = this.getColony().getWorld().func_175625_s(position);
        if (scarecrow instanceof ScarecrowTileEntity) {
            this.farmerFields.remove(position);
            ((ScarecrowTileEntity)scarecrow).setTaken(false);
            ((ScarecrowTileEntity)scarecrow).setOwner(0);
            this.getColony().getWorld().func_184138_a(scarecrow.func_174877_v(), this.getColony().getWorld().func_180495_p(scarecrow.func_174877_v()), this.getColony().getWorld().func_180495_p(scarecrow.func_174877_v()), 3);
            ((ScarecrowTileEntity)scarecrow).setName(LanguageHandler.format("com.minecolonies.coremod.gui.scarecrow.user", LanguageHandler.format("com.minecolonies.coremod.gui.scarecrow.user.noone", new Object[0])));
        }
    }

    public void assignField(BlockPos position) {
        TileEntity scarecrow = this.getColony().getWorld().func_175625_s(position);
        if (scarecrow instanceof ScarecrowTileEntity) {
            ((ScarecrowTileEntity)scarecrow).setTaken(true);
            if (this.getMainCitizen() != null) {
                ((ScarecrowTileEntity)scarecrow).setOwner(this.getMainCitizen().getId());
            }
            this.farmerFields.add(position);
        }
    }

    public void setAssignManually(boolean assignManually) {
        this.shouldAssignManually = assignManually;
    }

    public static class View
    extends AbstractBuildingWorker.View {
        private boolean shouldAssignFieldManually;
        @NotNull
        private List<BlockPos> fields = new ArrayList<BlockPos>();
        private int amountOfFields;

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutFarmer(this);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            this.fields = new ArrayList<BlockPos>();
            super.deserialize(buf);
            this.shouldAssignFieldManually = buf.readBoolean();
            int size = buf.readInt();
            for (int i = 1; i <= size; ++i) {
                BlockPos pos = BlockPosUtil.readFromByteBuf(buf);
                this.fields.add(pos);
            }
            this.amountOfFields = buf.readInt();
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.ENDURANCE;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.CHARISMA;
        }

        public boolean assignFieldManually() {
            return this.shouldAssignFieldManually;
        }

        @NotNull
        public List<BlockPos> getFields() {
            return Collections.unmodifiableList(this.fields);
        }

        public int getAmountOfFields() {
            return this.amountOfFields;
        }

        public void setAssignFieldManually(boolean assignFieldManually) {
            MineColonies.getNetwork().sendToServer((IMessage)new AssignmentModeMessage(this, assignFieldManually));
            this.shouldAssignFieldManually = assignFieldManually;
        }

        public void changeFields(BlockPos id, boolean addNewField, ScarecrowTileEntity scarecrowTileEntity) {
            MineColonies.getNetwork().sendToServer((IMessage)new AssignFieldMessage(this, addNewField, id));
            scarecrowTileEntity.setTaken(addNewField);
            if (addNewField && !this.getWorkerId().isEmpty()) {
                scarecrowTileEntity.setOwner(this.getWorkerId().get(0), this.getColony());
                ++this.amountOfFields;
            } else {
                scarecrowTileEntity.setOwner(0, this.getColony());
                --this.amountOfFields;
            }
        }
    }
}

