/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.client.gui.WindowHutWorkerPlaceholder;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingCrafter;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobBlacksmith;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;

public class BuildingBlacksmith
extends AbstractBuildingCrafter {
    private static final String BLACKSMITH = "Blacksmith";

    public BuildingBlacksmith(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BLACKSMITH;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobBlacksmith(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return BLACKSMITH;
    }

    @Override
    public boolean canRecipeBeAdded(IToken token) {
        if (!super.canRecipeBeAdded(token)) {
            return false;
        }
        IRecipeStorage storage = (IRecipeStorage)ColonyManager.getRecipeManager().getRecipes().get((Object)token);
        if (storage == null) {
            return false;
        }
        int size = storage.getCleanedInput().size();
        int ingots = 0;
        for (ItemStorage itemStorage : storage.getCleanedInput()) {
            ItemStack stack = itemStorage.getItemStack();
            if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
            for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                String name = OreDictionary.getOreName((int)id);
                if (!name.contains("ingot")) continue;
                ++ingots;
            }
        }
        ItemStack output = storage.getPrimaryOutput();
        return output.func_77973_b() instanceof ItemTool || output.func_77973_b() instanceof ItemSword || output.func_77973_b() instanceof ItemArmor || output.func_77973_b() instanceof ItemHoe || Compatibility.isTinkersWeapon(output) || ingots == size;
    }

    public static class View
    extends AbstractBuildingCrafter.View {
        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerPlaceholder<View>(this, BuildingBlacksmith.BLACKSMITH);
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.DEXTERITY;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.STRENGTH;
        }
    }
}

