/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.jetbrains.annotations.NotNull;

public class BuildingBarracksTower
extends AbstractBuildingGuards {
    private static final String TAG_POS = "pos";
    private static final String SCHEMATIC_NAME = "BarracksTower";
    private static final int DEFENCE_BONUS = 0;
    private static final int OFFENCE_BONUS = 5;
    private BlockPos barracks = null;

    public BuildingBarracksTower(@NotNull Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public int getDefenceBonus() {
        return 0;
    }

    @Override
    public int getOffenceBonus() {
        return 5;
    }

    @Override
    public String getSchematicName() {
        return SCHEMATIC_NAME;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void requestUpgrade(EntityPlayer player, BlockPos builder) {
        int buildingLevel = this.getBuildingLevel();
        AbstractBuilding building = this.getColony().getBuildingManager().getBuilding(this.barracks);
        if (building != null && buildingLevel < this.getMaxBuildingLevel() && buildingLevel < building.getBuildingLevel()) {
            this.requestWorkOrder(buildingLevel + 1, builder);
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.worker.needBarracks", new Object[0]));
        }
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        this.getColony().getCitizenManager().calculateMaxCitizens();
    }

    @Override
    public boolean assignCitizen(CitizenData citizen) {
        boolean assignalResult = super.assignCitizen(citizen);
        if (citizen != null && assignalResult) {
            AbstractBuilding building = citizen.getHomeBuilding();
            if (building != null && !(building instanceof AbstractBuildingGuards)) {
                building.removeCitizen(citizen);
            }
            citizen.setHomeBuilding(this);
            citizen.setWorkBuilding(this);
        }
        return assignalResult;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.barracks = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l(TAG_POS));
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (this.barracks != null) {
            compound.func_74782_a(TAG_POS, (NBTBase)NBTUtil.func_186859_a((BlockPos)this.barracks));
        }
    }

    @Override
    public int getMaxInhabitants() {
        return this.getBuildingLevel();
    }

    public void addBarracks(BlockPos pos) {
        this.barracks = pos;
    }

    public static class View
    extends AbstractBuildingGuards.View {
        public View(ColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }

        @Override
        public boolean hasEnoughWorkers() {
            return this.getWorkerId().size() >= this.getBuildingLevel();
        }
    }
}

