/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.views;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemBuildingDataStore;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.blockout.Log;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.network.messages.OpenInventoryMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingView
implements IRequester {
    private final ColonyView colony;
    @NotNull
    private final BlockPos location;
    private int buildingLevel = 0;
    private int buildingMaxLevel = 0;
    private int buildingDmPrio = 1;
    private boolean buildingDmPrioState = false;
    private int rotation;
    private boolean isBuildingMirrored;
    private int workOrderLevel = 0;
    private ImmutableCollection<IToken<?>> resolvers;
    private IToken<?> requesterId;
    @NotNull
    private IToken<?> rsDataStoreToken;
    private String schematicName;
    private String style;

    protected AbstractBuildingView(ColonyView c, @NotNull BlockPos l) {
        this.colony = c;
        this.location = new BlockPos((Vec3i)l);
    }

    @NotNull
    public BlockPos getID() {
        return this.location;
    }

    @NotNull
    public BlockPos getLocation() {
        return this.location;
    }

    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    public int getBuildingMaxLevel() {
        return this.buildingMaxLevel;
    }

    public boolean isBuildingMaxLevel() {
        return this.buildingLevel >= this.buildingMaxLevel;
    }

    public int getCurrentWorkOrderLevel() {
        return this.workOrderLevel;
    }

    public String getSchematicName() {
        return this.schematicName;
    }

    public String getStyle() {
        return this.style;
    }

    public int getRotation() {
        return this.rotation;
    }

    public boolean isMirrored() {
        return this.isBuildingMirrored;
    }

    public boolean hasWorkOrder() {
        return this.workOrderLevel != 0;
    }

    public boolean isBuilding() {
        return this.workOrderLevel != 0 && this.workOrderLevel > this.buildingLevel;
    }

    public boolean isRepairing() {
        return this.workOrderLevel != 0 && this.workOrderLevel == this.buildingLevel;
    }

    public void openGui(boolean shouldOpenInv) {
        if (shouldOpenInv) {
            MineColonies.getNetwork().sendToServer((IMessage)new OpenInventoryMessage(this.getID()));
        } else {
            Window window = this.getWindow();
            if (window != null) {
                window.open();
            }
        }
    }

    @Nullable
    public Window getWindow() {
        return null;
    }

    public void deserialize(@NotNull ByteBuf buf) {
        this.buildingLevel = buf.readInt();
        this.buildingMaxLevel = buf.readInt();
        this.buildingDmPrio = buf.readInt();
        this.buildingDmPrioState = buf.readBoolean();
        this.workOrderLevel = buf.readInt();
        this.style = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.schematicName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.rotation = buf.readInt();
        this.isBuildingMirrored = buf.readBoolean();
        ArrayList list = new ArrayList();
        int resolverSize = buf.readInt();
        for (int i = 0; i < resolverSize; ++i) {
            NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)buf);
            if (compound == null) continue;
            list.add(StandardFactoryController.getInstance().deserialize(compound));
        }
        this.resolvers = ImmutableList.copyOf(list);
        NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)buf);
        if (compound != null) {
            this.requesterId = (IToken)StandardFactoryController.getInstance().deserialize(compound);
        }
        this.loadRequestSystemFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    private void loadRequestSystemFromNBT(NBTTagCompound compound) {
        this.rsDataStoreToken = (IToken)StandardFactoryController.getInstance().deserialize(compound.func_74775_l("DataStoreToken"));
    }

    private IRequestSystemBuildingDataStore getDataStore() {
        return this.colony.getRequestManager().getDataStoreManager().get(this.rsDataStoreToken, TypeConstants.REQUEST_SYSTEM_BUILDING_DATA_STORE);
    }

    public Map<Integer, Collection<IToken<?>>> getOpenRequestsByCitizen() {
        return this.getDataStore().getOpenRequestsByCitizen();
    }

    private Map<IToken<?>, Integer> getCitizensByRequest() {
        return this.getDataStore().getCitizensByRequest();
    }

    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfType(@NotNull CitizenDataView citizenData, Class<R> requestType) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData).stream().filter(request -> {
            Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(request.getRequestType());
            return requestTypes.contains(TypeToken.of((Class)requestType));
        }).map(request -> request).iterator());
    }

    public ImmutableList<IRequest> getOpenRequests(@NotNull CitizenDataView data) {
        if (data == null || this.getColony() == null || this.getColony().getRequestManager() == null) {
            return ImmutableList.of();
        }
        if (!this.getOpenRequestsByCitizen().containsKey(data.getId())) {
            return ImmutableList.of();
        }
        Collection<IToken<?>> list = this.getOpenRequestsByCitizen().get(data.getId());
        if (list == null || list.isEmpty()) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(list.stream().filter(Objects::nonNull).map(this.getColony().getRequestManager()::getRequestForToken).filter(Objects::nonNull).iterator());
    }

    public ImmutableList<IRequest> getOpenRequestsOfBuilding() {
        return ImmutableList.copyOf(this.getOpenRequestsByCitizen().values().stream().flatMap(Collection::stream).filter(Objects::nonNull).map(this.getColony().getRequestManager()::getRequestForToken).filter(Objects::nonNull).iterator());
    }

    public ColonyView getColony() {
        return this.colony;
    }

    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfTypeFiltered(@NotNull CitizenDataView citizenData, Class<R> requestType, Predicate<IRequest<? extends R>> filter) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData).stream().filter(request -> {
            Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(request.getRequestType());
            return requestTypes.contains(TypeToken.of((Class)requestType));
        }).map(request -> request).filter(filter).iterator());
    }

    @Override
    public IToken<?> getRequesterId() {
        return this.requesterId;
    }

    @Override
    @NotNull
    public ILocation getRequesterLocation() {
        return null;
    }

    @Override
    public void onRequestComplete(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
        Integer citizenThatRequested = this.getCitizensByRequest().remove(token);
        this.getOpenRequestsByCitizen().get(citizenThatRequested).remove(token);
        if (this.getOpenRequestsByCitizen().get(citizenThatRequested).isEmpty()) {
            this.getOpenRequestsByCitizen().remove(citizenThatRequested);
        }
    }

    @Override
    public void onRequestCancelled(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
        Integer citizenThatRequested = this.getCitizensByRequest().remove(token);
        this.getOpenRequestsByCitizen().get(citizenThatRequested).remove(token);
        if (this.getOpenRequestsByCitizen().get(citizenThatRequested).isEmpty()) {
            this.getOpenRequestsByCitizen().remove(citizenThatRequested);
        }
    }

    @Override
    @NotNull
    public ITextComponent getDisplayName(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
        try {
            if (this.getColony() == null || !this.getCitizensByRequest().containsKey(token) || this.getColony().getCitizen(this.getCitizensByRequest().get(token)) == null) {
                return new TextComponentString("<UNKNOWN>");
            }
            return new TextComponentString(this.getColony().getCitizen(this.getCitizensByRequest().get(token)).getName());
        }
        catch (Exception ex) {
            Log.getLogger().warn((Object)ex);
            return new TextComponentString("");
        }
    }

    public int getBuildingDmPrio() {
        return this.buildingDmPrio;
    }

    public boolean getBuildingDmPrioState() {
        return this.buildingDmPrioState;
    }

    public ImmutableCollection<IToken<?>> getResolverIds() {
        return this.resolvers;
    }
}

