/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.google.common.collect.ImmutableList;
import com.minecolonies.blockout.Log;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonHandler;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.controls.TextField;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowRequestTree;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.OpenInventoryMessage;
import com.minecolonies.coremod.network.messages.PostBoxRequestMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowPostBox
extends AbstractWindowRequestTree
implements ButtonHandler {
    private final List<ItemStack> allItems = new ArrayList<ItemStack>();
    private final ScrollingList stackList;
    private String filter = "";
    private final AbstractBuildingView buildingView;

    public WindowPostBox(AbstractBuildingView buildingView) {
        super(buildingView.getID(), "minecolonies:gui/windowpostbox.xml", buildingView.getColony());
        this.buildingView = buildingView;
        this.stackList = this.findPaneOfTypeByID("resources", ScrollingList.class);
        this.registerButton("inventory", this::inventoryClicked);
        this.registerButton("request", this::requestClicked);
    }

    private void requestClicked(Button button) {
        int row = this.stackList.getListElementIndexByPane(button);
        ItemStack stack = this.allItems.get(row);
        int qty = stack.func_77976_d();
        for (Pane child : button.getParent().getChildren()) {
            if (!child.getID().equals("qty")) continue;
            try {
                qty = Integer.parseInt(((TextField)child).getText());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        while (qty > 0) {
            int requestSize = qty > stack.func_77976_d() ? stack.func_77976_d() : qty;
            qty -= requestSize;
            MineColonies.getNetwork().sendToServer((IMessage)new PostBoxRequestMessage(this.buildingView, stack.func_77946_l(), requestSize));
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.updateResources();
    }

    private void updateResources() {
        Predicate<ItemStack> filterPredicate = stack -> this.filter.isEmpty() || stack.func_77977_a().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || stack.func_82833_r().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US));
        this.allItems.clear();
        this.allItems.addAll(this.getBlockList(filterPredicate));
        this.updateResourceList();
    }

    private Collection<? extends ItemStack> getBlockList(Predicate<ItemStack> filterPredicate) {
        return ImmutableList.copyOf((Collection)StreamSupport.stream(Spliterators.spliteratorUnknownSize(Item.field_150901_e.iterator(), 16), false).flatMap(item -> {
            NonNullList stacks = NonNullList.func_191196_a();
            try {
                item.func_150895_a(CreativeTabs.field_78027_g, stacks);
            }
            catch (Exception ex) {
                Log.getLogger().warn("Failed to get sub items from: " + item.getRegistryName(), (Throwable)ex);
            }
            return stacks.stream().filter(filterPredicate);
        }).collect(Collectors.toList()));
    }

    private void inventoryClicked() {
        MineColonies.getNetwork().sendToServer((IMessage)new OpenInventoryMessage(this.buildingView.getID()));
    }

    private void updateResourceList() {
        this.stackList.enable();
        this.stackList.show();
        final ArrayList<ItemStack> tempRes = new ArrayList<ItemStack>(this.allItems);
        this.stackList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return tempRes.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = (ItemStack)tempRes.get(index);
                Label resourceLabel = rowPane.findPaneOfTypeByID("resourceName", Label.class);
                resourceLabel.setLabelText(resource.func_82833_r());
                rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class).setItem(resource);
            }
        });
    }

    @Override
    public boolean onKeyTyped(char ch, int key) {
        boolean result = super.onKeyTyped(ch, key);
        this.filter = this.findPaneOfTypeByID("name", TextField.class).getText();
        this.updateResources();
        return result;
    }
}

