/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.LanguageHandler;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockPosUtil {
    private static final int MAX_DEPTH = 50;
    private static final int BLOCKPOS_LENGTH = 3;

    private BlockPosUtil() {
    }

    public static NBTTagCompound writeToNBT(@NotNull NBTTagCompound compound, String name, @NotNull BlockPos pos) {
        NBTTagCompound coordsCompound = new NBTTagCompound();
        coordsCompound.func_74768_a("x", pos.func_177958_n());
        coordsCompound.func_74768_a("y", pos.func_177956_o());
        coordsCompound.func_74768_a("z", pos.func_177952_p());
        compound.func_74782_a(name, (NBTBase)coordsCompound);
        return compound;
    }

    private static Tuple<EnumFacing, EnumFacing> getRandomDirectionTuple(Random random) {
        return new Tuple((Object)EnumFacing.func_176741_a((Random)random), (Object)EnumFacing.func_176741_a((Random)random));
    }

    public static BlockPos getRandomPosition(World world, BlockPos currentPosition, BlockPos def) {
        Random random = new Random();
        int tries = 0;
        BlockPos pos = null;
        while (pos == null || world.func_180495_p(pos).func_185904_a().func_76224_d() || !world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a() || !world.func_175623_d(pos) && !world.func_175623_d(pos.func_177984_a())) {
            Tuple<EnumFacing, EnumFacing> direction = BlockPosUtil.getRandomDirectionTuple(random);
            pos = new BlockPos((Vec3i)currentPosition).func_177967_a((EnumFacing)direction.func_76341_a(), random.nextInt(10)).func_177967_a((EnumFacing)direction.func_76340_b(), random.nextInt(10)).func_177981_b(random.nextInt(4)).func_177979_c(random.nextInt(4));
            if (tries >= 20) {
                return def;
            }
            ++tries;
        }
        return pos;
    }

    @NotNull
    public static BlockPos readFromNBT(@NotNull NBTTagCompound compound, String name) {
        NBTTagCompound coordsCompound = compound.func_74775_l(name);
        int x = coordsCompound.func_74762_e("x");
        int y = coordsCompound.func_74762_e("y");
        int z = coordsCompound.func_74762_e("z");
        return new BlockPos(x, y, z);
    }

    public static void writeToNBTTagList(@NotNull NBTTagList tagList, @NotNull BlockPos pos) {
        NBTTagCompound coordsCompound = new NBTTagCompound();
        coordsCompound.func_74768_a("x", pos.func_177958_n());
        coordsCompound.func_74768_a("y", pos.func_177956_o());
        coordsCompound.func_74768_a("z", pos.func_177952_p());
        tagList.func_74742_a((NBTBase)coordsCompound);
    }

    @NotNull
    public static BlockPos readFromNBTTagList(@NotNull NBTTagList tagList, int index) {
        NBTTagCompound coordsCompound = tagList.func_150305_b(index);
        int x = coordsCompound.func_74762_e("x");
        int y = coordsCompound.func_74762_e("y");
        int z = coordsCompound.func_74762_e("z");
        return new BlockPos(x, y, z);
    }

    public static void writeToByteBuf(@NotNull ByteBuf buf, @NotNull BlockPos pos) {
        buf.writeInt(pos.func_177958_n());
        buf.writeInt(pos.func_177956_o());
        buf.writeInt(pos.func_177952_p());
    }

    @NotNull
    public static BlockPos readFromByteBuf(@NotNull ByteBuf buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        return new BlockPos(x, y, z);
    }

    @Nullable
    public static BlockPos getBlockPosOfString(@NotNull String inputText) {
        String[] strings = inputText.split(" ");
        if (strings.length == 3) {
            try {
                int x = Integer.parseInt(strings[0]);
                int y = Integer.parseInt(strings[1]);
                int z = Integer.parseInt(strings[2]);
                return new BlockPos(x, y, z);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isPositionSafe(@NotNull World sender, BlockPos blockPos) {
        return sender.func_180495_p(blockPos).func_177230_c() != Blocks.field_150350_a && !sender.func_180495_p(blockPos).func_185904_a().func_76224_d() && !sender.func_180495_p(blockPos.func_177977_b()).func_185904_a().func_76224_d() && sender.func_175723_af().func_177746_a(blockPos);
    }

    public static BlockPos findLand(BlockPos blockPos, World world) {
        int top = blockPos.func_177956_o();
        int bot = 0;
        int mid = blockPos.func_177956_o();
        BlockPos foundland = null;
        BlockPos tempPos = blockPos;
        while (top >= bot) {
            Block blocks = world.func_180495_p(tempPos = new BlockPos(tempPos.func_177958_n(), mid, tempPos.func_177952_p())).func_177230_c();
            if (blocks == Blocks.field_150350_a && world.func_175678_i(tempPos)) {
                top = mid - 1;
                foundland = tempPos;
            } else {
                bot = mid + 1;
                foundland = tempPos;
            }
            mid = (bot + top) / 2;
        }
        if (world.func_180495_p(tempPos).func_185904_a().func_76220_a()) {
            return foundland.func_177984_a();
        }
        return foundland;
    }

    public static double getValidHeight(@NotNull Vec3d position, @NotNull World world) {
        double returnHeight = position.field_72448_b;
        if (position.field_72448_b < 0.0) {
            returnHeight = 0.0;
        }
        while (returnHeight >= 1.0 && world.func_175623_d(new BlockPos(MathHelper.func_76128_c((double)position.field_72450_a), (int)returnHeight, MathHelper.func_76128_c((double)position.field_72449_c)))) {
            returnHeight -= 1.0;
        }
        while (!world.func_175623_d(new BlockPos(MathHelper.func_76128_c((double)position.field_72450_a), (int)returnHeight, MathHelper.func_76128_c((double)position.field_72449_c)))) {
            returnHeight += 1.0;
        }
        return returnHeight;
    }

    public static long getDistanceSquared(@NotNull BlockPos block1, @NotNull BlockPos block2) {
        long zDiff;
        long yDiff;
        long xDiff = (long)block1.func_177958_n() - (long)block2.func_177958_n();
        long result = xDiff * xDiff + (yDiff = (long)block1.func_177956_o() - (long)block2.func_177956_o()) * yDiff + (zDiff = (long)block1.func_177952_p() - (long)block2.func_177952_p()) * zDiff;
        if (result < 0L) {
            throw new IllegalStateException("max-sqrt is to high! Failure to catch overflow with " + xDiff + " | " + yDiff + " | " + zDiff);
        }
        return result;
    }

    public static long getDistance2D(@NotNull BlockPos block1, @NotNull BlockPos block2) {
        long xDiff = Math.abs((long)block1.func_177958_n() - (long)block2.func_177958_n());
        long zDiff = Math.abs((long)block1.func_177952_p() - (long)block2.func_177952_p());
        return Math.abs(xDiff + zDiff);
    }

    public static long getDistanceSquared2D(@NotNull BlockPos block1, @NotNull BlockPos block2) {
        long zDiff;
        long xDiff = (long)block1.func_177958_n() - (long)block2.func_177958_n();
        long result = xDiff * xDiff + (zDiff = (long)block1.func_177952_p() - (long)block2.func_177952_p()) * zDiff;
        if (result < 0L) {
            throw new IllegalStateException("max-sqrt is to high! Failure to catch overflow with " + xDiff + " | " + zDiff);
        }
        return result;
    }

    public static TileEntity getTileEntity(@NotNull World world, @NotNull BlockPos pos) {
        return world.func_175625_s(pos);
    }

    public static List<ItemStack> getBlockDrops(@NotNull World world, @NotNull BlockPos coords, int fortune) {
        NonNullList drops = NonNullList.func_191196_a();
        BlockPosUtil.getBlock(world, coords).getDrops(drops, (IBlockAccess)world, new BlockPos(coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p()), BlockPosUtil.getBlockState(world, coords), fortune);
        return drops;
    }

    public static Block getBlock(@NotNull World world, @NotNull BlockPos coords) {
        return world.func_180495_p(coords).func_177230_c();
    }

    public static IBlockState getBlockState(@NotNull World world, @NotNull BlockPos coords) {
        return world.func_180495_p(coords);
    }

    public static boolean setBlock(@NotNull World worldIn, @NotNull BlockPos coords, IBlockState state, int flag) {
        return worldIn.func_180501_a(coords, state, flag);
    }

    public static boolean tryMoveLivingToXYZ(@NotNull EntityLiving living, @NotNull BlockPos destination) {
        return EntityUtils.tryMoveLivingToXYZ(living, destination.func_177958_n(), destination.func_177956_o(), destination.func_177952_p());
    }

    public static void set(@NotNull BlockPos.MutableBlockPos pos, @NotNull BlockPos newPos) {
        pos.func_181079_c(newPos.func_177958_n(), newPos.func_177956_o(), newPos.func_177952_p());
    }

    public static boolean isEqual(@NotNull BlockPos coords, int x, int y, int z) {
        return coords.func_177958_n() == x && coords.func_177956_o() == y && coords.func_177952_p() == z;
    }

    @NotNull
    public static BlockPos fromEntity(@NotNull Entity entity) {
        return new BlockPos(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70163_u), MathHelper.func_76128_c((double)entity.field_70161_v));
    }

    @NotNull
    public static BlockPos getFloor(@NotNull BlockPos position, @NotNull World world) {
        BlockPos floor = BlockPosUtil.getFloor(position, 0, world);
        if (floor == null) {
            return position;
        }
        return floor;
    }

    @Nullable
    public static BlockPos getFloor(@NotNull BlockPos position, int depth, @NotNull World world) {
        if (depth > 50) {
            return null;
        }
        if (!EntityUtils.solidOrLiquid(world, position)) {
            return BlockPosUtil.getFloor(position.func_177977_b(), depth + 1, world);
        }
        if (!EntityUtils.solidOrLiquid(world, position.func_177984_a())) {
            return position;
        }
        return BlockPosUtil.getFloor(position.func_177984_a(), depth + 1, world);
    }

    public static EnumFacing getFacing(BlockPos pos, BlockPos neighbor) {
        BlockPos vector = neighbor.func_177973_b((Vec3i)pos);
        return EnumFacing.func_176737_a((float)vector.func_177958_n(), (float)vector.func_177956_o(), (float)(-vector.func_177952_p()));
    }

    public static EnumFacing getXZFacing(BlockPos pos, BlockPos neighbor) {
        BlockPos vector = neighbor.func_177973_b((Vec3i)pos);
        return EnumFacing.func_176737_a((float)vector.func_177958_n(), (float)0.0f, (float)vector.func_177952_p());
    }

    public static String calcDirection(@NotNull BlockPos building, @NotNull BlockPos pos) {
        StringBuilder dist = new StringBuilder();
        if (pos.func_177952_p() > building.func_177952_p() + 1) {
            dist.append(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.farmerHut.South", new Object[0]));
        } else if (pos.func_177952_p() < building.func_177952_p() - 1) {
            dist.append(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.farmerHut.North", new Object[0]));
        }
        if (pos.func_177958_n() > building.func_177958_n() + 1) {
            if (!dist.toString().isEmpty()) {
                dist.append('/');
            }
            dist.append(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.farmerHut.East", new Object[0]));
        } else if (pos.func_177958_n() < building.func_177958_n() - 1) {
            if (!dist.toString().isEmpty()) {
                dist.append('/');
            }
            dist.append(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.farmerHut.West", new Object[0]));
        }
        return dist.toString();
    }

    public static Rotation getRotationFromRotations(int rotations) {
        switch (rotations) {
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }
}

