/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ynot.mekanism;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.xnet.api.channels.IControllerContext;
import mcjty.xnet.api.gui.IEditorGui;
import mcjty.xnet.api.gui.IndicatorIcon;
import mcjty.xnet.api.helper.AbstractConnectorSettings;
import mcjty.xnet.api.keys.SidedConsumer;
import mcjty.xnet.config.GeneralConfiguration;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import pl.asie.ynot.YNot;
import pl.asie.ynot.enums.InsertionMode;
import pl.asie.ynot.enums.LiquidTransferMode;
import pl.asie.ynot.mekanism.GasConnectorSettings;
import pl.asie.ynot.traits.TraitEnum;
import pl.asie.ynot.traits.TraitedChannelSettings;

public class GasChannelSettings
extends TraitedChannelSettings {
    @CapabilityInject(value=IGasHandler.class)
    private static Capability<IGasHandler> GAS_HANDLER_CAPABILITY;
    private TraitEnum<LiquidTransferMode> transferMode = new TraitEnum<LiquidTransferMode>("mode", LiquidTransferMode.class, LiquidTransferMode.DISTRIBUTE);
    private Map<SidedConsumer, GasConnectorSettings> gasExtractors = null;
    private List<Pair<SidedConsumer, GasConnectorSettings>> gasConsumers = null;
    private int roundRobinOffset = 0;
    private int delay = 0;

    public GasChannelSettings() {
        this.register(this.transferMode);
    }

    @Nullable
    public static IGasHandler getGasHandler(TileEntity tile, EnumFacing facing) {
        if (tile instanceof IGasHandler) {
            return (IGasHandler)tile;
        }
        if (tile != null && tile.hasCapability(GAS_HANDLER_CAPABILITY, facing)) {
            return (IGasHandler)tile.getCapability(GAS_HANDLER_CAPABILITY, facing);
        }
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.delay = tag.func_74762_e("delay");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("delay", this.delay);
    }

    public void tick(int channel, IControllerContext context) {
        this.updateCache(channel, context);
        --this.delay;
        while (this.delay <= 0) {
            this.delay += 1200;
        }
        if (this.delay % 10 != 0) {
            return;
        }
        World world = context.getControllerWorld();
        for (Map.Entry<SidedConsumer, GasConnectorSettings> entry : this.gasExtractors.entrySet()) {
            IGasHandler handler;
            EnumFacing side;
            BlockPos pos;
            BlockPos extractorPos;
            GasConnectorSettings settings = entry.getValue();
            GasStack filterGas = settings.getFilter();
            if (this.delay % settings.speeds.get() != 0 || (extractorPos = context.findConsumerPosition(entry.getKey().getConsumerId())) == null || !this.shouldCheck(context, pos = extractorPos.func_177972_a(side = entry.getKey().getSide()), extractorPos, settings) || (handler = GasChannelSettings.getGasHandler(world.func_175625_s(pos), settings.getFacing())) == null) continue;
            int amount = settings.getRate();
            GasStack gas = handler.drawGas(settings.getFacing(), amount, false);
            if (gas == null || filterGas != null && !filterGas.isGasEqual(gas)) continue;
            ArrayList<Triple<SidedConsumer, GasConnectorSettings, Integer>> inserted = new ArrayList<Triple<SidedConsumer, GasConnectorSettings, Integer>>();
            int remaining = this.insertGasSimulate(inserted, context, gas);
            if (inserted.isEmpty() || !context.checkAndConsumeRF(GeneralConfiguration.controllerOperationRFT)) continue;
            gas = handler.drawGas(settings.getFacing(), gas.amount - remaining, true);
            this.insertGasReal(context, inserted, gas);
        }
    }

    private void insertGasReal(IControllerContext context, List<Triple<SidedConsumer, GasConnectorSettings, Integer>> inserted, GasStack stack) {
        int amount = stack.amount;
        for (Triple<SidedConsumer, GasConnectorSettings, Integer> pair : inserted) {
            BlockPos consumerPos = context.findConsumerPosition(((SidedConsumer)pair.getLeft()).getConsumerId());
            if (consumerPos == null) continue;
            EnumFacing side = ((SidedConsumer)pair.getLeft()).getSide();
            GasConnectorSettings settings = (GasConnectorSettings)((Object)pair.getMiddle());
            GasStack filterGas = settings.getFilter();
            if (filterGas != null && !filterGas.isGasEqual(stack)) continue;
            BlockPos pos = consumerPos.func_177972_a(side);
            IGasHandler handler = GasChannelSettings.getGasHandler(context.getControllerWorld().func_175625_s(pos), settings.getFacing());
            if (handler == null) continue;
            int toinsert = Math.min(settings.getRate(), amount);
            GasStack copy = stack.copy();
            copy.amount = toinsert;
            int filled = handler.receiveGas(settings.getFacing(), copy, true);
            if (filled <= 0) continue;
            this.roundRobinOffset = ((Integer)pair.getRight() + 1) % this.gasConsumers.size();
            if ((amount -= filled) > 0) continue;
            return;
        }
    }

    private int insertGasSimulate(@Nonnull List<Triple<SidedConsumer, GasConnectorSettings, Integer>> inserted, @Nonnull IControllerContext context, @Nonnull GasStack stack) {
        World world = context.getControllerWorld();
        if (this.transferMode.get() == LiquidTransferMode.PRIORITY) {
            this.roundRobinOffset = 0;
        }
        int amount = stack.amount;
        for (int j = 0; j < this.gasConsumers.size(); ++j) {
            IGasHandler handler;
            int i = (j + this.roundRobinOffset) % this.gasConsumers.size();
            Pair<SidedConsumer, GasConnectorSettings> entry = this.gasConsumers.get(i);
            GasConnectorSettings settings = (GasConnectorSettings)((Object)entry.getValue());
            BlockPos consumerPos = context.findConsumerPosition(((SidedConsumer)entry.getKey()).getConsumerId());
            EnumFacing side = ((SidedConsumer)entry.getKey()).getSide();
            BlockPos pos = consumerPos.func_177972_a(side);
            if (consumerPos == null || !this.shouldCheck(context, pos, consumerPos, (AbstractConnectorSettings)entry.getValue()) || (handler = GasChannelSettings.getGasHandler(world.func_175625_s(pos), settings.getFacing())) == null || !handler.canReceiveGas(settings.getFacing(), stack.getGas())) continue;
            int toinsert = Math.min(settings.getRate(), amount);
            GasStack copy = stack.copy();
            copy.amount = toinsert;
            int filled = handler.receiveGas(settings.getFacing(), copy, false);
            if (filled <= 0) continue;
            inserted.add((Triple<SidedConsumer, GasConnectorSettings, Integer>)Triple.of((Object)entry.getLeft(), (Object)entry.getRight(), (Object)i));
            if ((amount -= filled) > 0) continue;
            return 0;
        }
        return amount;
    }

    public void cleanCache() {
        this.gasExtractors = null;
        this.gasConsumers = null;
    }

    public int getColors() {
        return 0;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(YNot.iconGui, 0, 0, 11, 10);
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public boolean isEnabled(String tag) {
        return true;
    }

    public void createGui(IEditorGui gui) {
        gui.nl();
        this.transferMode.apply("Gas distribution mode", gui);
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.gasExtractors == null) {
            GasConnectorSettings con;
            this.gasExtractors = new HashMap<SidedConsumer, GasConnectorSettings>();
            this.gasConsumers = new ArrayList<Pair<SidedConsumer, GasConnectorSettings>>();
            Map connectors = context.getConnectors(channel);
            for (Map.Entry entry : connectors.entrySet()) {
                con = (GasConnectorSettings)((Object)entry.getValue());
                if (con.insertionMode.get() == InsertionMode.EXT) {
                    this.gasExtractors.put((SidedConsumer)entry.getKey(), con);
                    continue;
                }
                this.gasConsumers.add((Pair<SidedConsumer, GasConnectorSettings>)Pair.of(entry.getKey(), (Object)((Object)con)));
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry entry : connectors.entrySet()) {
                con = (GasConnectorSettings)((Object)entry.getValue());
                if (con.insertionMode.get() != InsertionMode.INS) continue;
                this.gasConsumers.add((Pair<SidedConsumer, GasConnectorSettings>)Pair.of(entry.getKey(), (Object)((Object)con)));
            }
            this.gasConsumers.sort((o1, o2) -> ((GasConnectorSettings)((Object)((Object)o2.getRight()))).priority.get().compareTo(((GasConnectorSettings)((Object)((Object)o1.getRight()))).priority.get()));
        }
    }
}

