/*
 * Decompiled with CFR 0.152.
 */
package teamroots.roots.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class Misc {
    public static Random random = new Random();

    public static EnumFacing getOppositeHorizontalFace(EnumFacing face) {
        if (face == EnumFacing.DOWN) {
            return EnumFacing.DOWN;
        }
        if (face == EnumFacing.UP) {
            return EnumFacing.UP;
        }
        return face.func_176734_d();
    }

    public static int intColor(int r, int g, int b) {
        return r * 65536 + g * 256 + b;
    }

    public static boolean matchOreDict(ItemStack stack1, ItemStack stack2) {
        int[] keys1 = OreDictionary.getOreIDs((ItemStack)stack1);
        int[] keys2 = OreDictionary.getOreIDs((ItemStack)stack2);
        for (int i = 0; i < keys1.length; ++i) {
            for (int j = 0; j < keys2.length; ++j) {
                if (keys1[i] != keys2[j]) continue;
                return true;
            }
        }
        return false;
    }

    public static float yawDegreesBetweenPoints(double posX, double posY, double posZ, double posX2, double posY2, double posZ2) {
        float f = (float)(180.0 * Math.atan2(posX2 - posX, posZ2 - posZ) / 3.1415927410125732);
        return f;
    }

    public static float pitchDegreesBetweenPoints(double posX, double posY, double posZ, double posX2, double posY2, double posZ2) {
        return (float)Math.toDegrees(Math.atan2(posY2 - posY, Math.sqrt((posX2 - posX) * (posX2 - posX) + (posZ2 - posZ) * (posZ2 - posZ))));
    }

    @SideOnly(value=Side.CLIENT)
    public static ArrayList<String> getLines(String s, int lineWidth) {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> words = new ArrayList<String>();
        String temp = "";
        int counter = 0;
        for (i = 0; i < s.length(); ++i) {
            temp = temp + s.charAt(i);
            if (s.charAt(i) != ' ') continue;
            words.add(temp);
            temp = "";
        }
        words.add(temp);
        temp = "";
        for (i = 0; i < words.size(); ++i) {
            if ((counter += Minecraft.func_71410_x().field_71466_p.func_78256_a((String)words.get(i))) > lineWidth) {
                list.add(temp);
                temp = (String)words.get(i);
                counter = Minecraft.func_71410_x().field_71466_p.func_78256_a((String)words.get(i));
                continue;
            }
            temp = temp + (String)words.get(i);
        }
        list.add(temp);
        return list;
    }

    public static <T extends TileEntity> List<T> getTileEntitiesWithin(World world, Class<? extends T> teClass, int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList<TileEntity> tiles = new ArrayList<TileEntity>();
        for (int i = x1; i <= x2; ++i) {
            for (int j = y1; j <= y2; ++j) {
                for (int k = z1; k <= z2; ++k) {
                    TileEntity t;
                    BlockPos p = new BlockPos(i, j, k);
                    Chunk c = world.func_175726_f(p);
                    if (!c.func_177410_o() || (t = world.func_175726_f(p).func_177424_a(p, Chunk.EnumCreateEntityType.CHECK)) == null || !teClass.isInstance(t)) continue;
                    tiles.add(t);
                }
            }
        }
        return tiles;
    }

    public static EnumFacing getOppositeFace(EnumFacing face) {
        if (face == EnumFacing.DOWN) {
            return EnumFacing.UP;
        }
        if (face == EnumFacing.UP) {
            return EnumFacing.DOWN;
        }
        return face.func_176734_d();
    }

    public static void spawnInventoryInWorld(World world, double x, double y, double z, IItemHandler inventory) {
        if (inventory != null && !world.field_72995_K) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (inventory.getStackInSlot(i) == null) continue;
                world.func_72838_d((Entity)new EntityItem(world, x, y, z, inventory.getStackInSlot(i)));
            }
        }
    }
}

