/*
 * Decompiled with CFR 0.152.
 */
package teamroots.roots.item;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.roots.EventManager;
import teamroots.roots.event.SpellEvent;
import teamroots.roots.item.ItemBase;
import teamroots.roots.spell.SpellBase;
import teamroots.roots.spell.SpellRegistry;
import teamroots.roots.util.Misc;

public class ItemStaff
extends ItemBase {
    public ItemStaff(String name, boolean addToTab) {
        super(name, addToTab);
        this.func_77625_d(1);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.func_77942_o() && newStack.func_77942_o()) {
            return slotChanged || oldStack.func_77978_p().func_74762_e("selected") != newStack.func_77978_p().func_74762_e("selected");
        }
        return slotChanged;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        SpellBase spell;
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74768_a("selected", 0);
                stack.func_77978_p().func_74778_a("spell0", "null");
                stack.func_77978_p().func_74778_a("spell1", "null");
                stack.func_77978_p().func_74778_a("spell2", "null");
                stack.func_77978_p().func_74778_a("spell3", "null");
            }
            stack.func_77978_p().func_74768_a("selected", stack.func_77978_p().func_74762_e("selected") + 1);
            if (stack.func_77978_p().func_74762_e("selected") > 3) {
                stack.func_77978_p().func_74768_a("selected", 0);
            }
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        if (stack.func_77942_o() && !stack.func_77978_p().func_74764_b("cooldown") && (spell = SpellRegistry.spellRegistry.get(stack.func_77978_p().func_74779_i("spell" + stack.func_77978_p().func_74762_e("selected")))) != null) {
            SpellEvent event = new SpellEvent(player, spell);
            MinecraftForge.EVENT_BUS.post((Event)event);
            spell = event.getSpell();
            if (spell.castType == SpellBase.EnumCastType.INSTANTANEOUS) {
                if (spell.costsMet(player)) {
                    spell.cast(player);
                    spell.enactCosts(player);
                    stack.func_77978_p().func_74768_a("cooldown", event.getCooldown());
                    stack.func_77978_p().func_74768_a("lastCooldown", event.getCooldown());
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
                }
            } else if (spell.castType == SpellBase.EnumCastType.CONTINUOUS) {
                player.func_184598_c(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        SpellBase spell;
        if (stack.func_77942_o() && player instanceof EntityPlayer && !stack.func_77978_p().func_74764_b("cooldown") && (spell = SpellRegistry.spellRegistry.get(stack.func_77978_p().func_74779_i("spell" + stack.func_77978_p().func_74762_e("selected")))) != null && spell.castType == SpellBase.EnumCastType.CONTINUOUS && spell.costsMet((EntityPlayer)player)) {
            spell.cast((EntityPlayer)player);
            spell.enactTickCosts((EntityPlayer)player);
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        SpellBase spell;
        if (stack.func_77942_o() && (spell = SpellRegistry.spellRegistry.get(stack.func_77978_p().func_74779_i("spell" + stack.func_77978_p().func_74762_e("selected")))) != null) {
            SpellEvent event = new SpellEvent((EntityPlayer)entity, spell);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (spell.castType == SpellBase.EnumCastType.CONTINUOUS) {
                stack.func_77978_p().func_74768_a("cooldown", event.getCooldown());
                stack.func_77978_p().func_74768_a("lastCooldown", event.getCooldown());
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("cooldown")) {
            stack.func_77978_p().func_74768_a("cooldown", stack.func_77978_p().func_74762_e("cooldown") - 1);
            if (stack.func_77978_p().func_74762_e("cooldown") <= 0) {
                stack.func_77978_p().func_82580_o("cooldown");
                stack.func_77978_p().func_82580_o("lastCooldown");
            }
        }
    }

    public static void createData(ItemStack stack, String spellName) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("selected", 0);
            stack.func_77978_p().func_74778_a("spell0", "null");
            stack.func_77978_p().func_74778_a("spell1", "null");
            stack.func_77978_p().func_74778_a("spell2", "null");
            stack.func_77978_p().func_74778_a("spell3", "null");
        }
        stack.func_77978_p().func_74778_a("spell" + stack.func_77978_p().func_74762_e("selected"), spellName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("selected", 0);
            stack.func_77978_p().func_74778_a("spell0", "null");
            stack.func_77978_p().func_74778_a("spell1", "null");
            stack.func_77978_p().func_74778_a("spell2", "null");
            stack.func_77978_p().func_74778_a("spell3", "null");
        } else {
            tooltip.add(I18n.func_135052_a((String)"roots.tooltip.staff.selected", (Object[])new Object[0]) + (stack.func_77978_p().func_74762_e("selected") + 1));
            SpellBase spell = SpellRegistry.spellRegistry.get(stack.func_77978_p().func_74779_i("spell" + stack.func_77978_p().func_74762_e("selected")));
            if (spell != null) {
                tooltip.add("");
                spell.addToolTip(tooltip);
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (stack.func_77942_o()) {
            SpellBase spell = SpellRegistry.spellRegistry.get(stack.func_77978_p().func_74779_i("spell" + stack.func_77978_p().func_74762_e("selected")));
            if (stack.func_77978_p().func_74764_b("cooldown") && spell != null) {
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRGBDurabilityForDisplay(ItemStack stack) {
        SpellBase spell;
        if (stack.func_77942_o() && (spell = SpellRegistry.spellRegistry.get(stack.func_77978_p().func_74779_i("spell" + stack.func_77978_p().func_74762_e("selected")))) != null) {
            double factor = 0.5 * (Math.sin(6.0 * Math.toRadians((float)EventManager.ticks + Minecraft.func_71410_x().func_184121_ak())) + 1.0);
            return Misc.intColor((int)(255.0 * ((double)spell.red1 * factor + (double)spell.red2 * (1.0 - factor))), (int)(255.0 * ((double)spell.green1 * factor + (double)spell.green2 * (1.0 - factor))), (int)(255.0 * ((double)spell.blue1 * factor + (double)spell.blue2 * (1.0 - factor))));
        }
        return Misc.intColor(255, 255, 255);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("cooldown")) {
            return (double)stack.func_77978_p().func_74762_e("cooldown") / (double)stack.func_77978_p().func_74762_e("lastCooldown");
        }
        return 0.0;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        SpellBase spell;
        if (stack.func_77942_o() && (spell = SpellRegistry.spellRegistry.get(stack.func_77978_p().func_74779_i("spell" + stack.func_77978_p().func_74762_e("selected")))) != null) {
            if (spell.castType == SpellBase.EnumCastType.CONTINUOUS) {
                return EnumAction.BOW;
            }
            return EnumAction.NONE;
        }
        return EnumAction.NONE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.getRegistryName().toString()), new ModelResourceLocation(this.getRegistryName().toString() + "_1"), new ModelResourceLocation("roots:shiny_rod"), new ModelResourceLocation("roots:shiny_rod_1"), new ModelResourceLocation("roots:moon_rod"), new ModelResourceLocation("roots:moon_rod_1")});
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                ResourceLocation baseName = ItemStaff.this.getRegistryName();
                if (stack.func_82833_r().compareToIgnoreCase("Shiny Rod") == 0) {
                    baseName = new ResourceLocation("roots:shiny_rod");
                }
                if (stack.func_82833_r().compareToIgnoreCase("Cutie Moon Rod") == 0) {
                    baseName = new ResourceLocation("roots:moon_rod");
                }
                if (stack.func_77942_o()) {
                    String s = stack.func_77978_p().func_74779_i("spell" + stack.func_77978_p().func_74762_e("selected"));
                    if (SpellRegistry.spellRegistry.containsKey(s)) {
                        return new ModelResourceLocation(baseName.toString() + "_1");
                    }
                    return new ModelResourceLocation(baseName.toString());
                }
                return new ModelResourceLocation(baseName.toString());
            }
        });
    }

    public static class StaffColorHandler
    implements IItemColor {
        public int func_186726_a(ItemStack stack, int tintIndex) {
            if (stack.func_77942_o() && stack.func_77973_b() instanceof ItemStaff) {
                if (stack.func_82833_r().compareToIgnoreCase("Shiny Rod") == 0 || stack.func_82833_r().compareToIgnoreCase("Cutie Moon Rod") == 0) {
                    SpellBase spell = SpellRegistry.spellRegistry.get(stack.func_77978_p().func_74779_i("spell" + stack.func_77978_p().func_74762_e("selected")));
                    if (spell != null) {
                        if (tintIndex == 0) {
                            int r = (int)(255.0f * spell.red1);
                            int g = (int)(255.0f * spell.green1);
                            int b = (int)(255.0f * spell.blue1);
                            return (r << 16) + (g << 8) + b;
                        }
                        if (tintIndex == 1) {
                            int r = (int)(255.0f * spell.red2);
                            int g = (int)(255.0f * spell.green2);
                            int b = (int)(255.0f * spell.blue2);
                            return (r << 16) + (g << 8) + b;
                        }
                    }
                    return Misc.intColor(255, 255, 255);
                }
                SpellBase spell = SpellRegistry.spellRegistry.get(stack.func_77978_p().func_74779_i("spell" + stack.func_77978_p().func_74762_e("selected")));
                if (tintIndex == 1) {
                    int r = (int)(255.0f * spell.red1);
                    int g = (int)(255.0f * spell.green1);
                    int b = (int)(255.0f * spell.blue1);
                    return (r << 16) + (g << 8) + b;
                }
                if (tintIndex == 2) {
                    int r = (int)(255.0f * spell.red2);
                    int g = (int)(255.0f * spell.green2);
                    int b = (int)(255.0f * spell.blue2);
                    return (r << 16) + (g << 8) + b;
                }
                return Misc.intColor(255, 255, 255);
            }
            return Misc.intColor(255, 255, 255);
        }
    }
}

