/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import pl.asie.computronics.util.ParticleUtils;

public class NoteUtils {
    private static final String[] instruments = new String[]{"harp", "basedrum", "snare", "hat", "bass", "flute", "bell", "guitar", "chime", "xylophone", "pling"};

    public static void playNoteRaw(World world, BlockPos pos, String instrument, int note, float volume) {
        float f = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
        int xCoord = pos.func_177958_n();
        int yCoord = pos.func_177956_o();
        int zCoord = pos.func_177952_p();
        SoundEvent ev = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(instrument));
        if (ev != null) {
            world.func_184148_a(null, (double)xCoord + 0.5, (double)yCoord + 0.5, (double)zCoord + 0.5, ev, SoundCategory.RECORDS, volume, f);
        }
        ParticleUtils.sendParticlePacket(EnumParticleTypes.NOTE, world, (double)xCoord + 0.5, (double)yCoord + 1.2, (double)zCoord + 0.5, (double)note / 24.0, 1.0, 0.0);
    }

    public static NoteTask playNote(World world, BlockPos pos, String instrument, int note, float volume) {
        return new NoteTask(NoteUtils.checkInstrument(instrument), NoteUtils.checkNote(note), volume);
    }

    public static NoteTask playNote(World world, BlockPos pos, String instrument, int note) {
        return new NoteTask(NoteUtils.checkInstrument(instrument), NoteUtils.checkNote(note), 3.0f);
    }

    public static NoteTask playNote(World world, BlockPos pos, int instrument, int note) {
        return NoteUtils.playNote(world, pos, instrument, note, -1.0f);
    }

    public static NoteTask playNote(World world, BlockPos pos, int instrument, int note, float volume) {
        if (instrument < 0) {
            int b0 = 0;
            if (pos.func_177956_o() > 0) {
                IBlockState state = world.func_180495_p(pos.func_177977_b());
                Material m = state.func_185904_a();
                if (m == Material.field_151576_e) {
                    b0 = 1;
                }
                if (m == Material.field_151595_p) {
                    b0 = 2;
                }
                if (m == Material.field_151592_s) {
                    b0 = 3;
                }
                if (m == Material.field_151575_d) {
                    b0 = 4;
                }
            }
            instrument = b0;
        }
        return new NoteTask(instrument %= 7, NoteUtils.checkNote(note), volume < 0.0f ? 3.0f : volume);
    }

    public static float toVolume(int index, double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("bad argument #" + index + " (number between 0 and 1 expected, got " + value + ")");
        }
        return Math.min(Math.max((float)value * 3.0f, 0.0f), 3.0f);
    }

    public static float toVolume(Object[] arguments, int index) {
        double value = 1.0;
        if (arguments.length > index && arguments[index] instanceof Double) {
            value = (Double)arguments[index];
        }
        return NoteUtils.toVolume(index + 1, value);
    }

    public static String checkInstrument(String instrument) {
        for (String s : instruments) {
            if (!s.equals(instrument)) continue;
            return "block.note." + instrument;
        }
        throw new IllegalArgumentException("invalid instrument: " + instrument);
    }

    public static int checkNote(int note) {
        if (note >= 0) {
            return note;
        }
        throw new IllegalArgumentException("invalid note: " + note);
    }

    public static class NoteTask {
        protected String instrument;
        protected int instrumentID = -1;
        protected int note;
        protected final float volume;

        public NoteTask(@Nullable String instrument, int note, float volume) {
            this.instrument = instrument;
            this.note = note;
            this.volume = volume;
        }

        public NoteTask(int instrumentID, int note, float volume) {
            this.instrumentID = instrumentID;
            this.note = note;
            this.volume = volume;
        }

        public void play(World world, BlockPos pos) {
            if (this.instrument == null && this.instrumentID >= 0) {
                if (this.instrumentID <= 4) {
                    NoteBlockEvent.Play e = new NoteBlockEvent.Play(world, pos, world.func_180495_p(pos), this.note, this.instrumentID);
                    if (MinecraftForge.EVENT_BUS.post((Event)e)) {
                        return;
                    }
                    this.instrumentID = e.getInstrument().ordinal();
                    this.note = e.getVanillaNoteId();
                }
                this.instrument = instruments[0];
                if (this.instrumentID > 0 && this.instrumentID < instruments.length) {
                    this.instrument = instruments[this.instrumentID];
                }
                this.instrument = "block.note." + this.instrument;
            }
            if (this.instrument != null) {
                NoteUtils.playNoteRaw(world, pos, this.instrument, this.note, this.volume);
            }
        }
    }
}

