/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tile;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Connector;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Optional;
import pl.asie.computronics.cc.CCRadarProxy;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.tile.TileEntityPeripheralBase;
import pl.asie.computronics.util.OCUtils;
import pl.asie.computronics.util.RadarUtils;
import pl.asie.computronics.util.TableUtils;

public class TileRadar
extends TileEntityPeripheralBase {
    public TileRadar() {
        super("radar", 0.0);
    }

    private int getDistance(Arguments args) {
        if (args.isInteger(0)) {
            return args.checkInteger(0);
        }
        return Config.RADAR_RANGE;
    }

    private AxisAlignedBB getBounds(int d) {
        int distance = Math.min(d, Config.RADAR_RANGE);
        if (distance < 1) {
            distance = 1;
        }
        BlockPos pos = this.func_174877_v();
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)).func_72321_a((double)distance, (double)distance, (double)distance);
    }

    @Override
    @Optional.Method(modid="opencomputers")
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("multimedia", "Radar", "Trumbour Technology", "Detectotron M1", new String[0]);
    }

    @Callback(doc="function([distance:number]):table; Returns a list of all entities detected within the specified or the maximum range")
    @Optional.Method(modid="opencomputers")
    public Object[] getEntities(Context context, Arguments args) {
        HashSet<Map<String, Object>> entities = new HashSet<Map<String, Object>>();
        int distance = this.getDistance(args);
        double energyNeeded = Config.RADAR_ENERGY_COST_OC * (double)distance * 1.75;
        if (((Connector)this.node()).tryChangeBuffer(0.0 - energyNeeded)) {
            AxisAlignedBB bounds = this.getBounds(distance);
            entities.addAll(RadarUtils.getEntities(this.field_145850_b, this.func_174877_v(), bounds, EntityPlayer.class));
            entities.addAll(RadarUtils.getEntities(this.field_145850_b, this.func_174877_v(), bounds, EntityLiving.class));
            context.pause(0.5);
        }
        return new Object[]{TableUtils.convertSetToMap(entities)};
    }

    @Callback(doc="function([distance:number]):table; Returns a list of all players detected within the specified or the maximum range")
    @Optional.Method(modid="opencomputers")
    public Object[] getPlayers(Context context, Arguments args) {
        HashSet<Map<String, Object>> entities = new HashSet<Map<String, Object>>();
        int distance = this.getDistance(args);
        double energyNeeded = Config.RADAR_ENERGY_COST_OC * (double)distance * 1.0;
        if (((Connector)this.node()).tryChangeBuffer(0.0 - energyNeeded)) {
            AxisAlignedBB bounds = this.getBounds(distance);
            entities.addAll(RadarUtils.getEntities(this.field_145850_b, this.func_174877_v(), bounds, EntityPlayer.class));
            context.pause(0.5);
        }
        return new Object[]{TableUtils.convertSetToMap(entities)};
    }

    @Callback(doc="function([distance:number]):table; Returns a list of all mobs detected within the specified or the maximum range")
    @Optional.Method(modid="opencomputers")
    public Object[] getMobs(Context context, Arguments args) {
        HashSet<Map<String, Object>> entities = new HashSet<Map<String, Object>>();
        int distance = this.getDistance(args);
        double energyNeeded = Config.RADAR_ENERGY_COST_OC * (double)distance * 1.0;
        if (((Connector)this.node()).tryChangeBuffer(0.0 - energyNeeded)) {
            AxisAlignedBB bounds = this.getBounds(distance);
            entities.addAll(RadarUtils.getEntities(this.field_145850_b, this.func_174877_v(), bounds, EntityLiving.class));
            context.pause(0.5);
        }
        return new Object[]{TableUtils.convertSetToMap(entities)};
    }

    @Callback(doc="function([distance:number]):table; Returns a list of all items detected within the specified or the maximum range")
    @Optional.Method(modid="opencomputers")
    public Object[] getItems(Context context, Arguments args) {
        HashSet<Map<String, Object>> entities = new HashSet<Map<String, Object>>();
        int distance = this.getDistance(args);
        double energyNeeded = Config.RADAR_ENERGY_COST_OC * (double)distance * 2.0;
        if (((Connector)this.node()).tryChangeBuffer(0.0 - energyNeeded)) {
            AxisAlignedBB bounds = this.getBounds(distance);
            entities.addAll(RadarUtils.getItems(this.field_145850_b, this.func_174877_v(), bounds, EntityItem.class));
            context.pause(0.5);
        }
        return new Object[]{TableUtils.convertSetToMap(entities)};
    }

    @Optional.Method(modid="computercraft")
    public String[] getMethodNames() {
        return CCRadarProxy.getMethodNames();
    }

    @Nullable
    @Optional.Method(modid="computercraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        return CCRadarProxy.callMethod(this.field_145850_b, this.func_174877_v(), computer, context, method, arguments, this);
    }
}

