/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc;

import java.util.concurrent.Callable;
import li.cil.oc.api.Driver;
import li.cil.oc.api.IMC;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.DriverBlock;
import li.cil.oc.api.driver.DriverItem;
import li.cil.oc.api.driver.EnvironmentProvider;
import li.cil.oc.api.fs.FileSystem;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Optional;
import org.apache.logging.log4j.Logger;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.integration.flamingo.DriverFlamingo;
import pl.asie.computronics.integration.forestry.IntegrationForestry;
import pl.asie.computronics.integration.storagedrawers.DriverDrawerGroup;
import pl.asie.computronics.item.ItemOCSpecialParts;
import pl.asie.computronics.item.ItemOpenComputers;
import pl.asie.computronics.oc.ColorfulUpgradeHandler;
import pl.asie.computronics.oc.block.ComputronicsBlockEnvironmentProvider;
import pl.asie.computronics.oc.client.RackMountableRenderer;
import pl.asie.computronics.oc.client.UpgradeRenderer;
import pl.asie.computronics.oc.driver.DriverBoardBoom;
import pl.asie.computronics.oc.driver.DriverMagicalMemory;
import pl.asie.computronics.oc.manual.ComputronicsPathProvider;
import pl.asie.computronics.reference.Compat;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.util.RecipeUtils;
import pl.asie.computronics.util.sound.SoundBoard;

public class IntegrationOpenComputers {
    private final Compat compat;
    private final Computronics computronics;
    private final Logger log;
    public static ItemOpenComputers itemOCParts;
    public static ItemOCSpecialParts itemOCSpecialParts;
    public static UpgradeRenderer upgradeRenderer;
    public static RackMountableRenderer mountableRenderer;
    public static ColorfulUpgradeHandler colorfulUpgradeHandler;
    public static DriverBoardBoom.BoomHandler boomBoardHandler;

    public IntegrationOpenComputers(Computronics computronics) {
        this.computronics = computronics;
        this.compat = computronics.compat;
        this.log = Computronics.log;
    }

    @Optional.Method(modid="opencomputers")
    public void preInit() {
        if (Config.OC_UPGRADE_CAMERA || Config.OC_UPGRADE_CHATBOX || Config.OC_UPGRADE_RADAR || Config.OC_CARD_FX || Config.OC_CARD_SPOOF || Config.OC_CARD_BEEP || Config.OC_CARD_BOOM || Config.OC_UPGRADE_COLORFUL || Config.OC_CARD_NOISE || Config.OC_CARD_SOUND || Config.OC_BOARD_LIGHT || Config.OC_BOARD_BOOM || Config.OC_BOARD_CAPACITOR || Config.OC_BOARD_SWITCH || Config.OC_UPGRADE_SPEECH) {
            itemOCParts = new ItemOpenComputers();
            Computronics.instance.registerItem(itemOCParts, "oc_parts");
            itemOCParts.registerItemModels();
            Driver.add((DriverItem)itemOCParts);
            Driver.add((EnvironmentProvider)itemOCParts);
        }
        if (Config.OC_MAGICAL_MEMORY) {
            itemOCSpecialParts = new ItemOCSpecialParts();
            Computronics.instance.registerItem(itemOCSpecialParts, "oc_special_parts");
            itemOCSpecialParts.registerItemModels();
            Driver.add((EnvironmentProvider)itemOCSpecialParts);
            if (Config.OC_MAGICAL_MEMORY) {
                Driver.add((DriverItem)new DriverMagicalMemory());
            }
        }
        if (Mods.isLoaded("forestry") && Config.FORESTRY_BEES) {
            Computronics.forestry = new IntegrationForestry();
            Computronics.forestry.preInitOC();
        }
    }

    @Optional.Method(modid="opencomputers")
    public void init() {
        Driver.add((EnvironmentProvider)new ComputronicsBlockEnvironmentProvider());
        ComputronicsPathProvider.initialize();
        if (Computronics.tapeReader != null) {
            li.cil.oc.api.Items.registerFloppy((String)"tape", (EnumDyeColor)EnumDyeColor.WHITE, (Callable)new ReadOnlyFS("tape"), (boolean)true);
            IMC.registerProgramDiskLabel((String)"tape", (String)"tape", (String[])new String[]{"Lua 5.2", "Lua 5.3", "LuaJ"});
        }
        if (Config.OC_CARD_BOOM || Config.OC_BOARD_BOOM) {
            li.cil.oc.api.Items.registerFloppy((String)"explode", (EnumDyeColor)EnumDyeColor.RED, (Callable)new ReadOnlyFS("explode"), (boolean)true);
            IMC.registerProgramDiskLabel((String)"explode", (String)"explode", (String[])new String[]{"Lua 5.2", "Lua 5.3", "LuaJ"});
        }
        if (colorfulUpgradeHandler == null && Config.OC_UPGRADE_COLORFUL) {
            colorfulUpgradeHandler = new ColorfulUpgradeHandler();
            MinecraftForge.EVENT_BUS.register((Object)colorfulUpgradeHandler);
        }
        if (boomBoardHandler == null && Config.OC_BOARD_BOOM) {
            boomBoardHandler = new DriverBoardBoom.BoomHandler();
            MinecraftForge.EVENT_BUS.register((Object)boomBoardHandler);
        }
        if (Mods.isLoaded("storagedrawers") && this.compat.isCompatEnabled("enableStorageDrawersDriver")) {
            Driver.add((DriverBlock)new DriverDrawerGroup.OCDriver());
        }
        if (Mods.isLoaded("flamingo") && this.compat.isCompatEnabled("enableFlamingoDriver")) {
            Driver.add((DriverBlock)new DriverFlamingo.OCDriver());
        }
        if (Computronics.forestry != null) {
            Computronics.forestry.initOC();
        }
        if (Config.OC_CARD_SOUND && Computronics.proxy.isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)new SoundBoard.SyncHandler());
        }
    }

    @Optional.Method(modid="opencomputers")
    public void postInit() {
        if (Config.OC_UPGRADE_CAMERA) {
            if (Computronics.camera != null) {
                RecipeUtils.addShapedRecipe(new ItemStack((Item)itemOCParts, 1, 0), "idi", "mcm", "ibi", Character.valueOf('c'), Computronics.camera, Character.valueOf('d'), "oc:materialTransistor", Character.valueOf('m'), "oc:circuitChip2", Character.valueOf('i'), "ingotIron", Character.valueOf('b'), "oc:materialCircuitBoardPrinted");
            } else {
                this.log.warn("Could not add Camera Upgrade Recipe because Camera is disabled in the config.");
            }
        }
        if (Config.OC_UPGRADE_CHATBOX) {
            if (Computronics.chatBox != null) {
                RecipeUtils.addShapedRecipe(new ItemStack((Item)itemOCParts, 1, 1), "idi", "mcm", "ibi", Character.valueOf('c'), new ItemStack((Block)Computronics.chatBox, 1, 0), Character.valueOf('d'), "oc:materialTransistor", Character.valueOf('m'), "oc:circuitChip2", Character.valueOf('i'), "ingotIron", Character.valueOf('b'), "oc:materialCircuitBoardPrinted");
            } else {
                this.log.warn("Could not add Chat Box Upgrade Recipe because Chat Box is disabled in the config.");
            }
        }
        if (Config.OC_UPGRADE_RADAR) {
            if (Computronics.radar != null) {
                RecipeUtils.addShapedRecipe(new ItemStack((Item)itemOCParts, 1, 2), "idi", "mcm", "ibi", Character.valueOf('c'), Computronics.radar, Character.valueOf('d'), "oc:materialInterweb", Character.valueOf('m'), "oc:circuitChip3", Character.valueOf('i'), "ingotGold", Character.valueOf('b'), "oc:materialCircuitBoardPrinted");
            } else {
                this.log.warn("Could not add Radar Upgrade Recipe because Radar is disabled in the config.");
            }
        }
        if (Config.OC_CARD_FX) {
            RecipeUtils.addShapedRecipe(new ItemStack((Item)itemOCParts, 1, 3), "mf", " b", Character.valueOf('m'), "oc:circuitChip2", Character.valueOf('f'), Items.field_151059_bz, Character.valueOf('b'), "oc:materialCard");
        }
        if (Config.OC_CARD_SPOOF) {
            RecipeUtils.addShapedRecipe(new ItemStack((Item)itemOCParts, 1, 4), "mfl", "pb ", "   ", Character.valueOf('m'), "oc:ram2", Character.valueOf('f'), "oc:circuitChip2", Character.valueOf('b'), "oc:lanCard", Character.valueOf('p'), "oc:materialCircuitBoardPrinted", Character.valueOf('l'), Items.field_151118_aC);
        }
        if (Config.OC_CARD_BEEP) {
            RecipeUtils.addShapedRecipe(new ItemStack((Item)itemOCParts, 1, 5), " l ", "mb ", " f ", Character.valueOf('m'), "oc:circuitChip1", Character.valueOf('f'), Computronics.speaker != null ? Computronics.speaker : (Computronics.ironNote != null ? Computronics.ironNote : Blocks.field_150323_B), Character.valueOf('b'), "oc:materialCard", Character.valueOf('l'), "oc:materialCU");
        }
        if (Config.OC_CARD_BOOM) {
            RecipeUtils.addShapedRecipe(new ItemStack((Item)itemOCParts, 1, 6), "mf", "fb", Character.valueOf('m'), "oc:materialCU", Character.valueOf('f'), Blocks.field_150335_W, Character.valueOf('b'), "oc:redstoneCard1");
        }
        if (Config.OC_UPGRADE_COLORFUL) {
            RecipeUtils.addShapedRecipe(new ItemStack((Item)itemOCParts, 1, 7), "fdf", "mcm", "fbf", Character.valueOf('c'), Computronics.colorfulLamp != null ? Computronics.colorfulLamp : "glowstone", Character.valueOf('d'), "oc:materialTransistor", Character.valueOf('m'), "oc:circuitChip2", Character.valueOf('f'), "oc:chamelium", Character.valueOf('b'), "oc:materialCircuitBoardPrinted");
        }
        if (Config.OC_CARD_NOISE) {
            RecipeUtils.addShapedRecipe(new ItemStack((Item)itemOCParts, 1, 8), " l ", "mbn", " f ", Character.valueOf('m'), "oc:ram1", Character.valueOf('f'), "oc:materialALU", Character.valueOf('b'), Config.OC_CARD_BEEP ? new ItemStack((Item)itemOCParts, 1, 5) : (Computronics.speaker != null ? Computronics.speaker : (Computronics.ironNote != null ? Computronics.ironNote : Blocks.field_150323_B)), Character.valueOf('l'), "oc:circuitChip2", Character.valueOf('n'), "gemQuartz");
        }
        if (Config.OC_CARD_SOUND) {
            RecipeUtils.addShapedRecipe(new ItemStack((Item)itemOCParts, 1, 9), " l ", "mb ", " f ", Character.valueOf('m'), "oc:ram5", Character.valueOf('f'), "oc:cpu1", Character.valueOf('b'), Config.OC_CARD_NOISE ? new ItemStack((Item)itemOCParts, 1, 8) : (Config.OC_CARD_BEEP ? new ItemStack((Item)itemOCParts, 1, 5) : (Computronics.speaker != null ? Computronics.speaker : (Computronics.ironNote != null ? Computronics.ironNote : Blocks.field_150323_B))), Character.valueOf('l'), "oc:circuitChip2");
        }
        if (Config.OC_BOARD_LIGHT) {
            RecipeUtils.addShapedRecipe(new ItemStack((Item)itemOCParts, 1, 10), "oso", "gcg", "opo", Character.valueOf('s'), "paneGlassColorless", Character.valueOf('g'), "oc:circuitChip1", Character.valueOf('c'), Computronics.colorfulLamp != null ? Computronics.colorfulLamp : "glowstone", Character.valueOf('o'), "obsidian", Character.valueOf('p'), "oc:materialCircuitBoardPrinted");
        }
        if (Config.OC_BOARD_BOOM) {
            RecipeUtils.addShapedRecipe(new ItemStack((Item)itemOCParts, 1, 11), "lsl", "gcg", "opo", Character.valueOf('s'), "oc:circuitChip1", Character.valueOf('g'), Config.OC_CARD_BOOM ? new ItemStack((Item)itemOCParts, 1, 6) : Items.field_151065_br, Character.valueOf('c'), Blocks.field_150335_W, Character.valueOf('o'), "obsidian", Character.valueOf('l'), "gunpowder", Character.valueOf('p'), "oc:materialCircuitBoardPrinted");
        }
        if (Config.OC_BOARD_CAPACITOR) {
            RecipeUtils.addShapedRecipe(new ItemStack((Item)itemOCParts, 1, 12), "lsl", "gcg", "opo", Character.valueOf('s'), "oc:circuitChip1", Character.valueOf('g'), "nuggetGold", Character.valueOf('c'), "oc:capacitor", Character.valueOf('o'), "obsidian", Character.valueOf('l'), "ingotIron", Character.valueOf('p'), "oc:materialCircuitBoardPrinted");
        }
        if (Config.OC_BOARD_SWITCH) {
            RecipeUtils.addShapedRecipe(new ItemStack((Item)itemOCParts, 1, 13), "oso", "gcg", "opo", Character.valueOf('s'), "paneGlassColorless", Character.valueOf('g'), "oc:circuitChip1", Character.valueOf('c'), "oc:materialButtonGroup", Character.valueOf('o'), "obsidian", Character.valueOf('p'), "oc:materialCircuitBoardPrinted");
        }
        if (Config.OC_UPGRADE_SPEECH && Computronics.speechBox != null) {
            RecipeUtils.addShapedRecipe(new ItemStack((Item)itemOCParts, 1, 14), "idi", "mcm", "ibi", Character.valueOf('c'), Computronics.speechBox, Character.valueOf('d'), "oc:materialTransistor", Character.valueOf('m'), "oc:circuitChip2", Character.valueOf('i'), "ingotIron", Character.valueOf('b'), "oc:materialCircuitBoardPrinted");
        }
    }

    @Optional.Method(modid="opencomputers")
    public void scheduleForNetworkJoin(final TileEntity tile) {
        if (!tile.func_145837_r() && !tile.func_145831_w().field_72995_K) {
            Computronics.serverTickHandler.schedule(new Runnable(){

                @Override
                public void run() {
                    Network.joinOrCreateNetwork((TileEntity)tile);
                }
            });
        }
    }

    private static class ReadOnlyFS
    implements Callable<FileSystem> {
        private final String name;

        ReadOnlyFS(String name) {
            this.name = name;
        }

        @Override
        @Optional.Method(modid="opencomputers")
        public FileSystem call() throws Exception {
            return li.cil.oc.api.FileSystem.asReadOnly((FileSystem)li.cil.oc.api.FileSystem.fromClass(Computronics.class, (String)"computronics", (String)("loot/" + this.name)));
        }
    }
}

