/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.block;

import li.cil.oc.api.network.Environment;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import pl.asie.computronics.block.BlockPeripheral;
import pl.asie.computronics.tile.TileColorfulLamp;
import pl.asie.computronics.util.LampUtil;
import pl.asie.lib.block.BlockBase;

public class BlockColorfulLamp
extends BlockPeripheral {
    public static final PropertyInteger BRIGHTNESS = PropertyInteger.func_177719_a((String)"brightness", (int)0, (int)15);

    public BlockColorfulLamp() {
        super("colorful_lamp", BlockBase.Rotation.NONE);
        this.func_149663_c("computronics.colorfulLamp");
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileColorfulLamp();
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    protected BlockStateContainer createActualBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{BUNDLED, BRIGHTNESS});
    }

    @Override
    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a((IProperty)BRIGHTNESS, (Comparable)Integer.valueOf(meta));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return super.func_176201_c(state) | (Integer)state.func_177229_b((IProperty)BRIGHTNESS);
    }

    @Override
    protected IBlockState createDefaultState() {
        return super.createDefaultState().func_177226_a((IProperty)BRIGHTNESS, (Comparable)Integer.valueOf(0));
    }

    @Override
    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos otherPos) {
        super.func_189540_a(state, world, pos, block, otherPos);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        this.field_149784_t = (Integer)state.func_177229_b((IProperty)BRIGHTNESS);
        return this.field_149784_t;
    }

    @Deprecated
    public int func_149717_k(IBlockState state) {
        return super.func_149717_k(state);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileColorfulLamp) {
            return state.func_177226_a((IProperty)BRIGHTNESS, (Comparable)Integer.valueOf(LampUtil.toBrightness(((TileColorfulLamp)tile).getLampColor())));
        }
        return state;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT_MIPPED || super.canRenderInLayer(state, layer);
    }

    @Override
    public int colorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos, int pass) {
        if (pass != 0) {
            return super.colorMultiplier(state, world, pos, pass);
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileColorfulLamp) {
            int color = ((TileColorfulLamp)tile).getLampColor();
            return (color & 0x7C00) << 9 | (color & 0x3E0) << 6 | (color & 0x1F) << 3;
        }
        return super.colorMultiplier(state, world, pos, pass);
    }

    @Override
    public boolean supportsBundledRedstone() {
        return true;
    }

    @Override
    @Optional.Method(modid="opencomputers")
    public Class<? extends Environment> getTileEntityClass(int meta) {
        return TileColorfulLamp.class;
    }
}

