/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.block;

import java.util.List;
import javax.annotation.Nullable;
import li.cil.oc.api.network.Environment;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.block.BlockPeripheral;
import pl.asie.computronics.item.block.IBlockWithDifferentColors;
import pl.asie.computronics.item.block.IBlockWithSpecialText;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.tile.TileChatBox;
import pl.asie.computronics.util.StringUtil;
import pl.asie.lib.block.BlockBase;
import pl.asie.lib.tile.TileEntityBase;

public class BlockChatBox
extends BlockPeripheral
implements IBlockWithSpecialText,
IBlockWithDifferentColors {
    public static final PropertyBool CREATIVE = PropertyBool.func_177716_a((String)"creative");

    public BlockChatBox() {
        super("chatbox", BlockBase.Rotation.NONE);
        this.func_149647_a(Computronics.tab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)CREATIVE, (Comparable)Boolean.valueOf(false)));
        this.func_149663_c("computronics.chatBox");
    }

    @Override
    public int getRenderColor(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)CREATIVE) != false ? 0xFF60FF : 0xFFFFFF;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos, int renderPass) {
        return (Boolean)state.func_177229_b((IProperty)CREATIVE) != false ? this.getRenderColor(state) : super.colorMultiplier(state, world, pos, renderPass);
    }

    @Override
    public int getColorFromItemstack(ItemStack stack, int pass) {
        return (stack.func_77952_i() & 8) != 0 ? 0xFF60FF : 0xFFFFFF;
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileChatBox();
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> blockList) {
        blockList.add((Object)new ItemStack((Block)this, 1, 0));
        if (Config.CHATBOX_CREATIVE) {
            blockList.add((Object)new ItemStack((Block)this, 1, 8));
        }
    }

    @Override
    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a((IProperty)CREATIVE, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return super.func_176201_c(state) | ((Boolean)state.func_177229_b((IProperty)CREATIVE) != false ? 8 : 0);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    protected BlockStateContainer createActualBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{CREATIVE});
    }

    @Override
    protected IBlockState createDefaultState() {
        return super.createDefaultState().func_177226_a((IProperty)CREATIVE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public boolean emitsRedstone(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return Config.REDSTONE_REFRESH;
    }

    @Deprecated
    public boolean func_149740_M(IBlockState state) {
        return Config.REDSTONE_REFRESH;
    }

    @Deprecated
    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBase) {
            return ((TileEntityBase)tile).requestCurrentRedstoneValue(null);
        }
        return super.func_180641_l(state, world, pos);
    }

    @Override
    public boolean hasSubTypes() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (stack.func_77952_i() >= 8) {
            list.add(TextFormatting.GRAY + StringUtil.localize("tooltip.computronics.chatBox.creative"));
        }
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        return stack.func_77952_i() >= 8 ? "tile.computronics.chatBox.creative" : this.func_149739_a();
    }

    @Override
    @Optional.Method(modid="opencomputers")
    public Class<? extends Environment> getTileEntityClass(int meta) {
        return TileChatBox.class;
    }
}

