/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.api.audio;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.audio.AudioPacketRegistry;
import pl.asie.computronics.api.audio.IAudioReceiver;
import pl.asie.computronics.api.audio.IAudioSource;
import pl.asie.computronics.network.PacketType;
import pl.asie.lib.network.Packet;

public abstract class AudioPacket {
    private static int _idGen;
    public final IAudioSource source;
    public final int id;
    public final byte volume;
    private final Set<IAudioReceiver> receivers = new HashSet<IAudioReceiver>();

    private static int getNewId() {
        return _idGen++;
    }

    public AudioPacket(IAudioSource source, byte volume) {
        this.id = AudioPacket.getNewId();
        this.source = source;
        this.volume = volume;
    }

    public Collection<IAudioReceiver> getReceivers() {
        return Collections.unmodifiableSet(this.receivers);
    }

    public void addReceiver(IAudioReceiver receiver) {
        if (receiver.getSoundWorld() != null) {
            this.receivers.add(receiver);
        }
    }

    protected abstract void writeData(Packet var1) throws IOException;

    protected boolean canHearReceiver(EntityPlayerMP playerMP, IAudioReceiver receiver) {
        if (receiver.getSoundWorld() != null && receiver.getSoundWorld().field_73011_w.getDimension() != playerMP.field_70170_p.field_73011_w.getDimension()) {
            return false;
        }
        int mdSq = receiver.getSoundDistance() * receiver.getSoundDistance();
        BlockPos pos = receiver.getSoundPos();
        double distSq = ((double)pos.func_177958_n() - playerMP.field_70165_t) * ((double)pos.func_177958_n() - playerMP.field_70165_t);
        distSq += ((double)pos.func_177956_o() - playerMP.field_70163_u) * ((double)pos.func_177956_o() - playerMP.field_70163_u);
        return (distSq += ((double)pos.func_177952_p() - playerMP.field_70161_v) * ((double)pos.func_177952_p() - playerMP.field_70161_v)) <= (double)mdSq;
    }

    public final void sendPacket() {
        try {
            for (EntityPlayerMP playerMP : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                if (playerMP == null || playerMP.field_70170_p == null) continue;
                HashSet<IAudioReceiver> receiversLocal = new HashSet<IAudioReceiver>();
                for (IAudioReceiver receiver : this.receivers) {
                    if (!this.canHearReceiver(playerMP, receiver)) continue;
                    receiversLocal.add(receiver);
                }
                if (receiversLocal.size() <= 0) continue;
                Packet pkt = Computronics.packet.create(PacketType.AUDIO_DATA.ordinal()).writeShort((short)AudioPacketRegistry.INSTANCE.getId(this.getClass())).writeInt(this.id).writeInt(this.source.getSourceId());
                this.writeData(pkt);
                pkt.writeShort((short)this.receivers.size());
                for (IAudioReceiver receiver : this.receivers) {
                    pkt.writeInt(receiver.getSoundWorld() != null ? receiver.getSoundWorld().field_73011_w.getDimension() : 0);
                    BlockPos pos = receiver.getSoundPos();
                    pkt.writeInt(pos.func_177958_n()).writeInt(pos.func_177956_o()).writeInt(pos.func_177952_p()).writeShort((short)receiver.getSoundDistance()).writeByte(this.volume).writeByte((byte)(receiver.canMove() ? 1 : 0));
                }
                Computronics.packet.sendTo(pkt, playerMP);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

