/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.saving.serializers.builtin.basics;

import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.saving.serializers.builtin.basics.GenericNBTSerializer;
import com.teamwizardry.librarianlib.features.saving.serializers.builtin.basics.NbtKt;
import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J'\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0015\u00a2\u0006\u0002\u0010\u0011J%\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a2\u0006\u0002\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/teamwizardry/librarianlib/features/saving/serializers/builtin/basics/NBTSerializer;", "T", "Lnet/minecraft/nbt/NBTBase;", "Lcom/teamwizardry/librarianlib/features/saving/serializers/builtin/basics/GenericNBTSerializer;", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "id", "", "getId", "()B", "readBytes", "buf", "Lio/netty/buffer/ByteBuf;", "existing", "syncing", "", "(Lio/netty/buffer/ByteBuf;Lnet/minecraft/nbt/NBTBase;Z)Lnet/minecraft/nbt/NBTBase;", "writeBytes", "", "value", "(Lio/netty/buffer/ByteBuf;Lnet/minecraft/nbt/NBTBase;Z)V", "librarianlib-1.12.2"})
public class NBTSerializer<T extends NBTBase>
extends GenericNBTSerializer<T> {
    private final byte id;

    public final byte getId() {
        return this.id;
    }

    @Override
    @NotNull
    protected T readBytes(@NotNull ByteBuf buf, @Nullable T existing, boolean syncing) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        NBTBase nBTBase = NbtKt.readTagFromBuffer(this.id, buf);
        if (nBTBase == null) {
            throw new TypeCastException("null cannot be cast to non-null type T");
        }
        return (T)nBTBase;
    }

    @Override
    protected void writeBytes(@NotNull ByteBuf buf, @NotNull T value, boolean syncing) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        NbtKt.writeTagToBuffer(value, buf);
    }

    public NBTSerializer(@NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        super(clazz);
        this.id = (byte)CommonUtilMethods.idForClazz(clazz);
    }
}

