/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.autoregister;

import com.google.common.collect.Multimap;
import com.teamwizardry.librarianlib.core.LibrarianLog;
import com.teamwizardry.librarianlib.features.autoregister.AMPRegister;
import com.teamwizardry.librarianlib.features.autoregister.AnnotationMarkerProcessor;
import com.teamwizardry.librarianlib.features.autoregister.AnnotationMarkersHandler;
import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.kotlin.DefaultedMutableMap;
import com.teamwizardry.librarianlib.features.utilities.LoggerBase;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u000f\u001a\u00020\u0010\"\b\b\u0000\u0010\u0011*\u00020\u0012\"\b\b\u0001\u0010\u0013*\u00020\u00012\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00130\f2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019R1\u0010\u0003\u001a\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001f\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/teamwizardry/librarianlib/features/autoregister/AnnotationMarkersHandler;", "", "()V", "errors", "Lcom/teamwizardry/librarianlib/features/kotlin/DefaultedMutableMap;", "Ljava/lang/Class;", "Lcom/google/common/collect/Multimap;", "", "getErrors", "()Lcom/teamwizardry/librarianlib/features/kotlin/DefaultedMutableMap;", "processors", "", "Lcom/teamwizardry/librarianlib/features/autoregister/AnnotationMarkerProcessor;", "getProcessors", "()Ljava/util/List;", "handle", "", "A", "", "T", "processor", "asmDataTable", "Lnet/minecraftforge/fml/common/discovery/ASMDataTable;", "preInit", "e", "Lnet/minecraftforge/fml/common/event/FMLPreInitializationEvent;", "GetProcessors", "librarianlib-1.12.2"})
public final class AnnotationMarkersHandler {
    @NotNull
    private static final List<AnnotationMarkerProcessor<?, ?>> processors;
    @NotNull
    private static final DefaultedMutableMap<Class<?>, Multimap<String, Class<?>>> errors;
    public static final AnnotationMarkersHandler INSTANCE;

    @NotNull
    public final List<AnnotationMarkerProcessor<?, ?>> getProcessors() {
        return processors;
    }

    @NotNull
    public final DefaultedMutableMap<Class<?>, Multimap<String, Class<?>>> getErrors() {
        return errors;
    }

    public final void preInit(@NotNull FMLPreInitializationEvent e) {
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        ASMDataTable data = e.getAsmData();
        AnnotationMarkerProcessor annotationMarkerProcessor = GetProcessors.INSTANCE;
        ASMDataTable aSMDataTable = data;
        Intrinsics.checkExpressionValueIsNotNull((Object)aSMDataTable, (String)"data");
        this.handle(annotationMarkerProcessor, aSMDataTable);
        Object $receiver$iv = CollectionsKt.toMutableList((Collection)processors);
        Map.Entry entry = $receiver$iv.iterator();
        while (entry.hasNext()) {
            Object element$iv = entry.next();
            it = (AnnotationMarkerProcessor)element$iv;
            INSTANCE.handle((AnnotationMarkerProcessor)it, data);
        }
        $receiver$iv = errors;
        if (!$receiver$iv.isEmpty()) {
            List build = CollectionsKt.mutableListOf((Object[])new String[]{"AnnotationMarker Errors:"});
            it = errors;
            Iterator iterator2 = it.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map map;
                Map.Entry entry2 = entry = iterator2.next();
                Class annot = (Class)entry2.getKey();
                entry2 = entry;
                Multimap map2 = (Multimap)entry2.getValue();
                build.add("-+ Errors for @" + annot.getTypeName());
                Intrinsics.checkExpressionValueIsNotNull((Object)map2.asMap(), (String)"map.asMap()");
                Iterator iterator3 = map.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry entry3 = entry2 = iterator3.next();
                    String error = (String)entry3.getKey();
                    entry3 = entry2;
                    Collection affected = (Collection)entry3.getValue();
                    build.add(" |-+ Affected classes:");
                    Collection collection = affected;
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"affected");
                    Iterable $receiver$iv2 = collection;
                    for (Object element$iv : $receiver$iv2) {
                        Class it2 = (Class)element$iv;
                        StringBuilder stringBuilder = new StringBuilder().append(" | |-+ ");
                        Class clazz = it2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"it");
                        build.add(stringBuilder.append(clazz.getCanonicalName()).toString());
                    }
                    build.add(" |-+ Stacktrace:");
                    build.add(" | | ============================================================\n" + error + " | | ============================================================");
                }
            }
            LoggerBase.bigDie$default(LibrarianLog.INSTANCE, "FATAL: AnnotationMarkers failed!!", build, false, 4, null);
        }
    }

    public final <A extends Annotation, T> void handle(@NotNull AnnotationMarkerProcessor<A, T> processor, @NotNull ASMDataTable asmDataTable) {
        Set asmDatas;
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)asmDataTable, (String)"asmDataTable");
        Class<A> annotationClass = processor.getAnnotationClass();
        String annotationClassName = annotationClass.getCanonicalName();
        Set set = asmDatas = asmDataTable.getAll(annotationClassName);
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"asmDatas");
        Iterable $receiver$iv = set;
        for (ASMDataTable.ASMData asmData : CollectionsKt.sortedWith((Iterable)$receiver$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                ASMDataTable.ASMData it;
                ASMDataTable.ASMData aSMData = it = (ASMDataTable.ASMData)a;
                Intrinsics.checkExpressionValueIsNotNull((Object)aSMData, (String)"it");
                it = (ASMDataTable.ASMData)b;
                Comparable comparable = (Comparable)((Object)aSMData.getClassName());
                ASMDataTable.ASMData aSMData2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)aSMData2, (String)"it");
                String string = aSMData2.getClassName();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
            }
        })) {
            Class<?> clazz;
            Class<?> $i$f$sortedBy;
            try {
                ASMDataTable.ASMData aSMData = asmData;
                Intrinsics.checkExpressionValueIsNotNull((Object)aSMData, (String)"asmData");
                $i$f$sortedBy = Class.forName(aSMData.getClassName());
            }
            catch (ClassNotFoundException e) {
                Exception exception = e;
                StringBuilder stringBuilder = new StringBuilder().append("Marked class ");
                ASMDataTable.ASMData aSMData = asmData;
                Intrinsics.checkExpressionValueIsNotNull((Object)aSMData, (String)"asmData");
                LibrarianLog.INSTANCE.error(exception, stringBuilder.append(aSMData.getClassName()).append(" not found!").toString(), new Object[0]);
                $i$f$sortedBy = null;
            }
            if ((clazz = $i$f$sortedBy) == null) continue;
            if (!processor.isClassValid(clazz)) {
                LibrarianLog.INSTANCE.error("Class " + clazz.getCanonicalName() + " annotated with " + annotationClass.getTypeName() + " is invalid", new Object[0]);
            }
            A annot = clazz.getAnnotation(annotationClass);
            try {
                A a = annot;
                Intrinsics.checkExpressionValueIsNotNull(a, (String)"annot");
                processor.process(clazz, a);
            }
            catch (Throwable e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                String str = sw.toString();
                errors.get(annotationClass).put((Object)str, clazz);
                e.printStackTrace();
            }
        }
    }

    private AnnotationMarkersHandler() {
    }

    static {
        AnnotationMarkersHandler annotationMarkersHandler;
        INSTANCE = annotationMarkersHandler = new AnnotationMarkersHandler();
        processors = new ArrayList();
        errors = CommonUtilMethods.withRealDefault(new LinkedHashMap(), errors.1.INSTANCE);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00010\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0014\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00010\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/teamwizardry/librarianlib/features/autoregister/AnnotationMarkersHandler$GetProcessors;", "Lcom/teamwizardry/librarianlib/features/autoregister/AnnotationMarkerProcessor;", "Lcom/teamwizardry/librarianlib/features/autoregister/AMPRegister;", "()V", "process", "", "clazz", "Ljava/lang/Class;", "annotation", "librarianlib-1.12.2"})
    public static final class GetProcessors
    extends AnnotationMarkerProcessor<AMPRegister, AnnotationMarkerProcessor<?, ?>> {
        public static final GetProcessors INSTANCE;

        @Override
        public void process(@NotNull Class<AnnotationMarkerProcessor<?, ?>> clazz, @NotNull AMPRegister annotation) {
            Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
            Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
            AnnotationMarkerProcessor<?, ?> annotationMarkerProcessor = CommonUtilMethods.getSingletonInstance(clazz);
            if (annotationMarkerProcessor == null) {
                throw (Throwable)new RuntimeException("No singleton instance!");
            }
            INSTANCE.getProcessors().add(annotationMarkerProcessor);
        }

        private GetProcessors() {
            super(AMPRegister.class, AnnotationMarkerProcessor.class);
        }

        static {
            GetProcessors getProcessors;
            INSTANCE = getProcessors = new GetProcessors();
        }
    }
}

