/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.config;

import com.google.gson.JsonObject;
import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.util.JEDJsonUtils;
import fi.dy.masa.justenoughdimensions.world.WorldProviderEndJED;
import fi.dy.masa.justenoughdimensions.world.WorldProviderHellJED;
import fi.dy.masa.justenoughdimensions.world.WorldProviderSurfaceJED;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldProviderSurface;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class DimensionTypeEntry
implements Comparable<DimensionTypeEntry> {
    private static final List<DimensionType> DIMENSION_TYPE_CACHE = new ArrayList<DimensionType>();
    private int dimensionTypeId;
    private String name;
    private String suffix;
    private boolean keepLoaded;
    private Class<? extends WorldProvider> providerClass;
    private String dimensionTypeName;
    private boolean forceRegister;
    private boolean allowDifferentId = true;
    private boolean requireExactMatch;
    private static final Field field_DimensionType_clazz = ReflectionHelper.findField(DimensionType.class, (String[])new String[]{"field_186077_g", "clazz"});

    public static void cache(DimensionType entry) {
        if (!DIMENSION_TYPE_CACHE.contains(entry)) {
            DIMENSION_TYPE_CACHE.add(entry);
        }
    }

    @Nullable
    public static Class<? extends WorldProvider> getProviderClassFrom(DimensionType type) {
        try {
            return (Class)field_DimensionType_clazz.get(type);
        }
        catch (Exception e) {
            return null;
        }
    }

    public DimensionTypeEntry(String existingDimensionTypeName) {
        this.dimensionTypeName = existingDimensionTypeName;
    }

    public DimensionTypeEntry(int dimTypeId, String name, String suffix, boolean keepLoaded, @Nonnull Class<? extends WorldProvider> providerClass) {
        this.dimensionTypeId = dimTypeId;
        this.name = name;
        this.suffix = suffix;
        this.keepLoaded = dimTypeId == 0 ? true : keepLoaded;
        this.providerClass = providerClass;
        this.dimensionTypeName = null;
    }

    public DimensionTypeEntry setForceRegister(boolean forceRegister) {
        this.forceRegister = forceRegister;
        return this;
    }

    public DimensionTypeEntry setAllowDifferentId(boolean allowDifferentId) {
        this.allowDifferentId = allowDifferentId;
        return this;
    }

    public DimensionTypeEntry setRequireExactMatch(boolean requireExactMatch) {
        this.requireExactMatch = requireExactMatch;
        return this;
    }

    public int getDimensionTypeId() {
        return this.dimensionTypeId;
    }

    public String getDimensionTypeName() {
        return this.name;
    }

    public String getDimensionTypeSuffix() {
        return this.suffix;
    }

    public boolean getDimensionTypeKeepLoaded() {
        return this.keepLoaded;
    }

    public Class<? extends WorldProvider> getProviderClass() {
        return this.providerClass;
    }

    public DimensionType getOrRegisterDimensionType(int dimension) {
        if (!this.forceRegister) {
            DimensionType entry = this.getExistingMatchingEntry(DIMENSION_TYPE_CACHE);
            if (entry == null) {
                entry = this.getExistingMatchingEntry(Arrays.asList(DimensionType.values()));
            }
            if (entry != null) {
                JustEnoughDimensions.logInfo("Using an existing DimensionType '{}', for dimension {}", entry, dimension);
                return entry;
            }
        }
        return this.registerDimensionType(dimension);
    }

    @Nullable
    private DimensionType getExistingMatchingEntry(List<DimensionType> list) {
        DimensionType entry = null;
        for (DimensionType tmp : list) {
            if (tmp.shouldLoadSpawn() != this.keepLoaded || DimensionTypeEntry.getProviderClassFrom(tmp) != this.providerClass) continue;
            if (this.requireExactMatch) {
                if (tmp.func_186068_a() != this.dimensionTypeId || !tmp.func_186067_c().equals(this.suffix) || !tmp.func_186065_b().equals(this.name)) continue;
                entry = tmp;
                break;
            }
            if (tmp.func_186068_a() != this.dimensionTypeId && !this.allowDifferentId) continue;
            entry = tmp;
            if (tmp.func_186068_a() != this.dimensionTypeId) continue;
            break;
        }
        return entry;
    }

    private DimensionType registerDimensionType(int dimension) {
        DimensionType entry = null;
        if (this.dimensionTypeName != null) {
            try {
                entry = DimensionType.func_193417_a((String)this.dimensionTypeName);
                JustEnoughDimensions.logInfo("Using a vanilla DimensionType (or some other existing one) '{}' for dimension {}", entry, dimension);
            }
            catch (IllegalArgumentException e) {
                entry = DimensionType.OVERWORLD;
                JustEnoughDimensions.logger.warn("Failed to get a DimensionType by the name '{}' for dimension {}, falling back to {}", (Object)this.dimensionTypeName, (Object)dimension, (Object)entry);
            }
        } else {
            JustEnoughDimensions.logInfo("Registering a new DimensionType with values '{}' for dimension {}", this.getDescription(), dimension);
            entry = DimensionType.register((String)this.name, (String)this.suffix, (int)this.dimensionTypeId, this.providerClass, (boolean)this.keepLoaded);
        }
        if (!this.forceRegister || !DIMENSION_TYPE_CACHE.contains(entry)) {
            DIMENSION_TYPE_CACHE.add(entry);
        }
        return entry;
    }

    public void writeToByteBuf(ByteBuf buf) {
        if (this.dimensionTypeName != null) {
            buf.writeByte(1);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.dimensionTypeName);
        } else {
            buf.writeByte(0);
            buf.writeInt(this.dimensionTypeId);
            buf.writeBoolean(this.forceRegister);
            buf.writeBoolean(this.allowDifferentId);
            buf.writeBoolean(this.requireExactMatch);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.suffix);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.providerClass.getName());
        }
    }

    public static DimensionTypeEntry fromByteBuf(ByteBuf buf) {
        byte type = buf.readByte();
        if (type == 1) {
            DimensionTypeEntry entry = new DimensionTypeEntry(ByteBufUtils.readUTF8String((ByteBuf)buf));
            return entry;
        }
        int dimTypeId = buf.readInt();
        boolean forceRegister = buf.readBoolean();
        boolean allowDifferentId = buf.readBoolean();
        boolean requireExactMatch = buf.readBoolean();
        String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        String suffix = ByteBufUtils.readUTF8String((ByteBuf)buf);
        String providerClassName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        try {
            Class<?> providerClass = Class.forName(providerClassName);
            DimensionTypeEntry entry = new DimensionTypeEntry(dimTypeId, name, suffix, false, providerClass);
            entry.setForceRegister(forceRegister);
            entry.setAllowDifferentId(allowDifferentId);
            entry.setRequireExactMatch(requireExactMatch);
            return entry;
        }
        catch (Exception e) {
            JustEnoughDimensions.logger.error("Failed to read dimension info from packet for dimension {} - WorldProvider class {} not found", (Object)dimTypeId, (Object)providerClassName);
            return null;
        }
    }

    @Nonnull
    public static DimensionTypeEntry fromJson(int dimension, @Nonnull JsonObject objDimType) {
        String existing = JEDJsonUtils.getStringOrDefault(objDimType, "existing_dimensiontype", null, false);
        if (existing != null) {
            JustEnoughDimensions.logInfo("Using an existing DimensionType '{}' for dimension {}", existing, dimension);
            return new DimensionTypeEntry(existing);
        }
        int dimensionTypeId = JEDJsonUtils.getIntegerOrDefault(objDimType, "id", dimension);
        String name = JEDJsonUtils.getStringOrDefault(objDimType, "name", "DIM" + dimension, false);
        String suffix = JEDJsonUtils.getStringOrDefault(objDimType, "suffix", "_dim" + dimension, false);
        boolean keepLoaded = JEDJsonUtils.getBooleanOrDefault(objDimType, "keeploaded", false);
        boolean forceRegister = JEDJsonUtils.getBooleanOrDefault(objDimType, "force_register", false);
        boolean allowDifferentId = JEDJsonUtils.getBooleanOrDefault(objDimType, "allow_different_id", true);
        boolean requireExactMatch = JEDJsonUtils.getBooleanOrDefault(objDimType, "require_exact_match", false);
        Class<WorldProviderSurfaceJED> providerClass = WorldProviderSurfaceJED.class;
        String providerName = "";
        if (objDimType.has("worldprovider") && objDimType.get("worldprovider").isJsonPrimitive()) {
            providerName = objDimType.get("worldprovider").getAsString();
            if (dimension == 1) {
                if (providerName.equals("WorldProviderSurface") || providerName.equals("net.minecraft.world.WorldProviderSurface")) {
                    providerName = WorldProviderSurfaceJED.class.getSimpleName();
                    JustEnoughDimensions.logger.warn("Changing the provider for DIM1 to {} to prevent a vanilla crash", (Object)providerName);
                } else if (providerName.equals("WorldProviderHell") || providerName.equals("net.minecraft.world.WorldProviderHell")) {
                    providerName = WorldProviderHellJED.class.getSimpleName();
                    JustEnoughDimensions.logger.warn("Changing the provider for DIM1 to {} to prevent a vanilla crash", (Object)providerName);
                }
            }
            providerClass = DimensionTypeEntry.getProviderClass(providerName);
        }
        if (providerClass == null) {
            providerClass = WorldProviderSurfaceJED.class;
            JustEnoughDimensions.logger.warn("Failed to get a WorldProvider for name '{}', using {} as a fall-back", (Object)providerName, (Object)DimensionTypeEntry.getNameForWorldProvider(providerClass));
        }
        DimensionTypeEntry entry = new DimensionTypeEntry(dimensionTypeId, name, suffix, keepLoaded, providerClass);
        entry.setForceRegister(forceRegister);
        entry.setAllowDifferentId(allowDifferentId);
        entry.setRequireExactMatch(requireExactMatch);
        return entry;
    }

    public JsonObject toJson() {
        JsonObject dimensionType = new JsonObject();
        if (this.dimensionTypeName != null) {
            dimensionType.addProperty("existing_dimensiontype", this.dimensionTypeName);
        } else {
            dimensionType.addProperty("id", (Number)this.dimensionTypeId);
            dimensionType.addProperty("name", this.name);
            dimensionType.addProperty("suffix", this.suffix);
            dimensionType.addProperty("keeploaded", Boolean.valueOf(this.keepLoaded));
            dimensionType.addProperty("worldprovider", DimensionTypeEntry.getNameForWorldProvider(this.providerClass));
            if (this.forceRegister) {
                dimensionType.addProperty("force_register", Boolean.valueOf(this.forceRegister));
            }
            if (!this.allowDifferentId) {
                dimensionType.addProperty("allow_different_id", Boolean.valueOf(this.allowDifferentId));
            }
            if (this.requireExactMatch) {
                dimensionType.addProperty("require_exact_match", Boolean.valueOf(this.requireExactMatch));
            }
        }
        return dimensionType;
    }

    public String getDescription() {
        if (this.dimensionTypeName != null) {
            return String.format("{existing_dimensiontype=%s}", this.dimensionTypeName);
        }
        return String.format("{id=%d,name=\"%s\",suffix=\"%s\",keepLoaded=%s,WorldProvider:\"%s\",force_register=%s,allow_different_id=%s}", this.dimensionTypeId, this.name, this.suffix, this.keepLoaded, DimensionTypeEntry.getNameForWorldProvider(this.providerClass), this.forceRegister, this.allowDifferentId);
    }

    @Override
    public int compareTo(DimensionTypeEntry other) {
        if (this.providerClass == other.providerClass) {
            return 0;
        }
        return this.dimensionTypeId > other.dimensionTypeId ? 1 : -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dimensionTypeId;
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.providerClass == ((DimensionTypeEntry)other).providerClass;
    }

    public static String getNameForWorldProvider(@Nonnull Class<? extends WorldProvider> clazz) {
        String provName = clazz.getName();
        if (provName.startsWith("net.minecraft.world.") || provName.equals(WorldProviderSurfaceJED.class.getName()) || provName.equals(WorldProviderHellJED.class.getName()) || provName.equals(WorldProviderEndJED.class.getName())) {
            return clazz.getSimpleName();
        }
        return provName;
    }

    @Nullable
    public static Class<? extends WorldProvider> getProviderClass(String providerClassName) {
        Class providerClass;
        if (providerClassName.equals("WorldProviderSurfaceJED")) {
            providerClass = WorldProviderSurfaceJED.class;
        } else if (providerClassName.equals("WorldProviderHellJED")) {
            providerClass = WorldProviderHellJED.class;
        } else if (providerClassName.equals("WorldProviderEndJED")) {
            providerClass = WorldProviderEndJED.class;
        } else if (providerClassName.equals("WorldProviderSurface")) {
            providerClass = WorldProviderSurface.class;
        } else if (providerClassName.equals("WorldProviderHell")) {
            providerClass = WorldProviderHell.class;
        } else if (providerClassName.equals("WorldProviderEnd")) {
            providerClass = WorldProviderEnd.class;
        } else {
            try {
                providerClass = Class.forName(providerClassName);
            }
            catch (Exception e) {
                JustEnoughDimensions.logger.error("Failed to get a WorldProvider class for name '{}'", (Object)providerClassName, (Object)e);
                return null;
            }
        }
        return providerClass;
    }
}

