/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.items;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.WorldTools;
import mcjty.xnet.XNet;
import mcjty.xnet.api.channels.IChannelSettings;
import mcjty.xnet.api.channels.IConnectorSettings;
import mcjty.xnet.api.channels.IControllerContext;
import mcjty.xnet.api.gui.IEditorGui;
import mcjty.xnet.api.gui.IndicatorIcon;
import mcjty.xnet.api.helper.DefaultChannelSettings;
import mcjty.xnet.api.keys.ConsumerId;
import mcjty.xnet.api.keys.SidedConsumer;
import mcjty.xnet.apiimpl.EnumStringTranslators;
import mcjty.xnet.apiimpl.items.ItemConnectorSettings;
import mcjty.xnet.compat.RFToolsSupport;
import mcjty.xnet.config.GeneralConfiguration;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class ItemChannelSettings
extends DefaultChannelSettings
implements IChannelSettings {
    public static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");
    public static final String TAG_MODE = "mode";
    private Map<SidedConsumer, ItemConnectorSettings> itemExtractors = null;
    private List<Pair<SidedConsumer, ItemConnectorSettings>> itemConsumers = null;
    private ChannelMode channelMode = ChannelMode.PRIORITY;
    private int delay = 0;
    private int roundRobinOffset = 0;
    private Map<ConsumerId, Integer> extractIndices = new HashMap<ConsumerId, Integer>();
    private static Random random = new Random();

    public ChannelMode getChannelMode() {
        return this.channelMode;
    }

    @Override
    public int getColors() {
        return 0;
    }

    @Override
    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        object.add(TAG_MODE, (JsonElement)new JsonPrimitive(this.channelMode.name()));
        return object;
    }

    @Override
    public void readFromJson(JsonObject data) {
        this.channelMode = EnumStringTranslators.getItemChannelMode(data.get(TAG_MODE).getAsString());
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.channelMode = ChannelMode.values()[tag.func_74771_c(TAG_MODE)];
        this.delay = tag.func_74762_e("delay");
        this.roundRobinOffset = tag.func_74762_e("offset");
        int[] cons = tag.func_74759_k("extidx");
        for (int idx = 0; idx < cons.length; idx += 2) {
            this.extractIndices.put(new ConsumerId(cons[idx]), cons[idx + 1]);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74774_a(TAG_MODE, (byte)this.channelMode.ordinal());
        tag.func_74768_a("delay", this.delay);
        tag.func_74768_a("offset", this.roundRobinOffset);
        if (!this.extractIndices.isEmpty()) {
            int[] cons = new int[this.extractIndices.size() * 2];
            int idx = 0;
            for (Map.Entry<ConsumerId, Integer> entry : this.extractIndices.entrySet()) {
                cons[idx++] = entry.getKey().getId();
                cons[idx++] = entry.getValue();
            }
            tag.func_74783_a("extidx", cons);
        }
    }

    private int getExtractIndex(ConsumerId consumer) {
        return this.extractIndices.getOrDefault(consumer, 0);
    }

    private void rememberExtractIndex(ConsumerId consumer, int index) {
        this.extractIndices.put(consumer, index);
    }

    @Override
    public void tick(int channel, IControllerContext context) {
        --this.delay;
        if (this.delay <= 0) {
            this.delay = 1200;
        }
        if (this.delay % 5 != 0) {
            return;
        }
        int d = this.delay / 5;
        this.updateCache(channel, context);
        World world = context.getControllerWorld();
        for (Map.Entry<SidedConsumer, ItemConnectorSettings> entry : this.itemExtractors.entrySet()) {
            EnumFacing side;
            BlockPos pos;
            ConsumerId consumerId;
            BlockPos extractorPos;
            ItemConnectorSettings settings = entry.getValue();
            if (d % settings.getSpeed() != 0 || (extractorPos = context.findConsumerPosition(consumerId = entry.getKey().getConsumerId())) == null || !WorldTools.chunkLoaded((World)world, (BlockPos)(pos = extractorPos.func_177972_a(side = entry.getKey().getSide()))) || this.checkRedstone(world, settings, extractorPos) || !context.matchColor(settings.getColorsMask())) continue;
            TileEntity te = world.func_175625_s(pos);
            if (XNet.rftools && RFToolsSupport.isStorageScanner(te)) {
                RFToolsSupport.tickStorageScanner(context, settings, te, this);
                continue;
            }
            IItemHandler handler = ItemChannelSettings.getItemHandlerAt(te, settings.getFacing());
            if (handler == null) continue;
            int idx = this.getStartExtractIndex(settings, consumerId, handler);
            idx = this.tickItemHandler(context, settings, handler, idx);
            if (handler.getSlots() <= 0) continue;
            this.rememberExtractIndex(consumerId, (idx + 1) % handler.getSlots());
        }
    }

    private int getStartExtractIndex(ItemConnectorSettings settings, ConsumerId consumerId, IItemHandler handler) {
        switch (settings.getExtractMode()) {
            case FIRST: {
                return 0;
            }
            case RND: {
                if (handler.getSlots() <= 0) {
                    return 0;
                }
                for (int i = 0; i < 5; ++i) {
                    int idx = random.nextInt(handler.getSlots());
                    if (handler.getStackInSlot(idx).func_190926_b()) continue;
                    return idx;
                }
                ArrayList<Integer> slots = new ArrayList<Integer>();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    if (handler.getStackInSlot(i).func_190926_b()) continue;
                    slots.add(i);
                }
                if (slots.isEmpty()) {
                    return 0;
                }
                return (Integer)slots.get(random.nextInt(slots.size()));
            }
            case ORDER: {
                return this.getExtractIndex(consumerId);
            }
        }
        return 0;
    }

    private int tickItemHandler(IControllerContext context, ItemConnectorSettings settings, IItemHandler handler, int startIdx) {
        ItemStack stack;
        Predicate<ItemStack> extractMatcher = settings.getMatcher();
        Integer count = settings.getCount();
        int amount = 0;
        if (count != null && (amount = this.countItems(handler, extractMatcher)) < count) {
            return startIdx;
        }
        MInteger index = new MInteger(startIdx);
        while (!(stack = this.fetchItem(handler, true, extractMatcher, settings.getStackMode(), settings.getExtractAmount(), 64, index, startIdx)).func_190926_b()) {
            int toextract = stack.func_190916_E();
            if (count != null) {
                int canextract = amount - count;
                if (canextract <= 0) {
                    index.inc();
                    continue;
                }
                if (canextract < toextract) {
                    toextract = canextract;
                    stack = stack.func_77946_l();
                    stack.func_190920_e(toextract);
                }
            }
            ArrayList<Pair<SidedConsumer, ItemConnectorSettings>> inserted = new ArrayList<Pair<SidedConsumer, ItemConnectorSettings>>();
            int remaining = this.insertStackSimulate(inserted, context, stack);
            if (!inserted.isEmpty()) {
                if (!context.checkAndConsumeRF(GeneralConfiguration.controllerOperationRFT)) break;
                this.insertStackReal(context, inserted, this.fetchItem(handler, false, extractMatcher, settings.getStackMode(), settings.getExtractAmount(), toextract - remaining, index, startIdx));
                break;
            }
            index.inc();
        }
        return index.getSafe(handler.getSlots());
    }

    public int insertStackSimulate(@Nonnull List<Pair<SidedConsumer, ItemConnectorSettings>> inserted, @Nonnull IControllerContext context, @Nonnull ItemStack stack) {
        World world = context.getControllerWorld();
        if (this.channelMode == ChannelMode.PRIORITY) {
            this.roundRobinOffset = 0;
        }
        int total = stack.func_190916_E();
        for (int j = 0; j < this.itemConsumers.size(); ++j) {
            ItemStack remaining;
            BlockPos consumerPos;
            int i = (j + this.roundRobinOffset) % this.itemConsumers.size();
            Pair<SidedConsumer, ItemConnectorSettings> entry = this.itemConsumers.get(i);
            ItemConnectorSettings settings = (ItemConnectorSettings)entry.getValue();
            if (!settings.getMatcher().test(stack) || (consumerPos = context.findConsumerPosition(((SidedConsumer)entry.getKey()).getConsumerId())) == null || !WorldTools.chunkLoaded((World)world, (BlockPos)consumerPos) || this.checkRedstone(world, settings, consumerPos) || !context.matchColor(settings.getColorsMask())) continue;
            EnumFacing side = ((SidedConsumer)entry.getKey()).getSide();
            BlockPos pos = consumerPos.func_177972_a(side);
            TileEntity te = world.func_175625_s(pos);
            int toinsert = total;
            Integer count = settings.getCount();
            if (XNet.rftools && RFToolsSupport.isStorageScanner(te)) {
                if (count != null) {
                    int amount = RFToolsSupport.countItems(te, settings.getMatcher(), (int)count);
                    int caninsert = count - amount;
                    if (caninsert <= 0) continue;
                    toinsert = Math.min(toinsert, caninsert);
                    stack = stack.func_77946_l();
                    if (toinsert <= 0) {
                        stack.func_190920_e(0);
                    } else {
                        stack.func_190920_e(toinsert);
                    }
                }
                remaining = RFToolsSupport.insertItem(te, stack, true);
            } else {
                IItemHandler handler = ItemChannelSettings.getItemHandlerAt(te, settings.getFacing());
                if (handler == null) continue;
                if (count != null) {
                    int amount = this.countItems(handler, settings.getMatcher());
                    int caninsert = count - amount;
                    if (caninsert <= 0) continue;
                    toinsert = Math.min(toinsert, caninsert);
                    stack = stack.func_77946_l();
                    if (toinsert <= 0) {
                        stack.func_190920_e(0);
                    } else {
                        stack.func_190920_e(toinsert);
                    }
                }
                remaining = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)true);
            }
            int actuallyinserted = toinsert - remaining.func_190916_E();
            if (count == null) {
                stack = remaining;
            }
            if (actuallyinserted <= 0) continue;
            inserted.add(entry);
            if ((total -= actuallyinserted) > 0) continue;
            return 0;
        }
        return total;
    }

    public void insertStackReal(@Nonnull IControllerContext context, @Nonnull List<Pair<SidedConsumer, ItemConnectorSettings>> inserted, @Nonnull ItemStack stack) {
        int total = stack.func_190916_E();
        for (Pair<SidedConsumer, ItemConnectorSettings> entry : inserted) {
            BlockPos consumerPosition = context.findConsumerPosition(((SidedConsumer)entry.getKey()).getConsumerId());
            EnumFacing side = ((SidedConsumer)entry.getKey()).getSide();
            ItemConnectorSettings settings = (ItemConnectorSettings)entry.getValue();
            BlockPos pos = consumerPosition.func_177972_a(side);
            TileEntity te = context.getControllerWorld().func_175625_s(pos);
            if (XNet.rftools && RFToolsSupport.isStorageScanner(te)) {
                int toinsert = total;
                Integer count = settings.getCount();
                if (count != null) {
                    int amount = RFToolsSupport.countItems(te, settings.getMatcher(), (int)count);
                    int caninsert = count - amount;
                    if (caninsert <= 0) continue;
                    toinsert = Math.min(toinsert, caninsert);
                    stack = stack.func_77946_l();
                    if (toinsert <= 0) {
                        stack.func_190920_e(0);
                    } else {
                        stack.func_190920_e(toinsert);
                    }
                }
                ItemStack remaining = RFToolsSupport.insertItem(te, stack, false);
                int actuallyinserted = toinsert - remaining.func_190916_E();
                if (count == null) {
                    stack = remaining;
                }
                if (actuallyinserted <= 0) continue;
                this.roundRobinOffset = (this.roundRobinOffset + 1) % this.itemConsumers.size();
                if ((total -= actuallyinserted) > 0) continue;
                return;
            }
            IItemHandler handler = ItemChannelSettings.getItemHandlerAt(te, settings.getFacing());
            int toinsert = total;
            Integer count = settings.getCount();
            if (count != null) {
                int amount = this.countItems(handler, settings.getMatcher());
                int caninsert = count - amount;
                if (caninsert <= 0) continue;
                toinsert = Math.min(toinsert, caninsert);
                stack = stack.func_77946_l();
                if (toinsert <= 0) {
                    stack.func_190920_e(0);
                } else {
                    stack.func_190920_e(toinsert);
                }
            }
            ItemStack remaining = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
            int actuallyinserted = toinsert - remaining.func_190916_E();
            if (count == null) {
                stack = remaining;
            }
            if (actuallyinserted <= 0) continue;
            this.roundRobinOffset = (this.roundRobinOffset + 1) % this.itemConsumers.size();
            if ((total -= actuallyinserted) > 0) continue;
            return;
        }
    }

    private int countItems(IItemHandler handler, Predicate<ItemStack> matcher) {
        int cnt = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack s = handler.getStackInSlot(i);
            if (s.func_190926_b() || !matcher.test(s)) continue;
            cnt += s.func_190916_E();
        }
        return cnt;
    }

    private ItemStack fetchItem(IItemHandler handler, boolean simulate, Predicate<ItemStack> matcher, ItemConnectorSettings.StackMode stackMode, int extractAmount, int maxamount, MInteger index, int startIdx) {
        if (handler.getSlots() <= 0) {
            return ItemStack.field_190927_a;
        }
        for (int i = index.get(); i < handler.getSlots() + startIdx; ++i) {
            int j = i % handler.getSlots();
            ItemStack stack = handler.getStackInSlot(j);
            if (stack.func_190926_b()) continue;
            int s = 0;
            switch (stackMode) {
                case SINGLE: {
                    s = 1;
                    break;
                }
                case STACK: {
                    s = stack.func_77976_d();
                    break;
                }
                case COUNT: {
                    s = extractAmount;
                }
            }
            s = Math.min(s, maxamount);
            stack = handler.extractItem(j, s, simulate);
            if (stack.func_190926_b() || !matcher.test(stack)) continue;
            index.set(i);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.itemExtractors == null) {
            ItemConnectorSettings con;
            this.itemExtractors = new HashMap<SidedConsumer, ItemConnectorSettings>();
            this.itemConsumers = new ArrayList<Pair<SidedConsumer, ItemConnectorSettings>>();
            Map<SidedConsumer, IConnectorSettings> connectors = context.getConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                con = (ItemConnectorSettings)entry.getValue();
                if (con.getItemMode() == ItemConnectorSettings.ItemMode.EXT) {
                    this.itemExtractors.put(entry.getKey(), con);
                    continue;
                }
                this.itemConsumers.add((Pair<SidedConsumer, ItemConnectorSettings>)Pair.of((Object)entry.getKey(), (Object)con));
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                con = (ItemConnectorSettings)entry.getValue();
                if (con.getItemMode() != ItemConnectorSettings.ItemMode.INS) continue;
                this.itemConsumers.add((Pair<SidedConsumer, ItemConnectorSettings>)Pair.of((Object)entry.getKey(), (Object)con));
            }
            this.itemConsumers.sort((o1, o2) -> ((ItemConnectorSettings)o2.getRight()).getPriority().compareTo(((ItemConnectorSettings)o1.getRight()).getPriority()));
        }
    }

    @Override
    public void cleanCache() {
        this.itemExtractors = null;
        this.itemConsumers = null;
    }

    @Override
    public boolean isEnabled(String tag) {
        return true;
    }

    @Override
    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(iconGuiElements, 0, 80, 11, 10);
    }

    @Override
    @Nullable
    public String getIndicator() {
        return null;
    }

    @Override
    public void createGui(IEditorGui gui) {
        gui.nl().choices(TAG_MODE, "Item distribution mode", this.channelMode, ChannelMode.values());
    }

    @Override
    public void update(Map<String, Object> data) {
        this.channelMode = ChannelMode.valueOf(((String)data.get(TAG_MODE)).toUpperCase());
        this.roundRobinOffset = 0;
    }

    @Nullable
    public static IItemHandler getItemHandlerAt(@Nullable TileEntity te, EnumFacing intSide) {
        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, intSide)) {
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, intSide);
            if (handler != null) {
                return handler;
            }
        } else {
            if (te instanceof ISidedInventory) {
                ISidedInventory sidedInventory = (ISidedInventory)te;
                return new SidedInvWrapper(sidedInventory, intSide);
            }
            if (te instanceof IInventory) {
                IInventory inventory = (IInventory)te;
                return new InvWrapper(inventory);
            }
        }
        return null;
    }

    private static class MInteger {
        private int i;

        public MInteger(int i) {
            this.i = i;
        }

        public int get() {
            return this.i;
        }

        public int getSafe(int bounds) {
            return bounds <= 0 ? this.i : this.i % bounds;
        }

        public void set(int i) {
            this.i = i;
        }

        public void inc() {
            ++this.i;
        }
    }

    public static enum ChannelMode {
        PRIORITY,
        ROUNDROBIN;

    }
}

