/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.torchmagic;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.entity.EntityThrowableDispensable;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.item.core.BaseItemProjectile;
import com.lothrazar.cyclicmagic.item.torchmagic.EntityTorchBolt;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilPlayer;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class ItemProjectileTorch
extends BaseItemProjectile
implements IHasRecipe,
IContent {
    private boolean enabled;

    @Override
    public void register() {
        ItemRegistry.register(this, "ender_torch", GuideCategory.ITEMTHROW);
        EntityTorchBolt.register();
        EntityTorchBolt.item = this;
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("EnderTorch", "cyclicmagic.content", true, "Set false to delete - requires restart");
    }

    @Override
    public EntityThrowableDispensable getThrownEntity(World world, ItemStack held, double x, double y, double z) {
        return new EntityTorchBolt(world, x, y, z, false);
    }

    @Override
    public IRecipe addRecipe() {
        RecipeRegistry.addShapelessRecipe(new ItemStack((Item)this, 1), new ItemStack((Block)Blocks.field_150329_H, 1, Short.MAX_VALUE), "torch");
        return RecipeRegistry.addShapelessRecipe(new ItemStack((Item)this, 1), "treeLeaves", "torch");
    }

    @Override
    public void onItemThrow(ItemStack held, World world, EntityPlayer player, EnumHand hand) {
        this.doThrow(world, player, hand, new EntityTorchBolt(world, (EntityLivingBase)player, false));
        UtilPlayer.decrStackSize(player, hand);
    }

    @Override
    public SoundEvent getSound() {
        return SoundEvents.field_187511_aA;
    }
}

