/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.snowmagic;

import com.lothrazar.cyclicmagic.entity.EntityThrowableDispensable;
import com.lothrazar.cyclicmagic.entity.RenderBall;
import com.lothrazar.cyclicmagic.potion.PotionEffectRegistry;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilSound;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class EntitySnowballBolt
extends EntityThrowableDispensable {
    private static final int SLOWNESSLEVEL = 2;
    private static final int POTIONSECONDS = 30;
    private float damage = 3.0f;

    public EntitySnowballBolt(World worldIn) {
        super(worldIn);
    }

    public EntitySnowballBolt(World worldIn, EntityLivingBase ent) {
        super(worldIn, ent);
    }

    public EntitySnowballBolt(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public void setDamage(float d) {
        this.damage = d;
    }

    @Override
    protected void processImpact(RayTraceResult mop) {
        World world = this.func_130014_f_();
        if (mop.field_72308_g != null && mop.field_72308_g instanceof EntityLivingBase) {
            UtilParticle.spawnParticle(world, EnumParticleTypes.SNOW_SHOVEL, mop.field_72308_g.func_180425_c());
            if (mop.field_72308_g instanceof EntityPlayer) {
                this.onHitPlayer(mop, (EntityPlayer)mop.field_72308_g);
            } else {
                this.onHitEntity(mop);
            }
            this.func_70106_y();
        } else if (this.func_70090_H()) {
            this.onHitWater(mop);
            this.func_70106_y();
        } else {
            this.onHitGround(mop);
            this.func_70106_y();
        }
    }

    private void onHitPlayer(RayTraceResult mop, EntityPlayer entityHit) {
        entityHit.func_70066_B();
        entityHit.func_70690_d(new PotionEffect((Potion)PotionEffectRegistry.SNOW, 600));
    }

    private void onHitEntity(RayTraceResult mop) {
        EntityLivingBase e = (EntityLivingBase)mop.field_72308_g;
        if (e.func_70027_ad()) {
            e.func_70066_B();
        }
        e.func_70690_d(new PotionEffect((Potion)PotionEffectRegistry.SNOW, 600));
        e.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 600, 2));
        mop.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), this.damage);
    }

    private void onHitGround(RayTraceResult mop) {
        BlockPos pos = mop.func_178782_a();
        if (pos == null) {
            return;
        }
        UtilParticle.spawnParticle(this.field_70170_p, EnumParticleTypes.SNOW_SHOVEL, pos);
        World world = this.func_130014_f_();
        if (mop.field_178784_b != null) {
            world.func_175719_a((EntityPlayer)this.func_85052_h(), pos, mop.field_178784_b);
        }
        BlockPos hit = pos;
        BlockPos hitDown = hit.func_177977_b();
        BlockPos hitUp = hit.func_177984_a();
        IBlockState hitState = world.func_180495_p(hit);
        if (hitState.func_177230_c() == Blocks.field_150431_aC) {
            EntitySnowballBolt.setMoreSnow(world, hit);
        } else if (world.func_180495_p(hitDown).func_177230_c() == Blocks.field_150431_aC) {
            EntitySnowballBolt.setMoreSnow(world, hitDown);
        } else if (world.func_180495_p(hitUp).func_177230_c() == Blocks.field_150431_aC) {
            EntitySnowballBolt.setMoreSnow(world, hitUp);
        } else if (!world.func_175623_d(hit) && world.func_175623_d(hitUp)) {
            EntitySnowballBolt.setNewSnow(world, hitUp);
        } else if (!world.func_175623_d(hit) && world.func_175623_d(hitUp)) {
            EntitySnowballBolt.setNewSnow(world, hitUp);
        }
    }

    public void onHitWater(RayTraceResult mop) {
        BlockPos posWater;
        World world = this.func_130014_f_();
        if (world.func_180495_p(posWater = this.func_180425_c()) != Blocks.field_150355_j.func_176223_P()) {
            posWater = null;
            if (world.func_180495_p(mop.func_178782_a()) == Blocks.field_150355_j.func_176223_P()) {
                posWater = mop.func_178782_a();
            } else if (world.func_180495_p(mop.func_178782_a().func_177972_a(mop.field_178784_b)) == Blocks.field_150355_j.func_176223_P()) {
                posWater = mop.func_178782_a().func_177972_a(mop.field_178784_b);
            }
        }
        if (posWater != null) {
            world.func_175656_a(posWater, Blocks.field_150432_aD.func_176223_P());
        }
    }

    private static void setMoreSnow(World world, BlockPos pos) {
        IBlockState hitState = world.func_180495_p(pos);
        int m = hitState.func_177230_c().func_176201_c(hitState) + 1;
        if (BlockSnow.field_176315_a.func_177700_c().contains(m + 1)) {
            world.func_175656_a(pos, Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(m + 1)));
            UtilSound.playSound(world, pos, SoundEvents.field_187813_fI, SoundCategory.BLOCKS);
        } else {
            EntitySnowballBolt.setNewSnow(world, pos.func_177984_a());
        }
    }

    private static void setNewSnow(World world, BlockPos pos) {
        world.func_175656_a(pos, Blocks.field_150431_aC.func_176223_P());
        UtilSound.playSound(world, pos, SoundEvents.field_187813_fI, SoundCategory.BLOCKS);
    }

    public static class FactorySnow
    implements IRenderFactory<EntitySnowballBolt> {
        public Render<? super EntitySnowballBolt> createRenderFor(RenderManager rm) {
            return new RenderBall(rm, "snow");
        }
    }
}

