/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.homingmissile;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.item.core.BaseTool;
import com.lothrazar.cyclicmagic.item.homingmissile.EntityHomingProjectile;
import com.lothrazar.cyclicmagic.registry.EntityProjectileRegistry;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMagicMissile
extends BaseTool
implements IHasRecipe,
IContent {
    private static final double RANGE = 16.0;
    private static final int durability = 500;
    private static final int COOLDOWN = 8;
    private boolean enabled;

    public ItemMagicMissile() {
        super(500);
    }

    @Override
    public void register() {
        ItemRegistry.register(this, "wand_missile", GuideCategory.ITEMTHROW);
        EntityProjectileRegistry.registerModEntity(EntityHomingProjectile.class, "magic_missile", 1020);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("MagicMissile", "cyclicmagic.content", true, "Set false to delete - requires restart");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack held = player.func_184586_b(hand);
        UtilSound.playSound(player, SoundRegistry.spirit_seeker);
        int x = player.func_180425_c().func_177958_n();
        int y = player.func_180425_c().func_177956_o();
        int z = player.func_180425_c().func_177952_p();
        List targets = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)x - 16.0, (double)y - 16.0, (double)z - 16.0, (double)x + 16.0, (double)y + 16.0, (double)z + 16.0));
        ArrayList<EntityLivingBase> trimmedTargets = new ArrayList<EntityLivingBase>();
        for (EntityLivingBase potential : targets) {
            if (potential.field_70128_L || potential.func_110124_au().compareTo(player.func_110124_au()) == 0 || !potential.isCreatureType(EnumCreatureType.MONSTER, false)) continue;
            trimmedTargets.add(potential);
        }
        if (trimmedTargets.size() == 0) {
            UtilChat.sendStatusMessage(player, "wand.result.notargets");
        } else {
            EntityLivingBase target = UtilEntity.getClosestEntity(world, player, trimmedTargets);
            EntityHomingProjectile projectile = new EntityHomingProjectile(world, (EntityLivingBase)player);
            projectile.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 0.5f, 1.0f);
            projectile.setTarget(target);
            world.func_72838_d((Entity)projectile);
        }
        UtilEntity.setCooldownItem(player, held.func_77973_b(), 8);
        super.onUse(held, player, world, hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)held);
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), "dcd", " b ", "rbr", Character.valueOf('d'), "gemDiamond", Character.valueOf('c'), new ItemStack(Items.field_151073_bk), Character.valueOf('r'), "ingotGold", Character.valueOf('b'), "ingotIron");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }
}

