/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.equipbauble;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.data.IHasRecipeAndRepair;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.item.core.BaseCharm;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.LootTableRegistry;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilSound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class ItemCharmFire
extends BaseCharm
implements IHasRecipeAndRepair,
IContent {
    private static final int durability = 16;
    private static final int seconds = 10;
    private static final ItemStack craftItem = new ItemStack(Items.field_151072_bj);
    private boolean enabled;

    public ItemCharmFire() {
        super(16);
    }

    @Override
    public void register() {
        ItemRegistry.register(this, "charm_fire", GuideCategory.ITEMBAUBLES);
        LootTableRegistry.registerLoot(this);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("FireCharm", "cyclicmagic.content", true, "Set false to delete - requires restart");
    }

    @Override
    public void onTick(ItemStack stack, EntityPlayer living) {
        if (!this.canTick(stack)) {
            return;
        }
        if (living.func_70027_ad() && !living.func_70644_a(MobEffects.field_76426_n)) {
            World worldIn = living.func_130014_f_();
            living.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 200, 0));
            super.damageCharm(living, stack);
            UtilSound.playSound(living, living.func_180425_c(), SoundEvents.field_187646_bt, living.func_184176_by());
            UtilParticle.spawnParticle(worldIn, EnumParticleTypes.WATER_WAKE, living.func_180425_c());
            UtilParticle.spawnParticle(worldIn, EnumParticleTypes.WATER_WAKE, living.func_180425_c().func_177984_a());
        }
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == craftItem.func_77973_b();
    }

    @Override
    public IRecipe addRecipe() {
        return super.addRecipe(craftItem);
    }
}

