/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.item.core.BaseTool;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWandHypno
extends BaseTool
implements IHasRecipe,
IContent {
    private static final double RANGE = 16.0;
    private static final int durability = 100;
    private static final int COOLDOWN = 60;
    private boolean enabled;

    public ItemWandHypno() {
        super(100);
    }

    @Override
    public void register() {
        ItemRegistry.register(this, "wand_hypno", GuideCategory.ITEMTHROW);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("ChaosSiren", "cyclicmagic.content", true, "Set false to delete - requires restart");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack held = player.func_184586_b(hand);
        UtilSound.playSound(player, SoundRegistry.chaos_reaper);
        if (!world.field_72995_K) {
            int x = player.func_180425_c().func_177958_n();
            int y = player.func_180425_c().func_177956_o();
            int z = player.func_180425_c().func_177952_p();
            List targets = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)x - 16.0, (double)y - 16.0, (double)z - 16.0, (double)x + 16.0, (double)y + 16.0, (double)z + 16.0));
            ArrayList trimmedTargets = new ArrayList();
            for (int i = 0; i < targets.size(); ++i) {
                if (((EntityLivingBase)targets.get(i)).func_110124_au().compareTo(player.func_110124_au()) == 0 || !((EntityLivingBase)targets.get(i)).isCreatureType(EnumCreatureType.MONSTER, false)) continue;
                trimmedTargets.add(targets.get(i));
            }
            int targeted = 0;
            for (int i = 0; i < trimmedTargets.size(); ++i) {
                EntityLivingBase cur = (EntityLivingBase)trimmedTargets.get(i);
                cur.func_70604_c(null);
                int j = world.field_73012_v.nextInt(trimmedTargets.size());
                if (j == i) continue;
                EntityLivingBase curTarget = (EntityLivingBase)trimmedTargets.get(j);
                cur.func_70604_c(curTarget);
                cur.func_130011_c((Entity)curTarget);
                ForgeHooks.onLivingSetAttackTarget((EntityLivingBase)cur, (EntityLivingBase)curTarget);
                UtilParticle.spawnParticlePacket(EnumParticleTypes.DRAGON_BREATH, cur.func_180425_c(), player.field_71093_bK);
                ++targeted;
            }
            if (targeted == 0) {
                UtilChat.sendStatusMessage(player, "wand.result.notargets");
            }
        }
        UtilEntity.setCooldownItem(player, this, 60);
        super.onUse(held, player, world, hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)held);
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), "dcd", " x ", "rbr", Character.valueOf('d'), "ingotGold", Character.valueOf('c'), new ItemStack(Items.field_151073_bk), Character.valueOf('r'), "dyeBlue", Character.valueOf('b'), new ItemStack(Blocks.field_150419_aX), Character.valueOf('x'), new ItemStack(Blocks.field_150420_aW));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }
}

