/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.item.core.BaseTool;
import com.lothrazar.cyclicmagic.potion.PotionEffectRegistry;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPlayerLauncher
extends BaseTool
implements IHasRecipe,
IContent {
    private static final int COOLDOWN = 20;
    private static final int POTION_TIME = 200;
    private static final float POWER_UPSCALE = 5.18f;
    private static final float MAX_POWER = 6.7f;
    private static final float VERTICAL_FACTOR = 2.88f;
    private static final int TICKS_USING = 53000;
    private boolean enabled;

    public ItemPlayerLauncher() {
        super(2000);
    }

    @Override
    public void register() {
        ItemRegistry.register(this, "tool_launcher", GuideCategory.TRANSPORT);
        ModCyclic.instance.events.register(this);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("PlayerLauncher", "cyclicmagic.content", true, "Set false to delete - requires restart");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77948_v() || ActionType.isForward(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        if (hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184614_ca());
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int chargeTimer) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return;
        }
        int charge = this.func_77626_a(stack) - chargeTimer;
        float power = Math.min(6.7f, ItemBow.func_185059_b((int)charge) * 5.18f);
        Vec3d vec = player.func_70040_Z().func_72432_b();
        int rev = ActionType.isForward(stack) ? 1 : -1;
        player.func_70024_g(vec.field_72450_a * (double)(power *= (float)rev), vec.field_72448_b * (double)power / (double)2.88f, vec.field_72449_c * (double)power);
        player.func_70690_d(new PotionEffect((Potion)PotionEffectRegistry.BOUNCE, 200, 0));
        UtilSound.playSound(player, player.func_180425_c(), SoundRegistry.machine_launch, SoundCategory.PLAYERS);
        UtilEntity.setCooldownItem(player, stack.func_77973_b(), 20);
        super.onUse(stack, player, world, EnumHand.MAIN_HAND);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entityIn, int itemSlot, boolean isSelected) {
        ActionType.tickTimeout(stack);
    }

    @SubscribeEvent
    public void onHit(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack held = player.func_184586_b(event.getHand());
        if (held != null && held.func_77973_b() == this) {
            if (ActionType.getTimeout(held) > 0) {
                return;
            }
            ActionType.setTimeout(held);
            event.setCanceled(true);
            UtilSound.playSound(player, player.func_180425_c(), SoundRegistry.tool_mode, SoundCategory.PLAYERS, 0.3f);
            if (!player.func_130014_f_().field_72995_K) {
                ActionType.toggle(held);
                UtilChat.sendStatusMessage(player, UtilChat.lang(ActionType.getName(held)));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GREEN + UtilChat.lang(ActionType.getName(stack)));
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    public int func_77626_a(ItemStack stack) {
        return 53000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), "rsq", " rs", "t r", Character.valueOf('t'), "gemDiamond", Character.valueOf('r'), "glowstone", Character.valueOf('s'), "slimeball", Character.valueOf('q'), "blockQuartz");
    }

    public static enum ActionType {
        FORWARD,
        REVERSE;

        private static final String NBT = "ActionType";
        private static final String NBTTIMEOUT = "timeout";

        public static void toggle(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int type = tags.func_74762_e(NBT);
            type = type == FORWARD.ordinal() ? REVERSE.ordinal() : FORWARD.ordinal();
            tags.func_74768_a(NBT, type);
            wand.func_77982_d(tags);
        }

        public static String getName(ItemStack wand) {
            try {
                NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
                return "tool.action." + ActionType.values()[tags.func_74762_e(NBT)].toString().toLowerCase();
            }
            catch (Exception e) {
                return "tool.action." + FORWARD.toString().toLowerCase();
            }
        }

        public static void setTimeout(ItemStack wand) {
            UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, 15);
        }

        public static int getTimeout(ItemStack wand) {
            return UtilNBT.getItemStackNBT(wand).func_74762_e(NBTTIMEOUT);
        }

        public static void tickTimeout(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int t = tags.func_74762_e(NBTTIMEOUT);
            if (t > 0) {
                UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, t - 1);
            }
        }

        public static boolean isForward(ItemStack held) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(held);
            int type = tags.func_74762_e(NBT);
            return type == FORWARD.ordinal();
        }
    }
}

