/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.gui.core;

import com.lothrazar.cyclicmagic.gui.button.ButtonCheckboxTileField;
import com.lothrazar.cyclicmagic.gui.core.GuiBaseContainer;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.EnumFacing;

public class CheckboxFacingComponent {
    private GuiBaseContainer parent;
    private int xCenter;
    private int yCenter;
    private Map<EnumFacing, Integer> facingFields;

    public CheckboxFacingComponent(GuiBaseContainer parent) {
        this.parent = parent;
    }

    public Map<EnumFacing, Integer> getFacingFields() {
        return this.facingFields;
    }

    public void setX(int x) {
        this.xCenter = x;
    }

    public void setY(int y) {
        this.yCenter = y;
    }

    public void setFacingFields(Map<EnumFacing, Integer> facingFields) {
        this.facingFields = facingFields;
    }

    public void initGui() {
        for (EnumFacing f : EnumFacing.values()) {
            this.addButtonFacing(f);
        }
    }

    private void addButtonFacing(EnumFacing side) {
        int x = 0;
        int y = 0;
        int spacing = 14;
        int field = 0;
        field = this.facingFields.get(side);
        switch (side) {
            case EAST: {
                x = this.xCenter + spacing;
                y = this.yCenter;
                break;
            }
            case NORTH: {
                x = this.xCenter;
                y = this.yCenter - spacing;
                break;
            }
            case SOUTH: {
                x = this.xCenter;
                y = this.yCenter + spacing;
                break;
            }
            case WEST: {
                x = this.xCenter - spacing;
                y = this.yCenter;
                break;
            }
            case UP: {
                x = this.xCenter + spacing;
                y = this.yCenter + 32;
                break;
            }
            case DOWN: {
                x = this.xCenter - spacing;
                y = this.yCenter + 32;
            }
        }
        int w = 18;
        int h = 15;
        ButtonCheckboxTileField btn = new ButtonCheckboxTileField(field + 30, this.parent.getGuiLeft() + x, this.parent.getGuiTop() + y, this.parent.tile.func_174877_v(), field, w, h);
        btn.setIsChecked(this.parent.tile.func_174887_a_(field) == 1);
        btn.setTooltip("tile.clock.facing." + side.name().toLowerCase());
        this.parent.insertButton((GuiButton)btn);
    }
}

