/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.enchant;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.enchant.BaseEnchant;
import com.lothrazar.cyclicmagic.guide.GuideRegistry;
import com.lothrazar.cyclicmagic.registry.EnchantRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantReach
extends BaseEnchant {
    private static final String NBT_REACH_ON = "reachon";
    private static final int REACH_VANILLA = 5;
    private static final int REACH_BOOST = 16;
    private static final Enchantment.Rarity RARITY = Enchantment.Rarity.VERY_RARE;
    private boolean enabled;

    public EnchantReach() {
        super("reach", RARITY, EnumEnchantmentType.ARMOR_CHEST, new EntityEquipmentSlot[]{EntityEquipmentSlot.CHEST});
        GuideRegistry.register(this, new ArrayList<String>(Arrays.asList("16")));
    }

    @Override
    public void register() {
        EnchantRegistry.register(this);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("EnchantReach", "cyclicmagic.content", true, "Set false to delete - requires restart");
    }

    public int func_77325_b() {
        return 1;
    }

    public boolean func_92089_a(ItemStack stack) {
        boolean yes = stack.func_77973_b() == Items.field_151122_aG || stack.func_77973_b() == Items.field_185160_cR || stack.func_77973_b() instanceof ItemArmor && ((ItemArmor)stack.func_77973_b()).field_77881_a == EntityEquipmentSlot.CHEST;
        return yes;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.func_92089_a(stack);
    }

    private void turnReachOff(EntityPlayer player) {
        player.getEntityData().func_74757_a(NBT_REACH_ON, false);
        ModCyclic.proxy.setPlayerReach(player, 5);
    }

    private void turnReachOn(EntityPlayer player) {
        player.getEntityData().func_74757_a(NBT_REACH_ON, true);
        ModCyclic.proxy.setPlayerReach(player, 16);
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        ItemStack armor = player.func_184582_a(EntityEquipmentSlot.CHEST);
        int level = 0;
        if (!armor.func_190926_b() && EnchantmentHelper.func_82781_a((ItemStack)armor) != null && EnchantmentHelper.func_82781_a((ItemStack)armor).containsKey(this)) {
            level = (Integer)EnchantmentHelper.func_82781_a((ItemStack)armor).get(this);
        }
        if (level > 0) {
            this.turnReachOn(player);
        } else if (player.getEntityData().func_74764_b(NBT_REACH_ON) && player.getEntityData().func_74767_n(NBT_REACH_ON)) {
            this.turnReachOff(player);
        }
    }
}

