/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.enchanter;

import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineFluid;
import com.lothrazar.cyclicmagic.block.enchanter.BlockEnchanter;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.liquid.FluidTankFixDesync;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityEnchanter
extends TileEntityBaseMachineFluid
implements ITickable,
ITileRedstoneToggle {
    public static final int TANK_FULL = 10000;
    public static final int TIMER_FULL = 22;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    private static final int MAX_LEVEL = 30;
    public static int FLUID_COST = 300;

    public TileEntityEnchanter() {
        super(2);
        this.initEnergy(BlockEnchanter.FUEL_COST);
        this.setSlotsForExtract(1);
        this.setSlotsForInsert(0);
        this.tank = new FluidTankFixDesync(10000, this);
        this.tank.setFluidAllowed(FluidRegistry.getFluid((String)"xpjuice"));
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        ItemStack inputStack = this.func_70301_a(0);
        if (inputStack.func_190926_b() || !this.hasEnoughFluid()) {
            return;
        }
        if (!this.updateEnergyIsBurning()) {
            return;
        }
        --this.timer;
        if (this.timer <= 0) {
            this.timer = 22;
            ItemStack outputStack = ItemStack.field_190927_a;
            if ((inputStack.func_77973_b() == Items.field_151122_aG || inputStack.func_77956_u()) && this.hasEnoughFluid() && this.func_70301_a(1).func_190926_b()) {
                outputStack = inputStack.func_77946_l();
                outputStack.func_190920_e(1);
                inputStack.func_190918_g(1);
                outputStack = EnchantmentHelper.func_77504_a((Random)this.field_145850_b.field_73012_v, (ItemStack)outputStack, (int)30, (boolean)true);
                this.func_70299_a(0, inputStack);
                this.func_70299_a(1, outputStack);
                this.drain(FLUID_COST, true);
            }
        }
    }

    private boolean hasEnoughFluid() {
        FluidStack contains = this.tank.getFluid();
        return contains != null && contains.amount >= FLUID_COST;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags.func_74768_a("Timer", this.timer);
        tags.func_74768_a("redstone", this.needsRedstone);
        return super.func_189515_b(tags);
    }

    @Override
    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.timer = tags.func_74762_e("Timer");
        this.needsRedstone = tags.func_74762_e("redstone");
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value % 2;
            }
        }
    }

    @Override
    public void toggleNeedsRedstone() {
        this.func_174885_b(Fields.REDSTONE.ordinal(), (this.needsRedstone + 1) % 2);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public static enum Fields {
        TIMER,
        REDSTONE;

    }
}

