/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.bean;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.bean.ItemMagicBean;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.LootTableRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class BlockCropMagicBean
extends BlockCrops
implements IContent {
    public static final int MAX_AGE = 7;
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    private static final AxisAlignedBB[] AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.4375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0)};
    private List<ItemStack> myDrops = new ArrayList<ItemStack>();
    private ItemMagicBean seed;
    private boolean allowBonemeal;
    private boolean dropSeedOnHarvest;
    private ArrayList<String> myDropStrings;
    private Random rand = new Random();
    private boolean enabled;

    public BlockCropMagicBean() {
        EnumDyeColor[] dyeItems;
        Item[] drops;
        for (Item i : drops = new Item[]{Items.field_151055_y, Items.field_151014_N, Item.func_150898_a((Block)Blocks.field_150327_N), Item.func_150898_a((Block)Blocks.field_150329_H), Item.func_150898_a((Block)Blocks.field_150330_I)}) {
            this.myDrops.add(new ItemStack(i));
        }
        for (EnumDyeColor enumDyeColor : dyeItems = new EnumDyeColor[]{EnumDyeColor.GRAY, EnumDyeColor.LIGHT_BLUE, EnumDyeColor.CYAN, EnumDyeColor.RED, EnumDyeColor.ORANGE, EnumDyeColor.YELLOW, EnumDyeColor.LIME, EnumDyeColor.MAGENTA, EnumDyeColor.PURPLE, EnumDyeColor.PINK, EnumDyeColor.SILVER}) {
            this.myDrops.add(new ItemStack(Items.field_151100_aR, 1, enumDyeColor.func_176765_a()));
        }
        for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
            this.myDrops.add(new ItemStack((Block)Blocks.field_150397_co, 1, enumDyeColor.func_176765_a()));
        }
        for (EnumDyeColor enumDyeColor : BlockFlower.EnumFlowerType.values()) {
            this.myDrops.add(new ItemStack((Block)Blocks.field_150328_O, 1, enumDyeColor.func_176968_b()));
        }
        for (EnumDyeColor enumDyeColor : BlockDoublePlant.EnumPlantType.values()) {
            this.myDrops.add(new ItemStack((Block)Blocks.field_150398_cm, 1, enumDyeColor.func_176936_a()));
        }
    }

    protected PropertyInteger func_185524_e() {
        return AGE;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.func_185525_y(state) ? this.func_149866_i() : this.func_149866_i();
    }

    protected Item func_149866_i() {
        return this.seed;
    }

    public void setSeed(ItemMagicBean item) {
        this.seed = item;
    }

    protected Item func_149865_P() {
        return null;
    }

    private ItemStack getCropStack() {
        String res = this.myDropStrings.get(this.rand.nextInt(this.myDropStrings.size()));
        try {
            String[] ares = res.split(Pattern.quote("*"));
            Item item = Item.func_111206_d((String)ares[0]);
            if (item == null) {
                ModCyclic.logger.error("Magic Bean config: loot item not found " + res);
                this.myDropStrings.remove(res);
                return this.getCropStack();
            }
            String meta = ares.length > 1 ? ares[1] : "0";
            int imeta = Integer.parseInt(meta);
            ItemStack stack = new ItemStack(item, 1, imeta);
            return stack;
        }
        catch (Exception e) {
            ModCyclic.logger.error("Magic Bean config: loot item not found " + res);
            ModCyclic.logger.error(e.getMessage());
            return new ItemStack(Blocks.field_150346_d);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB[(Integer)state.func_177229_b((IProperty)this.func_185524_e())];
    }

    public int func_149745_a(Random random) {
        return super.func_149745_a(random) + 1;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        NonNullList ret = NonNullList.func_191196_a();
        this.getDrops((NonNullList<ItemStack>)ret, world, pos, state, fortune);
        return ret;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        boolean isGrown = this.func_185525_y(state);
        if (isGrown) {
            int count = this.quantityDropped(state, fortune, this.rand);
            for (int i = 0; i < count; ++i) {
                drops.add((Object)this.getCropStack().func_77946_l());
            }
            if (this.dropSeedOnHarvest) {
                drops.add((Object)new ItemStack(this.func_149866_i()).func_77946_l());
            }
        } else {
            drops.add((Object)new ItemStack(this.func_149866_i()).func_77946_l());
        }
    }

    public int func_185526_g() {
        return 7;
    }

    protected int func_185529_b(World worldIn) {
        return this.allowBonemeal ? 1 : 0;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return this.func_185529_b(worldIn) > 0;
    }

    @Override
    public void register() {
        BlockCropMagicBean sprout = new BlockCropMagicBean();
        BlockRegistry.registerBlock((Block)sprout, "sprout", null);
        ItemMagicBean sprout_seed = new ItemMagicBean((Block)sprout, Blocks.field_150458_ak);
        ItemRegistry.register((Item)sprout_seed, "sprout_seed");
        LootTableRegistry.registerLoot((Item)sprout_seed);
        sprout.setSeed(sprout_seed);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("MagicBean", "cyclicmagic.content", true, "Set false to delete - requires restart");
        String category = "cyclicmagic.blocks.magicbean";
        this.allowBonemeal = config.getBoolean("MagicBeanBonemeal", category, true, "Allow bonemeal on magic bean");
        this.dropSeedOnHarvest = config.getBoolean("MagicBeanGrownDropSeed", category, false, "Allow dropping the seed item if fully grown.  (if its not grown it will still drop when broken)");
        ArrayList<String> deft = new ArrayList<String>();
        for (ItemStack drop : this.myDrops) {
            if (drop == null || drop.func_77973_b() == null) continue;
            String resource = drop.func_77973_b().getRegistryName().func_110624_b() + ":" + drop.func_77973_b().getRegistryName().func_110623_a();
            if (drop.func_77960_j() > 0) {
                resource = resource + "*" + drop.func_77960_j();
            }
            deft.add(resource);
        }
        this.myDropStrings = new ArrayList<String>(Arrays.asList(config.getStringList("MagicBeanDropList", category, deft.toArray(new String[0]), "Drop list")));
        if (this.myDropStrings.size() == 0) {
            this.myDropStrings.add("minecraft:dirt");
        }
    }
}

