/*
 * Decompiled with CFR 0.152.
 */
package com.corwinjv.mobtotems.items;

import com.corwinjv.mobtotems.blocks.TotemType;
import com.corwinjv.mobtotems.blocks.TotemWoodBlock;
import com.corwinjv.mobtotems.gui.CarvingSelectorGui;
import com.corwinjv.mobtotems.items.ModItem;
import com.corwinjv.mobtotems.network.ActivateKnifeMessage;
import com.corwinjv.mobtotems.network.Network;
import com.corwinjv.mobtotems.network.OpenKnifeGuiMessage;
import com.corwinjv.mobtotems.utils.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.ParticleBlockDust;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CarvingKnife
extends ModItem {
    private final String COMPOUND_TAG = "carving_knife";
    private final String SELECTED_CARVING_TAG = "selected_carving";
    boolean spawnParticles = false;

    @Override
    public void init() {
        super.init();
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            Network.sendToServer(new ActivateKnifeMessage().setHand(hand));
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    @SideOnly(value=Side.CLIENT)
    public void openGui(EntityPlayer player, int meta) {
        FMLClientHandler.instance().displayGuiScreen(player, (GuiScreen)new CarvingSelectorGui(meta));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        if (world.field_72995_K && entity instanceof EntityPlayer) {
            this.spawnParticles(stack, world, (EntityPlayer)entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(ItemStack stack, World world, EntityPlayer player) {
        long worldTime = world.func_72820_D();
        if (this.spawnParticles) {
            BlockPos pos;
            Block targetBlock;
            ParticleBlockDust.Factory particleFactory = new ParticleBlockDust.Factory();
            Vec3d posEyes = player.func_174824_e(1.0f);
            RayTraceResult rayTraceResult = world.func_72933_a(posEyes, posEyes.func_178787_e(player.func_70040_Z().func_186678_a(3.0)));
            if (rayTraceResult != null && (targetBlock = BlockUtils.getBlock(world, pos = rayTraceResult.func_178782_a())) != null && targetBlock instanceof TotemWoodBlock) {
                IBlockState state = world.func_180495_p(pos);
                int i = 4;
                for (int j = 0; j < 4; ++j) {
                    for (int k = 0; k < 4; ++k) {
                        for (int l = 0; l < 4; ++l) {
                            double d0 = ((double)j + 0.5) / 4.0;
                            double d1 = ((double)k + 0.5) / 4.0;
                            double d2 = ((double)l + 0.5) / 4.0;
                            double speedX = d0 - 0.5;
                            double speedY = d1 - 0.5;
                            double speedZ = d2 - 0.5;
                            Minecraft.func_71410_x().field_71452_i.func_78873_a(particleFactory.func_178902_a(EnumParticleTypes.BLOCK_DUST.func_179348_c(), world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, speedX *= 0.2, speedY *= 0.2, speedZ *= 0.2, new int[]{Block.func_176210_f((IBlockState)state)}));
                        }
                    }
                }
            }
            this.spawnParticles = false;
        }
    }

    public void onKnifeActivated(EntityPlayer player, EnumHand hand) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack stack = player.func_184586_b(hand);
        World world = player.field_70170_p;
        Vec3d posEyes = player.func_174824_e(1.0f);
        RayTraceResult rayTraceResult = world.func_72933_a(posEyes, posEyes.func_178787_e(player.func_70040_Z().func_186678_a(3.0)));
        if (stack.func_77973_b() instanceof CarvingKnife) {
            if (rayTraceResult != null) {
                BlockPos pos = rayTraceResult.func_178782_a();
                Block targetBlock = BlockUtils.getBlock(world, pos);
                if (targetBlock != null && targetBlock instanceof TotemWoodBlock && world.func_175656_a(pos, targetBlock.func_176223_P().func_177226_a(TotemWoodBlock.TOTEM_TYPE, (Comparable)((Object)TotemType.fromMeta(this.getSelectedCarving(stack)))))) {
                    player.func_184598_c(hand);
                    this.spawnParticles = true;
                }
            } else {
                Network.sendTo(new OpenKnifeGuiMessage().setMeta(this.getSelectedCarving(stack)), (EntityPlayerMP)player);
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 2;
    }

    public void setSelectedCarving(ItemStack stack, int selectedCarving) {
        if (stack.func_77978_p() == null) {
            this.initNbtData(stack);
        }
        NBTTagCompound tagCompound = (NBTTagCompound)stack.func_77978_p().func_74781_a("carving_knife");
        tagCompound.func_74768_a("selected_carving", selectedCarving);
        stack.func_77978_p().func_74782_a("carving_knife", (NBTBase)tagCompound);
    }

    public int getSelectedCarving(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            this.initNbtData(stack);
        }
        NBTTagCompound tagCompound = (NBTTagCompound)stack.func_77978_p().func_74781_a("carving_knife");
        return tagCompound.func_74762_e("selected_carving");
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        this.initNbtData(stack);
    }

    protected NBTTagCompound initNbtData(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74768_a("selected_carving", TotemType.NONE.getMeta());
        stack.func_77978_p().func_74782_a("carving_knife", (NBTBase)tagCompound);
        return stack.func_77978_p();
    }
}

