/*
 * Decompiled with CFR 0.152.
 */
package com.corwinjv.mobtotems.gui;

import com.corwinjv.mobtotems.blocks.TotemType;
import com.corwinjv.mobtotems.blocks.tiles.TotemTileEntity;
import com.corwinjv.mobtotems.gui.OfferingBoxContainer;
import com.corwinjv.mobtotems.gui.util;
import com.corwinjv.mobtotems.interfaces.IChargeableTileEntity;
import com.corwinjv.mobtotems.interfaces.IMultiblock;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class OfferingBoxGuiContainer
extends GuiContainer {
    private IChargeableTileEntity chargeableTileEntity = null;
    private IMultiblock<TotemType> multiblockTileEntity = null;
    private IInventory inventory = null;

    public OfferingBoxGuiContainer(InventoryPlayer inventoryPlayer, IInventory inventory) {
        super((Container)new OfferingBoxContainer(inventoryPlayer, inventory));
        this.inventory = inventory;
        if (inventory instanceof IChargeableTileEntity) {
            this.chargeableTileEntity = (IChargeableTileEntity)inventory;
        }
        if (inventory instanceof IMultiblock) {
            try {
                this.multiblockTileEntity = (IMultiblock)inventory;
            }
            catch (Exception e) {
                FMLLog.log((Level)Level.ERROR, (String)"OfferingBoxGuiContainer error in instantiation - unknown multiblock", (Object[])new Object[0]);
                e.printStackTrace();
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(util.getGuiResourceLocation("offering_box_gui.png"));
        this.func_73729_b(this.getGuiLeft(), this.getGuiTop(), 0, 0, 176, 166);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (this.chargeableTileEntity != null) {
            int chargeLevel = this.inventory.func_174887_a_(0);
            float chargeRatio = (float)chargeLevel / (float)this.chargeableTileEntity.getMaxChargeLevel();
            int chargeBottom = 65;
            int chargeLeft = 138;
            int chargeWidth = 8;
            OfferingBoxGuiContainer.func_73734_a((int)chargeLeft, (int)(chargeBottom - (int)(50.0f * chargeRatio)), (int)(chargeLeft + chargeWidth), (int)chargeBottom, (int)-16711936);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(chargeLeft - 14), (float)(chargeBottom + 2), (float)(100.0f + this.field_73735_i));
            GlStateManager.func_179139_a((double)0.6, (double)0.6, (double)1.0);
            String text = I18n.func_74837_a((String)"mobtotems:gui.offering_box.chargelevel", (Object[])new Object[0]);
            this.field_146289_q.func_175063_a(text, 0.0f, 0.0f, 0xFFFFFF);
            GlStateManager.func_179121_F();
        }
        if (this.multiblockTileEntity != null) {
            this.multiblockTileEntity.verifyMultiblock();
            if (this.multiblockTileEntity.getIsMaster()) {
                int totemTextTop = 20;
                String text = I18n.func_74837_a((String)"mobtotems:gui.offering_box.totems", (Object[])new Object[0]);
                GlStateManager.func_179094_E();
                GlStateManager.func_179139_a((double)0.7, (double)0.7, (double)1.0);
                this.field_146289_q.func_175063_a(text, 0.0f, (float)totemTextTop, 0xFFFFFF);
                List<BlockPos> slaves = this.multiblockTileEntity.getSlaves();
                int lines = 0;
                for (int i = slaves.size() - 1; i >= 0; --i) {
                    BlockPos slavePos = slaves.get(i);
                    TileEntity slaveTe = Minecraft.func_71410_x().field_71441_e.func_175625_s(slavePos);
                    if (!(slaveTe instanceof TotemTileEntity)) continue;
                    String text2 = "";
                    text2 = ((TotemTileEntity)slaveTe).getType() == TotemType.NONE ? I18n.func_74837_a((String)("tiles.mobtotems:totem_wood." + ((TotemTileEntity)slaveTe).getType().func_176610_l() + ".shortname"), (Object[])new Object[0]) : I18n.func_74837_a((String)("tiles.mobtotems:totem_wood." + ((TotemTileEntity)slaveTe).getType().func_176610_l() + ".name"), (Object[])new Object[0]);
                    this.field_146289_q.func_175063_a(text2, 0.0f, (float)((lines + 1) * 10 + totemTextTop), 0xFFFFFF);
                    ++lines;
                }
                GlStateManager.func_179121_F();
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }
}

