/*
 * Decompiled with CFR 0.152.
 */
package com.corwinjv.mobtotems.blocks;

import com.corwinjv.mobtotems.blocks.ModBlock;
import com.corwinjv.mobtotems.blocks.OfferingBox;
import com.corwinjv.mobtotems.blocks.TotemType;
import com.corwinjv.mobtotems.blocks.tiles.OfferingBoxTileEntity;
import com.corwinjv.mobtotems.blocks.tiles.TotemTileEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TotemWoodBlock
extends ModBlock
implements ITileEntityProvider {
    public static final PropertyEnum<TotemType> TOTEM_TYPE = PropertyEnum.func_177709_a((String)"totem_type", TotemType.class);
    public static final int MAX_MULTIBLOCK_RANGE = 9;

    TotemWoodBlock() {
        super(Material.field_151575_d);
        this.field_149758_A = true;
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.func_176223_P().func_177226_a(TOTEM_TYPE, (Comparable)((Object)TotemType.NONE)));
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (int i = 0; i < TotemType.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TOTEM_TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TOTEM_TYPE, (Comparable)((Object)TotemType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((TotemType)((Object)state.func_177229_b(TOTEM_TYPE))).getMeta();
    }

    @Nonnull
    public TileEntity func_149915_a(@Nullable World worldIn, int meta) {
        return new TotemTileEntity(TotemType.fromMeta(meta));
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        for (int i = worldIn.field_147482_g.size() - 1; i >= 0; --i) {
            TileEntity te = (TileEntity)worldIn.field_147482_g.get(i);
            if (!(te instanceof OfferingBoxTileEntity) || !(te.func_174877_v().func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) < 9.0)) continue;
            ((OfferingBoxTileEntity)te).verifyMultiblock();
            BlockPos offeringBoxPos = te.func_174877_v();
            Block offeringBoxBlock = worldIn.func_180495_p(offeringBoxPos).func_177230_c();
            if (!(offeringBoxBlock instanceof OfferingBox)) continue;
            ((OfferingBox)offeringBoxBlock).checkForDrop(worldIn, offeringBoxPos, worldIn.func_180495_p(offeringBoxPos));
        }
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176206_d(worldIn, pos, state);
        for (int i = worldIn.field_147482_g.size() - 1; i >= 0; --i) {
            TileEntity te = (TileEntity)worldIn.field_147482_g.get(i);
            if (!(te instanceof OfferingBoxTileEntity) || !(te.func_174877_v().func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) < 9.0)) continue;
            ((OfferingBoxTileEntity)te).invalidateSlaves();
            ((OfferingBoxTileEntity)te).verifyMultiblock();
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean isVisuallyOpaque() {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState blockState) {
        super.func_180663_b(world, pos, blockState);
    }
}

