/*
 * Decompiled with CFR 0.152.
 */
package com.corwinjv.mobtotems.blocks;

import com.corwinjv.mobtotems.blocks.IncenseKindlingBox;
import com.corwinjv.mobtotems.blocks.OfferingBox;
import com.corwinjv.mobtotems.blocks.SacredLightBlock;
import com.corwinjv.mobtotems.blocks.TotemType;
import com.corwinjv.mobtotems.blocks.TotemWoodBlock;
import com.corwinjv.mobtotems.blocks.items.TotemWoodItemBlock;
import com.corwinjv.mobtotems.blocks.tiles.IncenseKindlingBoxTileEntity;
import com.corwinjv.mobtotems.blocks.tiles.OfferingBoxTileEntity;
import com.corwinjv.mobtotems.blocks.tiles.SacredLightTileEntity;
import com.corwinjv.mobtotems.blocks.tiles.TotemTileEntity;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="mobtotems")
public class ModBlocks {
    public static final HashSet<ItemBlock> ITEM_BLOCKS = new HashSet();
    public static final String TOTEM_WOOD_NAME = "totem_wood";
    public static final String SACRED_LIGHT_NAME = "sacred_light";
    public static final String INCENSE_KINDLING_BOX_NAME = "incense_kindling_box";
    public static final String OFFERING_BOX_NAME = "offering_box";
    public static final Block TOTEM_WOOD = (Block)new TotemWoodBlock().func_149663_c("totem_wood").setRegistryName("mobtotems", "totem_wood");
    public static final Block SACRED_LIGHT = (Block)new SacredLightBlock().func_149663_c("sacred_light").setRegistryName("mobtotems", "sacred_light");
    public static final Block INCENSE_KINDLING_BOX = (Block)new IncenseKindlingBox().func_149663_c("incense_kindling_box").setRegistryName("mobtotems", "incense_kindling_box");
    public static final Block OFFERING_BOX = (Block)new OfferingBox().func_149663_c("offering_box").setRegistryName("mobtotems", "offering_box");

    public static void init() {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> e) {
        IForgeRegistry registry = e.getRegistry();
        Block[] blocks = new Block[]{TOTEM_WOOD, SACRED_LIGHT, INCENSE_KINDLING_BOX, OFFERING_BOX};
        registry.registerAll((IForgeRegistryEntry[])blocks);
    }

    @SubscribeEvent
    public static void registerItemBlocks(RegistryEvent.Register<Item> e) {
        ItemBlock[] items;
        IForgeRegistry registry = e.getRegistry();
        for (ItemBlock item : items = new ItemBlock[]{new TotemWoodItemBlock(TOTEM_WOOD), new ItemBlock(SACRED_LIGHT), new ItemBlock(INCENSE_KINDLING_BOX), new ItemBlock(OFFERING_BOX)}) {
            Block block = item.func_179223_d();
            ResourceLocation registryName = (ResourceLocation)Preconditions.checkNotNull((Object)block.getRegistryName(), (String)"Block %s has null registry name", (Object)block);
            registry.register(item.setRegistryName(registryName));
            ITEM_BLOCKS.add(item);
        }
        ModBlocks.registerTileEntities();
    }

    private static void registerTileEntities() {
        GameRegistry.registerTileEntity(TotemTileEntity.class, (String)"mobtotems:totem_wood");
        GameRegistry.registerTileEntity(SacredLightTileEntity.class, (String)"mobtotems:sacred_light");
        GameRegistry.registerTileEntity(IncenseKindlingBoxTileEntity.class, (String)"mobtotems:incense_kindling_box");
        GameRegistry.registerTileEntity(OfferingBoxTileEntity.class, (String)"mobtotems:offering_box");
    }

    @SubscribeEvent
    public static void registerRenders(ModelRegistryEvent e) {
        for (int i = 0; i < TotemType.values().length; ++i) {
            Item item = Item.func_150898_a((Block)TOTEM_WOOD);
            ModelResourceLocation modelResourceLocation = new ModelResourceLocation("mobtotems:totem_wood", "totem_type=" + TotemType.fromMeta(i).func_176610_l());
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)modelResourceLocation);
        }
        ModBlocks.registerRender(SACRED_LIGHT, SACRED_LIGHT_NAME);
        ModBlocks.registerRender(INCENSE_KINDLING_BOX, INCENSE_KINDLING_BOX_NAME);
        ModBlocks.registerRender(OFFERING_BOX, OFFERING_BOX_NAME);
    }

    private static void registerRender(Block block, String key) {
        Item item = Item.func_150898_a((Block)block);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("mobtotems:" + key, "inventory"));
    }
}

