/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.rgb16;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;

public class RGB16StackHelper {
    public static ItemStack setRGB16(ItemStack stack, String colorName) {
        return RGB16StackHelper.setRGB16(stack, RGB16Helper.getIndexFor(colorName));
    }

    public static ItemStack setRGB16(ItemStack stack, RGB16 rgb16) {
        return RGB16StackHelper.setRGB16(stack, rgb16.getIndex());
    }

    public static ItemStack setRGB16(ItemStack stack, short rgbIndex) {
        if (stack.func_77973_b() instanceof IRGB16_Item) {
            ((IRGB16_Item)stack.func_77973_b()).setRGB16(stack, rgbIndex);
        }
        return stack;
    }

    public static short getRGB16Index(ItemStack stack) {
        if (stack.func_77973_b() instanceof IRGB16_Item) {
            return ((IRGB16_Item)stack.func_77973_b()).getRGB16(stack);
        }
        return -1;
    }

    public static RGB16 getRGB16(ItemStack stack) {
        short index = RGB16StackHelper.getRGB16Index(stack);
        return index > 0 ? new RGB16(index) : null;
    }

    public static short readColorTag(ItemStack stack) {
        return RGB16StackHelper.readColorTag(stack, (short)4095);
    }

    public static short readColorTag(ItemStack stack, short defaultIndex) {
        NBTTagCompound nbt = RGB16StackHelper.getNBTTag(stack);
        if (!nbt.func_74764_b("rgb16")) {
            RGB16StackHelper.writeColorTags(stack, defaultIndex);
        }
        return nbt.func_74765_d("rgb16");
    }

    public static byte readSimpleColorTag(ItemStack stack) {
        return RGB16StackHelper.readSimpleColorTag(stack, (short)4095);
    }

    public static byte readSimpleColorTag(ItemStack stack, short defaultIndex) {
        NBTTagCompound nbt = RGB16StackHelper.getNBTTag(stack);
        if (!nbt.func_74764_b("rgbsimple")) {
            RGB16StackHelper.writeColorTags(stack, defaultIndex);
        }
        return nbt.func_74771_c("rgbsimple");
    }

    public static boolean writeColorTags(ItemStack stack, short rgbIndex) {
        rgbIndex = (short)MathHelper.func_76125_a((int)rgbIndex, (int)0, (int)4096);
        NBTTagCompound nbt = RGB16StackHelper.getNBTTag(stack);
        if (!nbt.func_74764_b("rgb16") || rgbIndex != RGB16StackHelper.readColorTag(stack)) {
            nbt.func_74777_a("rgb16", rgbIndex);
            nbt.func_74774_a("rgbsimple", RGB16Helper.getSimpleColor(rgbIndex));
            stack.func_77982_d(nbt);
            return true;
        }
        return false;
    }

    private static NBTTagCompound getNBTTag(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
    }
}

