/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.data;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class PortalLinkData {
    private int dimension;
    private BlockPos pos;
    private boolean caller;
    private String name;

    public PortalLinkData(int dimension, BlockPos pos, boolean caller) {
        this(dimension, pos, caller, "");
    }

    public PortalLinkData(int dimension, BlockPos pos, boolean caller, String name) {
        this.dimension = dimension;
        this.pos = pos;
        this.caller = caller;
        this.name = name;
    }

    public static PortalLinkData readFromNBT(NBTTagCompound compound) {
        return new PortalLinkData(compound.func_74762_e("Dimension"), BlockPos.func_177969_a((long)compound.func_74763_f("Position")), compound.func_74767_n("Caller"), compound.func_74779_i("Name"));
    }

    public int getDimension() {
        return this.dimension;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean isCaller() {
        return this.caller;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74768_a("Dimension", this.dimension);
        tagCompound.func_74772_a("Position", this.pos.func_177986_g());
        tagCompound.func_74757_a("Caller", this.caller);
        tagCompound.func_74778_a("Name", this.name);
        return tagCompound;
    }

    public static enum PortalCallType {
        NORMAL,
        SINGLE,
        FORCE;

    }
}

